/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.FontInfo;
import org.apache.fop.configuration.FontTriplet;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationParser
extends DefaultHandler {
    private final int OUT = 0;
    private final int IN_ENTRY = 1;
    private final int IN_KEY = 2;
    private final int IN_VALUE = 4;
    private final int IN_LIST = 8;
    private final int IN_SUBENTRY = 16;
    private final int IN_SUBKEY = 32;
    private final int IN_FONTS = 64;
    private final int IN_FONT = 128;
    private final int STRING = 0;
    private final int LIST = 1;
    private final int MAP = 2;
    private int status = 0;
    private int datatype = -1;
    private static Hashtable configuration;
    private static Hashtable activeConfiguration;
    private String key = "";
    private Vector keyStack = new Vector();
    private String value = "";
    private String subkey = "";
    private Vector list = new Vector(15);
    private Hashtable map = new Hashtable(15);
    private Locator locator;
    private String role = "standard";
    private Vector fontList = null;
    private FontInfo fontInfo = null;
    private FontTriplet fontTriplet = null;
    private String fontName;
    private String metricsFile;
    private String embedFile;
    private String kerningAsString;
    private boolean kerning;
    private Vector fontTriplets;
    private String fontTripletName;
    private String weight;
    private String style;

    public void characters(char[] cArray, int n, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        String string = new String(cArray2);
        switch (this.status) {
            case 2: {
                this.key = string;
                break;
            }
            case 26: {
                this.subkey = string;
                break;
            }
            case 4: {
                this.value = string;
                this.datatype = 0;
                break;
            }
            case 12: {
                this.list.addElement(string);
                this.datatype = 1;
                break;
            }
            case 28: {
                this.value = string;
                this.datatype = 2;
                break;
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (string2.equals("entry")) {
            switch (this.datatype) {
                case 0: {
                    this.store(this.role, this.key, this.value);
                    break;
                }
                case 1: {
                    this.store(this.role, this.key, this.list);
                    break;
                }
                case 2: {
                    this.store(this.role, this.key, this.map);
                }
            }
            this.status = 0;
            this.role = "standard";
            if (this.keyStack.size() > 0) {
                this.keyStack.removeElementAt(this.keyStack.size() - 1);
            }
            this.key = this.keyStack.size() > 0 ? (String)this.keyStack.elementAt(this.keyStack.size() - 1) : "";
            this.value = "";
        } else if (string2.equals("subentry")) {
            this.map.put(this.subkey, this.value);
            this.status -= 16;
            if (this.keyStack.size() > 0) {
                this.keyStack.removeElementAt(this.keyStack.size() - 1);
            }
            this.key = this.keyStack.size() > 0 ? (String)this.keyStack.elementAt(this.keyStack.size() - 1) : "";
            this.value = "";
        } else if (string2.equals("key")) {
            this.status -= 2;
            this.keyStack.addElement(this.key);
        } else if (string2.equals("list")) {
            this.status -= 8;
            this.value = "";
        } else if (string2.equals("value")) {
            this.status -= 4;
        } else if (string2.equals("fonts")) {
            this.store("standard", "fonts", this.fontList);
        } else if (string2.equals("font")) {
            this.fontInfo = new FontInfo(this.fontName, this.metricsFile, this.kerning, this.fontTriplets, this.embedFile);
            this.fontList.addElement(this.fontInfo);
            this.fontTriplets = null;
            this.metricsFile = null;
            this.embedFile = null;
            this.fontName = null;
            this.kerningAsString = "";
        } else {
            string2.equals("font-triplet");
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() {
        configuration = Configuration.getConfiguration();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string2.equals("key")) {
            this.status += 2;
        } else if (string2.equals("value")) {
            this.status += 4;
        } else if (string2.equals("list")) {
            this.status += 8;
        } else if (string2.equals("subentry")) {
            this.status += 16;
        } else if (string2.equals("entry")) {
            this.role = attributes.getLength() == 0 ? "standard" : attributes.getValue("role");
        } else if (!string2.equals("configuration")) {
            if (string2.equals("fonts")) {
                this.fontList = new Vector(10);
            } else if (string2.equals("font")) {
                this.kerningAsString = attributes.getValue("kerning");
                this.kerning = this.kerningAsString.equalsIgnoreCase("yes");
                this.metricsFile = attributes.getValue("metrics-file");
                this.embedFile = attributes.getValue("embed-file");
                this.fontName = attributes.getValue("name");
                this.fontTriplets = new Vector(5);
            } else if (string2.equals("font-triplet")) {
                this.fontTripletName = attributes.getValue("name");
                this.weight = attributes.getValue("weight");
                this.style = attributes.getValue("style");
                this.fontTriplet = new FontTriplet(this.fontTripletName, this.weight, this.style);
                this.fontTriplets.addElement(this.fontTriplet);
            } else {
                MessageHandler.errorln("Unknown tag in configuration file: " + string2);
            }
        }
    }

    private void store(String string, String string2, Object object) {
        activeConfiguration = (Hashtable)configuration.get(string);
        if (activeConfiguration != null) {
            activeConfiguration.put(string2, object);
        } else {
            MessageHandler.errorln("Unknown role >" + string + "< for new configuration entry. \n" + "Putting configuration with key:" + string2 + " into standard configuration.");
        }
    }
}

