/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.io.IOException;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.ConfigurationParser;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ConfigurationReader {
    private static boolean errorDump = false;
    private InputSource filename;

    public ConfigurationReader(InputSource inputSource) {
        this.filename = inputSource;
    }

    public static XMLReader createParser() throws FOPException {
        String string = Driver.getParserClassName();
        if (errorDump) {
            MessageHandler.logln("configuration reader using SAX parser " + string);
        }
        try {
            return (XMLReader)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FOPException("Could not find " + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new FOPException("Could not instantiate " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FOPException("Could not access " + string, illegalAccessException);
        }
        catch (ClassCastException classCastException) {
            throw new FOPException(String.valueOf(string) + " is not a SAX driver", classCastException);
        }
    }

    public void dumpError(Exception exception) {
        if (errorDump) {
            if (exception instanceof SAXException) {
                exception.printStackTrace();
                if (((SAXException)exception).getException() != null) {
                    ((SAXException)exception).getException().printStackTrace();
                }
            } else {
                exception.printStackTrace();
            }
        }
    }

    public void setDumpError(boolean bl) {
        errorDump = bl;
    }

    public void start() throws FOPException {
        XMLReader xMLReader = ConfigurationReader.createParser();
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException sAXException) {
            throw new FOPException("You need a parser which supports SAX version 2", sAXException);
        }
        ConfigurationParser configurationParser = new ConfigurationParser();
        xMLReader.setContentHandler(configurationParser);
        try {
            xMLReader.parse(this.filename);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof FOPException) {
                throw (FOPException)sAXException.getException();
            }
            throw new FOPException(sAXException);
        }
        catch (IOException iOException) {
            throw new FOPException(iOException);
        }
    }
}

