/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.messaging.MessageHandler;

public class Length {
    public static final Length AUTO = new Length(0);
    protected int millipoints = 0;
    protected boolean bIsComputed = false;
    private boolean bAuto = false;

    static {
        Length.AUTO.bAuto = true;
    }

    public Length(double d, int n) {
        this.millipoints = (int)(d * (double)n);
        this.setIsComputed(true);
    }

    public Length(double d, String string) {
        this.convert(d, string);
    }

    public Length(int n) {
        this.millipoints = n;
        this.setIsComputed(true);
    }

    protected int computeValue() {
        return this.millipoints;
    }

    protected void convert(double d, String string) {
        boolean bl = true;
        if (string.equals("in")) {
            d *= 72.0;
        } else if (string.equals("cm")) {
            d *= 28.3464567;
        } else if (string.equals("mm")) {
            d *= 2.83464567;
        } else if (!string.equals("pt")) {
            if (string.equals("pc")) {
                d *= 12.0;
            } else if (string.equals("px")) {
                d *= (double)bl;
            } else {
                d = 0.0;
                MessageHandler.errorln("unknown length unit '" + string + "'");
            }
        }
        this.millipoints = (int)(d * 1000.0);
        this.setIsComputed(true);
    }

    public double getTableUnits() {
        return 0.0;
    }

    public boolean isAuto() {
        return this.bAuto;
    }

    public int mvalue() {
        if (!this.bIsComputed) {
            this.millipoints = this.computeValue();
        }
        return this.millipoints;
    }

    protected void setIsComputed(boolean bl) {
        this.bIsComputed = bl;
    }

    protected void setValue(int n) {
        this.millipoints = n;
        this.setIsComputed(true);
    }

    public String toString() {
        String string = String.valueOf(this.millipoints) + "mpt";
        return string;
    }
}

