/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import java.util.Hashtable;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentLength;
import org.apache.fop.fo.ColorTypeProperty;
import org.apache.fop.fo.LengthProperty;
import org.apache.fop.fo.ListProperty;
import org.apache.fop.fo.NumberProperty;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.StringProperty;
import org.apache.fop.fo.expr.AbsFunction;
import org.apache.fop.fo.expr.BodyStartFunction;
import org.apache.fop.fo.expr.CeilingFunction;
import org.apache.fop.fo.expr.FloorFunction;
import org.apache.fop.fo.expr.FopPropValFunction;
import org.apache.fop.fo.expr.FromParentFunction;
import org.apache.fop.fo.expr.FromTableColumnFunction;
import org.apache.fop.fo.expr.Function;
import org.apache.fop.fo.expr.InheritedPropFunction;
import org.apache.fop.fo.expr.LabelEndFunction;
import org.apache.fop.fo.expr.MaxFunction;
import org.apache.fop.fo.expr.MinFunction;
import org.apache.fop.fo.expr.NCnameProperty;
import org.apache.fop.fo.expr.NearestSpecPropFunction;
import org.apache.fop.fo.expr.Numeric;
import org.apache.fop.fo.expr.NumericProperty;
import org.apache.fop.fo.expr.PPColWidthFunction;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.PropertyTokenizer;
import org.apache.fop.fo.expr.RGBColorFunction;
import org.apache.fop.fo.expr.RoundFunction;

public class PropertyParser
extends PropertyTokenizer {
    private PropertyInfo propInfo;
    private static final String RELUNIT = "em";
    private static final Numeric negOne = new Numeric(new Double(-1.0));
    private static final Hashtable functionTable = new Hashtable();

    static {
        functionTable.put("ceiling", new CeilingFunction());
        functionTable.put("floor", new FloorFunction());
        functionTable.put("round", new RoundFunction());
        functionTable.put("min", new MinFunction());
        functionTable.put("max", new MaxFunction());
        functionTable.put("abs", new AbsFunction());
        functionTable.put("rgb", new RGBColorFunction());
        functionTable.put("from-table-column", new FromTableColumnFunction());
        functionTable.put("inherited-property-value", new InheritedPropFunction());
        functionTable.put("from-parent", new FromParentFunction());
        functionTable.put("from-nearest-specified-value", new NearestSpecPropFunction());
        functionTable.put("proportional-column-width", new PPColWidthFunction());
        functionTable.put("label-end", new LabelEndFunction());
        functionTable.put("body-start", new BodyStartFunction());
        functionTable.put("_fop-property-value", new FopPropValFunction());
    }

    private PropertyParser(String string, PropertyInfo propertyInfo) {
        super(string);
        this.propInfo = propertyInfo;
    }

    private Property evalAddition(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in addition");
        }
        return new NumericProperty(numeric.add(numeric2));
    }

    private Property evalDivide(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in division");
        }
        return new NumericProperty(numeric.divide(numeric2));
    }

    private Property evalModulo(Number number, Number number2) throws PropertyException {
        if (number == null || number2 == null) {
            throw new PropertyException("Non number operand to modulo");
        }
        return new NumberProperty(number.doubleValue() % number2.doubleValue());
    }

    private Property evalMultiply(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in multiplication");
        }
        return new NumericProperty(numeric.multiply(numeric2));
    }

    private Property evalNegate(Numeric numeric) throws PropertyException {
        if (numeric == null) {
            throw new PropertyException("Non numeric operand to unary minus");
        }
        return new NumericProperty(numeric.multiply(negOne));
    }

    private Property evalSubtraction(Numeric numeric, Numeric numeric2) throws PropertyException {
        if (numeric == null || numeric2 == null) {
            throw new PropertyException("Non numeric operand in subtraction");
        }
        return new NumericProperty(numeric.subtract(numeric2));
    }

    private final void expectRpar() throws PropertyException {
        if (this.currentToken != 4) {
            throw new PropertyException("expected )");
        }
        this.next();
    }

    public static Property parse(String string, PropertyInfo propertyInfo) throws PropertyException {
        return new PropertyParser(string, propertyInfo).parseProperty();
    }

    private Property parseAdditiveExpr() throws PropertyException {
        Property property = this.parseMultiplicativeExpr();
        block4: while (true) {
            switch (this.currentToken) {
                case 8: {
                    this.next();
                    property = this.evalAddition(property.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
                case 9: {
                    this.next();
                    property = this.evalSubtraction(property.getNumeric(), this.parseMultiplicativeExpr().getNumeric());
                    continue block4;
                }
            }
            break;
        }
        return property;
    }

    Property[] parseArgs(int n) throws PropertyException {
        Property[] propertyArray = new Property[n];
        int n2 = 0;
        if (this.currentToken == 4) {
            this.next();
        } else {
            while (true) {
                Property property = this.parseAdditiveExpr();
                if (n2 < n) {
                    propertyArray[n2++] = property;
                }
                if (this.currentToken != 13) break;
                this.next();
            }
            this.expectRpar();
        }
        if (n != n2) {
            throw new PropertyException("Wrong number of args for function");
        }
        return propertyArray;
    }

    private Property parseMultiplicativeExpr() throws PropertyException {
        Property property = this.parseUnaryExpr();
        block5: while (true) {
            switch (this.currentToken) {
                case 11: {
                    this.next();
                    property = this.evalDivide(property.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
                case 10: {
                    this.next();
                    property = this.evalModulo(property.getNumber(), this.parseUnaryExpr().getNumber());
                    continue block5;
                }
                case 2: {
                    this.next();
                    property = this.evalMultiply(property.getNumeric(), this.parseUnaryExpr().getNumeric());
                    continue block5;
                }
            }
            break;
        }
        return property;
    }

    private Property parsePrimaryExpr() throws PropertyException {
        Property property;
        switch (this.currentToken) {
            case 3: {
                this.next();
                Property property2 = this.parseAdditiveExpr();
                this.expectRpar();
                return property2;
            }
            case 5: {
                property = new StringProperty(this.currentTokenValue);
                break;
            }
            case 1: {
                property = new NCnameProperty(this.currentTokenValue);
                break;
            }
            case 16: {
                property = new NumberProperty(new Double(this.currentTokenValue));
                break;
            }
            case 17: {
                property = new NumberProperty(new Integer(this.currentTokenValue));
                break;
            }
            case 14: {
                double d = new Double(this.currentTokenValue.substring(0, this.currentTokenValue.length() - 1)) / 100.0;
                PercentBase percentBase = this.propInfo.getPercentBase();
                if (percentBase != null) {
                    if (percentBase.getDimension() == 0) {
                        property = new NumberProperty(d * percentBase.getBaseValue());
                        break;
                    }
                    if (percentBase.getDimension() == 1) {
                        property = new LengthProperty(new PercentLength(d, percentBase));
                        break;
                    }
                    throw new PropertyException("Illegal percent dimension value");
                }
                property = new NumberProperty(d);
                break;
            }
            case 12: {
                int n = this.currentTokenValue.length() - this.currentUnitLength;
                String string = this.currentTokenValue.substring(n);
                Double d = new Double(this.currentTokenValue.substring(0, n));
                Length length = null;
                length = string.equals(RELUNIT) ? new Length((double)d, this.propInfo.currentFontSize()) : new Length((double)d, string);
                if (length == null) {
                    throw new PropertyException("unrecognized unit name: " + this.currentTokenValue);
                }
                property = new LengthProperty(length);
                break;
            }
            case 15: {
                property = new ColorTypeProperty(new ColorType(this.currentTokenValue));
                break;
            }
            case 7: {
                Function function = (Function)functionTable.get(this.currentTokenValue);
                if (function == null) {
                    throw new PropertyException("no such function: " + this.currentTokenValue);
                }
                this.next();
                this.propInfo.pushFunction(function);
                Property property3 = function.eval(this.parseArgs(function.nbArgs()), this.propInfo);
                this.propInfo.popFunction();
                return property3;
            }
            default: {
                throw new PropertyException("syntax error");
            }
        }
        this.next();
        return property;
    }

    private Property parseProperty() throws PropertyException {
        this.next();
        if (this.currentToken == 0) {
            return new StringProperty("");
        }
        ListProperty listProperty = null;
        while (true) {
            Property property = this.parseAdditiveExpr();
            if (this.currentToken == 0) {
                if (listProperty != null) {
                    listProperty.addProperty(property);
                    return listProperty;
                }
                return property;
            }
            if (listProperty == null) {
                listProperty = new ListProperty(property);
                continue;
            }
            listProperty.addProperty(property);
        }
    }

    private Property parseUnaryExpr() throws PropertyException {
        if (this.currentToken == 9) {
            this.next();
            return this.evalNegate(this.parseUnaryExpr().getNumeric());
        }
        return this.parsePrimaryExpr();
    }
}

