/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;

public class Block
extends FObjMixed {
    int align;
    int alignLast;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int textIndent;
    int keepWithNext;
    ColorType backgroundColor;
    int blockWidows;
    int blockOrphans;
    int areaHeight = 0;
    int contentWidth = 0;
    String id;
    int span;
    boolean anythingLaidOut = false;

    public Block(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:block";
        this.span = this.properties.get("span").getEnum();
    }

    public int getAreaHeight() {
        return this.areaHeight;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getSpan() {
        return this.span;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
            AuralProps auralProps = this.propMgr.getAuralProps();
            BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
            object2 = this.propMgr.getBackgroundProps();
            object = this.propMgr.getHyphenationProps();
            MarginProps marginProps = this.propMgr.getMarginProps();
            RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.textIndent = this.properties.get("text-indent").getLength().mvalue();
            this.keepWithNext = this.properties.get("keep-with-next").getEnum();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.blockWidows = this.properties.get("widows").getNumber().intValue();
            this.blockOrphans = this.properties.get("orphans").getNumber().intValue();
            this.id = this.properties.get("id").getString();
            if (area instanceof BlockArea) {
                area.end();
            }
            if (area.getIDReferences() != null) {
                area.getIDReferences().createID(this.id);
            }
            this.marker = 0;
            int n = this.propMgr.checkBreakBefore(area);
            if (n != 1) {
                return new Status(n);
            }
            int n2 = this.children.size();
            int n3 = 0;
            while (n3 < n2) {
                FONode fONode = (FONode)this.children.elementAt(n3);
                if (fONode instanceof FOText) {
                    if (((FOText)fONode).willCreateArea()) {
                        fONode.setWidows(this.blockWidows);
                        break;
                    }
                    this.children.removeElementAt(n3);
                    n2 = this.children.size();
                    --n3;
                } else {
                    fONode.setWidows(this.blockWidows);
                    break;
                }
                ++n3;
            }
            int n4 = n2 - 1;
            while (n4 >= 0) {
                FONode fONode = (FONode)this.children.elementAt(n4);
                if (fONode instanceof FOText) {
                    if (((FOText)fONode).willCreateArea()) {
                        fONode.setOrphans(this.blockOrphans);
                        break;
                    }
                } else {
                    fONode.setOrphans(this.blockOrphans);
                    break;
                }
                --n4;
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.anythingLaidOut) {
            this.textIndent = 0;
        }
        if (this.marker == 0 && area.getIDReferences() != null) {
            area.getIDReferences().configureID(this.id, area);
        }
        int n = area.spaceLeft();
        BlockArea blockArea = new BlockArea(this.propMgr.getFontState(area.getFontInfo()), area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, this.textIndent, this.align, this.alignLast, this.lineHeight);
        blockArea.setGeneratedBy(this);
        ++this.areasGenerated;
        if (this.areasGenerated == 1) {
            blockArea.isFirst(true);
        }
        blockArea.addLineagePair(this, this.areasGenerated);
        if (this.hasMarkers()) {
            blockArea.addMarkers(this.getMarkers());
        }
        blockArea.setParent(area);
        blockArea.setPage(area.getPage());
        blockArea.setBackgroundColor(this.backgroundColor);
        blockArea.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        blockArea.setHyphenation(this.propMgr.getHyphenationProps());
        blockArea.start();
        blockArea.setAbsoluteHeight(area.getAbsoluteHeight());
        blockArea.setIDReferences(area.getIDReferences());
        blockArea.setTableCellXOffset(area.getTableCellXOffset());
        int n5 = this.children.size();
        int n6 = this.marker;
        while (n6 < n5) {
            object2 = (FONode)this.children.elementAt(n6);
            object = ((FONode)object2).layout(blockArea);
            if (((Status)object).isIncomplete()) {
                this.marker = n6;
                if (((Status)object).getCode() == 2) {
                    if (n6 != 0) {
                        object = new Status(3);
                        area.addChild(blockArea);
                        area.setMaxHeight(area.getMaxHeight() - n + blockArea.getMaxHeight());
                        area.increaseHeight(blockArea.getHeight());
                        area.setAbsoluteHeight(blockArea.getAbsoluteHeight());
                        this.anythingLaidOut = true;
                        return object;
                    }
                    this.anythingLaidOut = false;
                    return object;
                }
                area.addChild(blockArea);
                area.setMaxHeight(area.getMaxHeight() - n + blockArea.getMaxHeight());
                area.increaseHeight(blockArea.getHeight());
                area.setAbsoluteHeight(blockArea.getAbsoluteHeight());
                this.anythingLaidOut = true;
                return object;
            }
            this.anythingLaidOut = true;
            ++n6;
        }
        blockArea.end();
        area.setMaxHeight(area.getMaxHeight() - n + blockArea.getMaxHeight());
        area.addChild(blockArea);
        area.increaseHeight(blockArea.getHeight());
        area.setAbsoluteHeight(blockArea.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        this.areaHeight = blockArea.getHeight();
        this.contentWidth = blockArea.getContentWidth();
        int n7 = this.propMgr.checkBreakAfter(area);
        if (n7 != 1) {
            this.marker = -1001;
            blockArea = null;
            return new Status(n7);
        }
        if (this.keepWithNext != 0) {
            blockArea = null;
            return new Status(8);
        }
        blockArea.isLast(true);
        blockArea = null;
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Block(fObj, propertyList);
        }
    }
}

