/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.AbsolutePositionProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.MarginProps;

public class BlockContainer
extends FObj {
    ColorType backgroundColor;
    int position;
    int top;
    int bottom;
    int left;
    int right;
    int width;
    int height;
    int span;
    AreaContainer areaContainer;
    PageSequence pageSequence;

    protected BlockContainer(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:block-container";
        this.span = this.properties.get("span").getEnum();
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    public int getContentWidth() {
        if (this.areaContainer != null) {
            return this.areaContainer.getContentWidth();
        }
        return 0;
    }

    public int getSpan() {
        return this.span;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        if (this.marker == -1000) {
            AbsolutePositionProps absolutePositionProps = this.propMgr.getAbsolutePositionProps();
            object2 = this.propMgr.getBorderAndPadding();
            BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
            MarginProps marginProps = this.propMgr.getMarginProps();
            this.marker = 0;
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.position = this.properties.get("position").getEnum();
            this.top = this.properties.get("top").getLength().mvalue();
            this.bottom = this.properties.get("bottom").getLength().mvalue();
            this.left = this.properties.get("left").getLength().mvalue();
            this.right = this.properties.get("right").getLength().mvalue();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.span = this.properties.get("span").getEnum();
            object = this.properties.get("id").getString();
            area.getIDReferences().initializeID((String)object, area);
        }
        boolean bl = false;
        object2 = (AreaContainer)area;
        if (this.width == 0 && this.height == 0) {
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
        }
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(((Area)object2).getFontInfo()), ((AreaContainer)object2).getXPosition() + this.left, ((AreaContainer)object2).getYPosition() - this.top, this.width, this.height, this.position);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            object = (FObj)this.children.elementAt(n2);
            Status status = ((FObj)object).layout(this.areaContainer);
            status.isIncomplete();
            if (status.getCode() == 8) {
                bl = true;
            }
            ++n2;
        }
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        this.areaContainer.end();
        if (this.position == 1) {
            this.areaContainer.setHeight(this.height);
        }
        area.addChild(this.areaContainer);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new BlockContainer(fObj, propertyList);
        }
    }
}

