/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableFooter;
import org.apache.fop.fo.flow.TableHeader;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;

public class Table
extends FObj {
    int breakBefore;
    int breakAfter;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    int width;
    int height;
    String id;
    TableHeader tableHeader = null;
    TableFooter tableFooter = null;
    boolean omitHeaderAtBreak = false;
    boolean omitFooterAtBreak = false;
    Vector columns = new Vector();
    int bodyCount = 0;
    AreaContainer areaContainer;

    public Table(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table";
    }

    private void findColumns(Area area) throws FOPException {
        int n = 1;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            FONode fONode = (FONode)enumeration.nextElement();
            if (!(fONode instanceof TableColumn)) continue;
            TableColumn tableColumn = (TableColumn)fONode;
            tableColumn.doSetup(area);
            int n2 = tableColumn.getNumColumnsRepeated();
            int n3 = tableColumn.getColumnNumber();
            if (n3 == 0) {
                n3 = n;
            }
            int n4 = 0;
            while (n4 < n2) {
                if (n3 > this.columns.size()) {
                    this.columns.setSize(n3);
                }
                if (this.columns.elementAt(n3 - 1) != null) {
                    this.log.warn("More than one column object assigned to column " + n3);
                }
                this.columns.setElementAt(tableColumn, n3 - 1);
                ++n3;
                ++n4;
            }
            n = n3;
        }
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    public int getContentWidth() {
        if (this.areaContainer != null) {
            return this.areaContainer.getContentWidth();
        }
        return 0;
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
            AuralProps auralProps = this.propMgr.getAuralProps();
            BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
            BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
            MarginProps marginProps = this.propMgr.getMarginProps();
            object = this.propMgr.getRelativePositionProps();
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.id = this.properties.get("id").getString();
            this.omitHeaderAtBreak = this.properties.get("table-omit-header-at-break").getEnum() == 81;
            boolean bl = this.omitFooterAtBreak = this.properties.get("table-omit-footer-at-break").getEnum() == 81;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.areaContainer == null) {
                area.getIDReferences().createID(this.id);
            }
            this.marker = 0;
            if (this.breakBefore == 58) {
                return new Status(4);
            }
            if (this.breakBefore == 55) {
                return new Status(6);
            }
            if (this.breakBefore == 26) {
                return new Status(5);
            }
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.marker == 0 && this.areaContainer == null) {
            area.getIDReferences().configureID(this.id, area);
        }
        int n = area.spaceLeft();
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), 0, 0, area.getAllocationWidth(), area.spaceLeft(), 73);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.children.size();
        if (this.columns.size() == 0) {
            this.findColumns(this.areaContainer);
        }
        this.areaContainer.setAllocationWidth(this.layoutColumns(this.areaContainer));
        int n3 = this.marker;
        while (n3 < n2) {
            object = (FONode)this.children.elementAt(n3);
            if (object instanceof TableHeader) {
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                this.tableHeader = (TableHeader)object;
                this.tableHeader.setColumns(this.columns);
            } else if (object instanceof TableFooter) {
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                this.tableFooter = (TableFooter)object;
                this.tableFooter.setColumns(this.columns);
            } else if (object instanceof TableBody) {
                Status status;
                if (this.columns.size() == 0) {
                    this.log.warn("current implementation of tables requires a table-column for each column, indicating column-width");
                    return new Status(1);
                }
                if (this.tableHeader != null && !bl) {
                    status = this.tableHeader.layout(this.areaContainer);
                    if (status.isIncomplete()) {
                        this.tableHeader.resetMarker();
                        return new Status(2);
                    }
                    bl = true;
                    this.tableHeader.resetMarker();
                    area.setMaxHeight(area.getMaxHeight() - n + this.areaContainer.getMaxHeight());
                }
                if (this.tableFooter != null && !this.omitFooterAtBreak && !bl2) {
                    status = this.tableFooter.layout(this.areaContainer);
                    if (status.isIncomplete()) {
                        return new Status(2);
                    }
                    bl2 = true;
                    this.tableFooter.resetMarker();
                }
                ((FONode)object).setWidows(this.widows);
                ((FONode)object).setOrphans(this.orphans);
                ((TableBody)object).setColumns(this.columns);
                status = ((FONode)object).layout(this.areaContainer);
                if (status.isIncomplete()) {
                    this.marker = n3;
                    if (this.bodyCount == 0 && status.getCode() == 2) {
                        if (this.tableHeader != null) {
                            this.tableHeader.removeLayout(this.areaContainer);
                        }
                        if (this.tableFooter != null) {
                            this.tableFooter.removeLayout(this.areaContainer);
                        }
                        this.resetMarker();
                    }
                    if (this.areaContainer.getContentHeight() > 0) {
                        area.addChild(this.areaContainer);
                        area.increaseHeight(this.areaContainer.getHeight());
                        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                        if (this.omitHeaderAtBreak) {
                            this.tableHeader = null;
                        }
                        if (this.tableFooter != null && !this.omitFooterAtBreak) {
                            ((TableBody)object).setYPosition(this.tableFooter.getYPosition());
                            this.tableFooter.setYPosition(this.tableFooter.getYPosition() + ((TableBody)object).getHeight());
                        }
                        this.setupColumnHeights();
                        status = new Status(3);
                    }
                    return status;
                }
                ++this.bodyCount;
                area.setMaxHeight(area.getMaxHeight() - n + this.areaContainer.getMaxHeight());
                if (this.tableFooter != null && !this.omitFooterAtBreak) {
                    ((TableBody)object).setYPosition(this.tableFooter.getYPosition());
                    this.tableFooter.setYPosition(this.tableFooter.getYPosition() + ((TableBody)object).getHeight());
                }
            }
            ++n3;
        }
        if (this.tableFooter != null && this.omitFooterAtBreak && this.tableFooter.layout(this.areaContainer).isIncomplete()) {
            this.log.warn("footer could not fit on page, moving last body row to next page");
            area.addChild(this.areaContainer);
            area.increaseHeight(this.areaContainer.getHeight());
            area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
            if (this.omitHeaderAtBreak) {
                this.tableHeader = null;
            }
            this.tableFooter.removeLayout(this.areaContainer);
            this.tableFooter.resetMarker();
            return new Status(3);
        }
        if (this.height != 0) {
            this.areaContainer.setHeight(this.height);
        }
        this.setupColumnHeights();
        this.areaContainer.end();
        area.addChild(this.areaContainer);
        area.increaseHeight(this.areaContainer.getHeight());
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 58) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 55) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 26) {
            this.marker = -1001;
            return new Status(5);
        }
        return new Status(1);
    }

    private int layoutColumns(Area area) throws FOPException {
        int n = 0;
        int n2 = 1;
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (tableColumn == null) {
                this.log.warn("No table-column specified in column " + n2);
            } else {
                tableColumn.setColumnOffset(n);
                tableColumn.layout(area);
                n += tableColumn.getColumnWidth();
            }
            ++n2;
        }
        return n;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected void setupColumnHeights() {
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (tableColumn == null) continue;
            tableColumn.setHeight(this.areaContainer.getContentHeight());
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Table(fObj, propertyList);
        }
    }
}

