/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.RowSpanMgr;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RelativePositionProps;

public class TableBody
extends FObj {
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    String id;
    Vector columns;
    RowSpanMgr rowSpanMgr;
    AreaContainer areaContainer;

    public TableBody(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-body";
    }

    public int getHeight() {
        return this.areaContainer.getHeight() + this.spaceBefore + this.spaceAfter;
    }

    public int getYPosition() {
        return this.areaContainer.getCurrentYPosition();
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Vector<BackgroundProps> vector;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
            vector = this.propMgr.getAuralProps();
            BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
            object = this.propMgr.getBackgroundProps();
            RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.id = this.properties.get("id").getString();
            area.getIDReferences().createID(this.id);
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.rowSpanMgr == null) {
                this.rowSpanMgr = new RowSpanMgr(this.columns.size());
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.increaseHeight(this.spaceBefore);
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        int n = area.spaceLeft();
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), 0, area.getContentHeight(), area.getContentWidth(), area.spaceLeft(), 61);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        vector = new Vector();
        int n2 = this.children.size();
        object = null;
        boolean bl = true;
        int n3 = this.marker;
        while (n3 < n2) {
            Object e = this.children.elementAt(n3);
            if (!(e instanceof TableRow)) {
                throw new FOPException("Currently only Table Rows are supported in table body, header and footer");
            }
            TableRow tableRow = (TableRow)e;
            tableRow.setRowSpanMgr(this.rowSpanMgr);
            tableRow.setColumns(this.columns);
            tableRow.doSetup(this.areaContainer);
            if (tableRow.getKeepWithPrevious().getType() != "KEEP_WITH_AUTO" && object != null && vector.indexOf(object) == -1) {
                vector.addElement((BackgroundProps)object);
            } else if (bl && vector.size() > 0) {
                vector = new Vector<BackgroundProps>();
            }
            Status status = tableRow.layout(this.areaContainer);
            if (status.isIncomplete()) {
                if (status.isPageBreak()) {
                    this.marker = n3;
                    area.addChild(this.areaContainer);
                    area.increaseHeight(this.areaContainer.getHeight());
                    area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                    if (n3 == n2 - 1) {
                        this.marker = -1001;
                        if (this.spaceAfter != 0) {
                            area.increaseHeight(this.spaceAfter);
                        }
                    }
                    return status;
                }
                if (vector.size() > 0) {
                    tableRow.removeLayout(this.areaContainer);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        TableRow tableRow2 = (TableRow)enumeration.nextElement();
                        tableRow2.removeLayout(this.areaContainer);
                        --n3;
                    }
                    if (n3 == 0) {
                        this.resetMarker();
                        return new Status(2);
                    }
                }
                this.marker = n3;
                if (n3 != 0 && status.getCode() == 2) {
                    status = new Status(3);
                }
                if (n3 != 0 || this.areaContainer.getContentHeight() > 0) {
                    area.addChild(this.areaContainer);
                    area.increaseHeight(this.areaContainer.getHeight());
                    area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                }
                return status;
            }
            if (status.getCode() == 8 || this.rowSpanMgr.hasUnfinishedSpans()) {
                vector.addElement((BackgroundProps)((Object)tableRow));
                bl = false;
            } else {
                bl = true;
            }
            object = tableRow;
            area.setMaxHeight(area.getMaxHeight() - n + this.areaContainer.getMaxHeight());
            n = area.spaceLeft();
            ++n3;
        }
        area.addChild(this.areaContainer);
        this.areaContainer.end();
        area.increaseHeight(this.areaContainer.getHeight());
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.increaseHeight(this.spaceAfter);
            area.setMaxHeight(area.getMaxHeight() - this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void removeLayout(Area area) {
        if (this.areaContainer != null) {
            area.removeChild(this.areaContainer);
        }
        if (this.spaceBefore != 0) {
            area.increaseHeight(-this.spaceBefore);
        }
        if (this.spaceAfter != 0) {
            area.increaseHeight(-this.spaceAfter);
        }
        this.resetMarker();
        this.removeID(area.getIDReferences());
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public void setYPosition(int n) {
        this.areaContainer.setYPosition(n);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableBody(fObj, propertyList);
        }
    }
}

