/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RelativePositionProps;

public class TableCell
extends FObj {
    ColorType backgroundColor;
    String id;
    int numColumnsSpanned;
    int numRowsSpanned;
    int iColNumber = -1;
    protected int startOffset;
    protected int width;
    protected int beforeOffset = 0;
    protected int startAdjust = 0;
    protected int widthAdjust = 0;
    protected int borderHeight = 0;
    protected int minCellHeight = 0;
    protected int height = 0;
    protected int top;
    protected int verticalAlign;
    protected boolean bRelativeAlign = false;
    boolean bSepBorders = true;
    int m_borderSeparation = 0;
    AreaContainer cellArea;

    public TableCell(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-cell";
        this.doSetup();
    }

    private void calcBorders(BorderAndPadding borderAndPadding) {
        if (this.bSepBorders) {
            int n = this.properties.get("border-separation.inline-progression-direction").getLength().mvalue();
            this.startAdjust = n / 2 + borderAndPadding.getBorderLeftWidth(false) + borderAndPadding.getPaddingLeft(false);
            this.widthAdjust = this.startAdjust + n - n / 2 + borderAndPadding.getBorderRightWidth(false) + borderAndPadding.getPaddingRight(false);
            this.m_borderSeparation = this.properties.get("border-separation.block-progression-direction").getLength().mvalue();
            this.beforeOffset = this.m_borderSeparation / 2 + borderAndPadding.getBorderTopWidth(false) + borderAndPadding.getPaddingTop(false);
        } else {
            int n = borderAndPadding.getBorderLeftWidth(false);
            int n2 = borderAndPadding.getBorderRightWidth(false);
            int n3 = borderAndPadding.getBorderTopWidth(false);
            int n4 = borderAndPadding.getBorderBottomWidth(false);
            this.startAdjust = n / 2 + borderAndPadding.getPaddingLeft(false);
            this.widthAdjust = this.startAdjust + n2 / 2 + borderAndPadding.getPaddingRight(false);
            this.beforeOffset = n3 / 2 + borderAndPadding.getPaddingTop(false);
            this.borderHeight = (n3 + n4) / 2;
        }
    }

    public void doSetup() {
        AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
        AuralProps auralProps = this.propMgr.getAuralProps();
        BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
        BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
        RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
        this.iColNumber = this.properties.get("column-number").getNumber().intValue();
        if (this.iColNumber < 0) {
            this.iColNumber = 0;
        }
        this.numColumnsSpanned = this.properties.get("number-columns-spanned").getNumber().intValue();
        if (this.numColumnsSpanned < 1) {
            this.numColumnsSpanned = 1;
        }
        this.numRowsSpanned = this.properties.get("number-rows-spanned").getNumber().intValue();
        if (this.numRowsSpanned < 1) {
            this.numRowsSpanned = 1;
        }
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.id = this.properties.get("id").getString();
        this.bSepBorders = this.properties.get("border-collapse").getEnum() == 68;
        this.calcBorders(this.propMgr.getBorderAndPadding());
        this.verticalAlign = this.properties.get("display-align").getEnum();
        if (this.verticalAlign == 7) {
            this.bRelativeAlign = true;
            this.verticalAlign = this.properties.get("relative-align").getEnum();
        } else {
            this.bRelativeAlign = false;
        }
        this.minCellHeight = this.properties.get("height").getLength().mvalue();
    }

    public int getColumnNumber() {
        return this.iColNumber;
    }

    public int getHeight() {
        return this.cellArea.getHeight() + this.m_borderSeparation - this.borderHeight;
    }

    public int getNumColumnsSpanned() {
        return this.numColumnsSpanned;
    }

    public int getNumRowsSpanned() {
        return this.numRowsSpanned;
    }

    public Status layout(Area area) throws FOPException {
        int n = area.getAbsoluteHeight();
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            area.getIDReferences().createID(this.id);
            this.marker = 0;
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        int n2 = area.spaceLeft() - this.m_borderSeparation;
        this.cellArea = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), this.startOffset + this.startAdjust, this.beforeOffset, this.width - this.widthAdjust, n2, 61);
        this.cellArea.foCreator = this;
        this.cellArea.setPage(area.getPage());
        try {
            this.cellArea.setBorderAndPadding((BorderAndPadding)this.propMgr.getBorderAndPadding().clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Can't clone BorderAndPadding: " + cloneNotSupportedException);
            this.cellArea.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        }
        this.cellArea.setBackgroundColor(this.backgroundColor);
        this.cellArea.start();
        this.cellArea.setAbsoluteHeight(area.getAbsoluteHeight());
        this.cellArea.setIDReferences(area.getIDReferences());
        this.cellArea.setTableCellXOffset(this.startOffset);
        int n3 = this.children.size();
        int n4 = this.marker;
        while (n4 < n3) {
            FObj fObj = (FObj)this.children.elementAt(n4);
            fObj.setIsInTableCell();
            fObj.forceWidth(this.width);
            this.marker = n4++;
            Status status = fObj.layout(this.cellArea);
            if (status.isIncomplete()) {
                if (n4 == 0 && status.getCode() == 2) {
                    return new Status(2);
                }
                area.addChild(this.cellArea);
                return new Status(3);
            }
            area.setMaxHeight(area.getMaxHeight() - n2 + this.cellArea.getMaxHeight());
        }
        this.cellArea.end();
        area.addChild(this.cellArea);
        if (this.minCellHeight > this.cellArea.getContentHeight()) {
            this.cellArea.setHeight(this.minCellHeight);
        }
        this.height = this.cellArea.getHeight();
        this.top = this.cellArea.getCurrentYPosition();
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setRowHeight(int n) {
        int n2 = n - this.getHeight();
        if (this.bRelativeAlign) {
            this.cellArea.increaseHeight(n2);
        } else if (n2 > 0) {
            BorderAndPadding borderAndPadding = this.cellArea.getBorderAndPadding();
            switch (this.verticalAlign) {
                case 13: {
                    this.cellArea.shiftYPosition(n2 / 2);
                    borderAndPadding.setPaddingLength(0, borderAndPadding.getPaddingTop(false) + n2 / 2);
                    borderAndPadding.setPaddingLength(2, borderAndPadding.getPaddingBottom(false) + n2 - n2 / 2);
                    break;
                }
                case 2: {
                    borderAndPadding.setPaddingLength(0, borderAndPadding.getPaddingTop(false) + n2);
                    this.cellArea.shiftYPosition(n2);
                    break;
                }
                case 9: {
                    borderAndPadding.setPaddingLength(2, borderAndPadding.getPaddingBottom(false) + n2);
                    break;
                }
            }
        }
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableCell(fObj, propertyList);
        }
    }
}

