/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;

public class TableColumn
extends FObj {
    ColorType backgroundColor;
    int columnWidth;
    int columnOffset;
    int numColumnsRepeated;
    int iColumnNumber;
    boolean setup = false;
    AreaContainer areaContainer;

    public TableColumn(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-column";
    }

    public void doSetup(Area area) throws FOPException {
        BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
        BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
        this.iColumnNumber = this.properties.get("column-number").getNumber().intValue();
        this.numColumnsRepeated = this.properties.get("number-columns-repeated").getNumber().intValue();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.columnWidth = this.properties.get("column-width").getLength().mvalue();
        String string = this.properties.get("id").getString();
        area.getIDReferences().initializeID(string, area);
        this.setup = true;
    }

    public int getColumnNumber() {
        return this.iColumnNumber;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public int getNumColumnsRepeated() {
        return this.numColumnsRepeated;
    }

    public Status layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000 && !this.setup) {
            this.doSetup(area);
        }
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), this.columnOffset, 0, this.columnWidth, area.getContentHeight(), 61);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setHeight(area.getHeight());
        area.addChild(this.areaContainer);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setColumnOffset(int n) {
        this.columnOffset = n;
    }

    public void setHeight(int n) {
        this.areaContainer.setMaxHeight(n);
        this.areaContainer.setHeight(n);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableColumn(fObj, propertyList);
        }
    }
}

