/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.KeepValue;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.RowSpanMgr;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.RelativePositionProps;

public class TableRow
extends FObj {
    boolean setup = false;
    int breakAfter;
    ColorType backgroundColor;
    String id;
    KeepValue keepWithNext;
    KeepValue keepWithPrevious;
    KeepValue keepTogether;
    int widthOfCellsSoFar = 0;
    int largestCellHeight = 0;
    int minHeight = 0;
    Vector columns;
    AreaContainer areaContainer;
    boolean areaAdded = false;
    private RowSpanMgr rowSpanMgr = null;
    private CellArray cellArray = null;

    public TableRow(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-row";
    }

    public void doSetup(Area area) throws FOPException {
        AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
        AuralProps auralProps = this.propMgr.getAuralProps();
        BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
        BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
        RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
        this.breakAfter = this.properties.get("break-after").getEnum();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        this.keepTogether = this.getKeepValue("keep-together.within-column");
        this.keepWithNext = this.getKeepValue("keep-with-next.within-column");
        this.keepWithPrevious = this.getKeepValue("keep-with-previous.within-column");
        this.id = this.properties.get("id").getString();
        this.minHeight = this.properties.get("height").getLength().mvalue();
        this.setup = true;
    }

    public int getAreaHeight() {
        return this.areaContainer.getHeight();
    }

    private int getCellWidth(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += ((TableColumn)this.columns.elementAt(n + n4 - 1)).getColumnWidth();
            ++n4;
        }
        return n3;
    }

    private KeepValue getKeepValue(String string) {
        Property property = this.properties.get(string);
        Number number = property.getNumber();
        if (number != null) {
            return new KeepValue("KEEP_WITH_VALUE", number.intValue());
        }
        switch (property.getEnum()) {
            case 5: {
                return new KeepValue("KEEP_WITH_ALWAYS", 0);
            }
        }
        return new KeepValue("KEEP_WITH_AUTO", 0);
    }

    public KeepValue getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    private void initCellArray() {
        this.cellArray = new CellArray(this.rowSpanMgr, this.columns.size());
        int n = 1;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            n = this.cellArray.getNextFreeCell(n);
            TableCell tableCell = (TableCell)enumeration.nextElement();
            int n2 = tableCell.getNumColumnsSpanned();
            int n3 = tableCell.getNumRowsSpanned();
            int n4 = tableCell.getColumnNumber();
            if (n4 == 0) {
                if (n < 1) continue;
                n4 = n;
            } else if (n4 > this.columns.size()) continue;
            if (n4 + n2 - 1 > this.columns.size()) {
                n2 = this.columns.size() - n4 + 1;
            }
            this.cellArray.storeCell(tableCell, n4, n2);
            if (n4 > n) {
                n = n4;
            } else if (n4 < n) {
                n = n4;
            }
            int n5 = this.getCellWidth(n4, n2);
            tableCell.setWidth(n5);
            n += n2;
        }
    }

    public Status layout(Area area) throws FOPException {
        int n;
        boolean bl = false;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            if (!this.setup) {
                this.doSetup(area);
            }
            if (this.cellArray == null) {
                this.initCellArray();
                area.getIDReferences().createID(this.id);
                bl = true;
            }
            this.marker = 0;
            n = this.propMgr.checkBreakBefore(area);
            if (n != 1) {
                return new Status(n);
            }
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        n = area.spaceLeft();
        this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), 0, 0, area.getContentWidth(), n, 61);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        this.largestCellHeight = this.minHeight;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            int n4;
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            int n5 = tableColumn.getColumnWidth();
            if (this.cellArray.getCellType(++n3) != 1) {
                if (this.rowSpanMgr.isInLastRow(n3) && (n4 = this.rowSpanMgr.getRemainingHeight(n3)) > this.largestCellHeight) {
                    this.largestCellHeight = n4;
                }
                n2 += n5;
                continue;
            }
            TableCell tableCell = this.cellArray.getCell(n3);
            tableCell.setStartOffset(n2);
            n2 += n5;
            n4 = tableCell.getNumRowsSpanned();
            Status status = tableCell.layout(this.areaContainer);
            if (status.isIncomplete()) {
                if (this.keepTogether.getType() == "KEEP_WITH_ALWAYS" || status.getCode() == 2 || n4 > 1) {
                    this.resetMarker();
                    this.removeID(area.getIDReferences());
                    return new Status(2);
                }
                if (status.getCode() == 3) {
                    bl2 = true;
                }
            }
            int n6 = tableCell.getHeight();
            if (n4 > 1) {
                this.rowSpanMgr.addRowSpan(tableCell, n3, tableCell.getNumColumnsSpanned(), n6, n4);
                continue;
            }
            if (n6 <= this.largestCellHeight) continue;
            this.largestCellHeight = n6;
        }
        area.setMaxHeight(area.getMaxHeight() - n + this.areaContainer.getMaxHeight());
        int n7 = 1;
        while (n7 <= this.columns.size()) {
            if (this.cellArray.getCellType(n7) == 1 && !this.rowSpanMgr.isSpanned(n7)) {
                this.cellArray.getCell(n7).setRowHeight(this.largestCellHeight);
            }
            ++n7;
        }
        this.rowSpanMgr.finishRow(this.largestCellHeight);
        area.addChild(this.areaContainer);
        this.areaContainer.setHeight(this.largestCellHeight);
        this.areaAdded = true;
        this.areaContainer.end();
        area.addDisplaySpace(this.largestCellHeight + this.areaContainer.getPaddingTop() + this.areaContainer.getBorderTopWidth() + this.areaContainer.getPaddingBottom() + this.areaContainer.getBorderBottomWidth());
        if (bl2) {
            return new Status(3);
        }
        if (this.rowSpanMgr.hasUnfinishedSpans()) {
            return new Status(8);
        }
        if (this.breakAfter == 58) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 55) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 26) {
            this.marker = -1001;
            return new Status(5);
        }
        if (this.breakAfter == 15) {
            this.marker = -1001;
            return new Status(7);
        }
        if (this.keepWithNext.getType() != "KEEP_WITH_AUTO") {
            return new Status(8);
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void removeLayout(Area area) {
        if (this.areaAdded) {
            area.removeChild(this.areaContainer);
        }
        this.areaAdded = false;
        this.resetMarker();
        this.removeID(area.getIDReferences());
    }

    public void resetMarker() {
        super.resetMarker();
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public void setRowSpanMgr(RowSpanMgr rowSpanMgr) {
        this.rowSpanMgr = rowSpanMgr;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableRow(fObj, propertyList);
        }
    }

    private static class CellArray {
        public static final byte EMPTY = 0;
        public static final byte CELLSTART = 1;
        public static final byte CELLSPAN = 2;
        private TableCell[] cells;
        private byte[] states;

        public CellArray(RowSpanMgr rowSpanMgr, int n) {
            this.cells = new TableCell[n];
            this.states = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                if (rowSpanMgr.isSpanned(n2 + 1)) {
                    this.cells[n2] = rowSpanMgr.getSpanningCell(n2 + 1);
                    this.states[n2] = 2;
                } else {
                    this.states[n2] = 0;
                }
                ++n2;
            }
        }

        TableCell getCell(int n) {
            if (n > 0 && n <= this.cells.length) {
                return this.cells[n - 1];
            }
            return null;
        }

        int getCellType(int n) {
            if (n > 0 && n <= this.cells.length) {
                return this.states[n - 1];
            }
            return -1;
        }

        int getNextFreeCell(int n) {
            int n2 = n - 1;
            while (n2 < this.states.length) {
                if (this.states[n2] == 0) {
                    return n2 + 1;
                }
                ++n2;
            }
            return -1;
        }

        boolean storeCell(TableCell tableCell, int n, int n2) {
            boolean bl = true;
            int n3 = n - 1;
            int n4 = 0;
            while (n3 < this.cells.length && n4 < n2) {
                if (this.cells[n3] == null) {
                    this.cells[n3] = tableCell;
                    this.states[n3] = n4 == 0 ? 1 : 2;
                } else {
                    bl = false;
                }
                ++n4;
                ++n3;
            }
            return bl;
        }
    }
}

