/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.BMPReader;
import org.apache.fop.image.analyser.GIFReader;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.image.analyser.JPEGReader;
import org.apache.fop.image.analyser.PNGReader;
import org.apache.fop.image.analyser.SVGReader;
import org.apache.fop.image.analyser.TIFFReader;

public class ImageReaderFactory {
    protected static Vector formats = null;

    public static ImageReader Make(String string, InputStream inputStream) throws FopImageException {
        formats = new Vector();
        formats.addElement(new JPEGReader());
        formats.addElement(new BMPReader());
        formats.addElement(new GIFReader());
        formats.addElement(new PNGReader());
        formats.addElement(new TIFFReader());
        formats.addElement(new SVGReader());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        Enumeration enumeration = formats.elements();
        try {
            while (enumeration.hasMoreElements()) {
                ImageReader imageReader = (ImageReader)enumeration.nextElement();
                if (!imageReader.verifySignature(string, bufferedInputStream)) continue;
                return imageReader;
            }
        }
        catch (IOException iOException) {
            throw new FopImageException(iOException.getMessage());
        }
        return null;
    }
}

