/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.Page;
import org.apache.fop.render.Renderer;

public class BlockArea
extends Area {
    protected int startIndent;
    protected int endIndent;
    protected int textIndent;
    protected int lineHeight;
    protected int halfLeading;
    protected int align;
    protected int alignLastLine;
    protected LineArea currentLineArea;
    protected LinkSet currentLinkSet;
    protected boolean hasLines = false;
    protected HyphenationProps hyphProps;
    protected Vector pendingFootnotes = null;

    public BlockArea(FontState fontState, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(fontState, n, n2);
        this.startIndent = n3;
        this.endIndent = n4;
        this.textIndent = n5;
        this.contentRectangleWidth = n - n3 - n4;
        this.align = n6;
        this.alignLastLine = n7;
        this.lineHeight = n8;
        if (fontState != null) {
            this.halfLeading = (n8 - fontState.getFontSize()) / 2;
        }
    }

    public void addFootnote(FootnoteBody footnoteBody) {
        if (this.pendingFootnotes == null) {
            this.pendingFootnotes = new Vector();
        }
        this.pendingFootnotes.addElement(footnoteBody);
    }

    protected void addLineArea(LineArea lineArea) {
        if (!lineArea.isEmpty()) {
            lineArea.verticalAlign();
            this.addDisplaySpace(this.halfLeading);
            int n = lineArea.getHeight();
            this.addChild(lineArea);
            this.increaseHeight(n);
            this.addDisplaySpace(this.halfLeading);
        }
        if (this.pendingFootnotes != null) {
            Enumeration enumeration = this.pendingFootnotes.elements();
            while (enumeration.hasMoreElements()) {
                FootnoteBody footnoteBody = (FootnoteBody)enumeration.nextElement();
                Page page = this.getPage();
                if (Footnote.layoutFootnote(page, footnoteBody, this)) continue;
                page.addPendingFootnote(footnoteBody);
            }
            this.pendingFootnotes = null;
        }
    }

    public LineArea createNextLineArea() {
        if (this.hasLines) {
            this.currentLineArea.align(this.align);
            this.addLineArea(this.currentLineArea);
        }
        this.currentLineArea = new LineArea(this.fontState, this.lineHeight, this.halfLeading, this.allocationWidth, this.startIndent, this.endIndent, this.currentLineArea);
        this.currentLineArea.changeHyphenation(this.hyphProps);
        if (this.currentHeight + this.lineHeight > this.maxHeight) {
            return null;
        }
        return this.currentLineArea;
    }

    public void end() {
        if (this.hasLines) {
            this.currentLineArea.addPending();
            this.currentLineArea.align(this.alignLastLine);
            this.addLineArea(this.currentLineArea);
        }
    }

    public LineArea getCurrentLineArea() {
        if (this.currentHeight + this.lineHeight > this.maxHeight) {
            return null;
        }
        this.currentLineArea.changeHyphenation(this.hyphProps);
        this.hasLines = true;
        return this.currentLineArea;
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public int getHalfLeading() {
        return this.halfLeading;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public void render(Renderer renderer) {
        renderer.renderBlockArea(this);
    }

    public void setHyphenation(HyphenationProps hyphenationProps) {
        this.hyphProps = hyphenationProps;
    }

    public void setIndents(int n, int n2) {
        this.startIndent = n;
        this.endIndent = n2;
        this.contentRectangleWidth = this.allocationWidth - n - n2;
    }

    public void setupLinkSet(LinkSet linkSet) {
        if (linkSet != null) {
            this.currentLinkSet = linkSet;
            linkSet.setYOffset(this.currentHeight);
        }
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
        this.currentLineArea = new LineArea(this.fontState, this.lineHeight, this.halfLeading, this.allocationWidth, this.startIndent + this.textIndent, this.endIndent, null);
    }
}

