/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.messaging;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.messaging.MessageEvent;
import org.apache.fop.messaging.MessageListener;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class MessageHandler {
    public static final int SCREEN = 0;
    public static final int FILE = 1;
    public static final int EVENT = 2;
    public static final int NONE = 3;
    private static String logfileName = "fop.log";
    private static PrintWriter writer;
    private static int outputMethod;
    private static boolean fileOpened;
    private static boolean appendToFile;
    private static String message;
    private static String prefix;
    private static Vector listeners;
    private static boolean IDisSet;
    private static boolean quiet;
    private static Logger logger;

    static {
        outputMethod = 0;
        fileOpened = false;
        appendToFile = true;
        message = "";
        prefix = "";
        listeners = new Vector();
        IDisSet = false;
        quiet = false;
        logger = null;
    }

    public static void addListener(MessageListener messageListener) {
        listeners.addElement(messageListener);
    }

    public static void error(String string) {
        if (logger == null) {
            logger = Hierarchy.getDefaultHierarchy().getLoggerFor("fop");
        }
        MessageHandler.setMessage(string);
        switch (outputMethod) {
            case 0: {
                logger.error(MessageHandler.getMessage());
                break;
            }
            case 1: {
                if (fileOpened) {
                    writer.print(MessageHandler.getMessage());
                    writer.flush();
                    break;
                }
                MessageHandler.openFile();
                writer.print(MessageHandler.getMessage());
                writer.flush();
                break;
            }
            case 2: {
                MessageHandler.setMessage(message);
                Enumeration enumeration = listeners.elements();
                while (enumeration.hasMoreElements()) {
                    MessageEvent messageEvent = new MessageEvent(MessageHandler.getMessage());
                    messageEvent.setMessageType(1);
                    ((MessageListener)enumeration.nextElement()).processMessage(messageEvent);
                }
                break;
            }
            default: {
                logger.error(string);
            }
            case 3: 
        }
    }

    public static void errorln(String string) {
        MessageHandler.error(string);
    }

    private static String getID() {
        return Thread.currentThread().toString();
    }

    public static String getLogfileName() {
        return logfileName;
    }

    private static String getMessage() {
        return message;
    }

    public static int getOutputMethod() {
        return outputMethod;
    }

    public static void log(String string) {
        if (!quiet) {
            if (logger == null) {
                logger = Hierarchy.getDefaultHierarchy().getLoggerFor("fop");
            }
            MessageHandler.setMessage(string);
            switch (outputMethod) {
                case 0: {
                    logger.debug(MessageHandler.getMessage());
                    break;
                }
                case 1: {
                    if (fileOpened) {
                        writer.print(MessageHandler.getMessage());
                        writer.flush();
                        break;
                    }
                    MessageHandler.openFile();
                    writer.print(MessageHandler.getMessage());
                    writer.flush();
                    break;
                }
                case 2: {
                    MessageHandler.setMessage(string);
                    Enumeration enumeration = listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((MessageListener)enumeration.nextElement()).processMessage(new MessageEvent(MessageHandler.getMessage()));
                    }
                    break;
                }
                default: {
                    logger.debug(string);
                }
                case 3: 
            }
        }
    }

    public static void logln(String string) {
        MessageHandler.log(string);
    }

    private static void openFile() {
        try {
            writer = new PrintWriter((Writer)new FileWriter(logfileName, appendToFile), true);
            writer.println("\n==============================================");
            fileOpened = true;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException);
        }
    }

    public static void removeListener(MessageListener messageListener) {
        listeners.removeElement(messageListener);
    }

    public static void setID(boolean bl) {
        IDisSet = bl;
    }

    public static void setLogfileName(String string, boolean bl) {
        logfileName = string;
        appendToFile = bl;
    }

    private static void setMessage(String string) {
        message = IDisSet ? String.valueOf(MessageHandler.getID()) + ":" + string : string;
    }

    public static void setOutputMethod(int n) {
        if (n > 3) {
            MessageHandler.error("Error: Unknown output method");
        } else {
            outputMethod = n;
        }
    }

    public static void setQuiet(boolean bl) {
        quiet = bl;
    }
}

