/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.render.Renderer;
import org.apache.fop.svg.SVGArea;
import org.apache.log.Logger;

public abstract class AbstractRenderer
implements Renderer {
    protected Logger log;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    protected int currentAreaContainerXPosition = 0;

    protected abstract void addFilledRect(int var1, int var2, int var3, int var4, ColorType var5);

    protected abstract void doFrame(Area var1);

    public abstract void render(Page var1, OutputStream var2) throws IOException, FOPException;

    public void renderAreaContainer(AreaContainer areaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (areaContainer.getPosition() == 1) {
            this.currentYPosition = areaContainer.getYPosition();
            this.currentAreaContainerXPosition = areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 61) {
            this.currentYPosition -= areaContainer.getYPosition();
            this.currentAreaContainerXPosition += areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 73) {
            this.currentYPosition -= areaContainer.getPaddingTop() + areaContainer.getBorderTopWidth();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        this.doFrame(areaContainer);
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.currentYPosition = n;
        this.currentAreaContainerXPosition = n2;
        if (areaContainer.getPosition() == 73) {
            this.currentYPosition -= areaContainer.getHeight();
        }
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.currentYPosition -= blockArea.getPaddingTop() + blockArea.getBorderTopWidth();
        this.doFrame(blockArea);
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.currentYPosition -= blockArea.getPaddingBottom() + blockArea.getBorderBottomWidth();
    }

    public void renderBodyAreaContainer(BodyAreaContainer bodyAreaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (bodyAreaContainer.getPosition() == 1) {
            this.currentYPosition = bodyAreaContainer.getYPosition();
            this.currentAreaContainerXPosition = bodyAreaContainer.getXPosition();
        } else if (bodyAreaContainer.getPosition() == 61) {
            this.currentYPosition -= bodyAreaContainer.getYPosition();
            this.currentAreaContainerXPosition += bodyAreaContainer.getXPosition();
        }
        this.currentXPosition = this.currentAreaContainerXPosition;
        int n3 = this.currentAreaContainerXPosition;
        int n4 = bodyAreaContainer.getContentWidth();
        int n5 = bodyAreaContainer.getContentHeight();
        int n6 = this.currentYPosition;
        ColorType colorType = bodyAreaContainer.getBackgroundColor();
        if (colorType != null && colorType.alpha() == 0.0f) {
            this.addFilledRect(n3, n6, n4, -n5, colorType);
        }
        this.renderAreaContainer(bodyAreaContainer.getBeforeFloatReferenceArea());
        this.renderAreaContainer(bodyAreaContainer.getFootnoteReferenceArea());
        Enumeration enumeration = bodyAreaContainer.getMainReferenceArea().getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (bodyAreaContainer.getPosition() != 73) {
            this.currentYPosition = n;
            this.currentAreaContainerXPosition = n2;
        } else {
            this.currentYPosition -= bodyAreaContainer.getHeight();
        }
    }

    public abstract void renderDisplaySpace(DisplaySpace var1);

    public abstract void renderForeignObjectArea(ForeignObjectArea var1);

    public abstract void renderImageArea(ImageArea var1);

    public abstract void renderInlineSpace(InlineSpace var1);

    public abstract void renderLeaderArea(LeaderArea var1);

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            if (box instanceof InlineArea) {
                InlineArea inlineArea = (InlineArea)box;
                this.currentYPosition = n2 - inlineArea.getYOffset();
            } else {
                this.currentYPosition = n2 - lineArea.getPlacementOffset();
            }
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
        this.currentXPosition = n;
    }

    public abstract void renderPage(Page var1);

    public abstract void renderSVGArea(SVGArea var1);

    public void renderSpanArea(SpanArea spanArea) {
        Enumeration enumeration = spanArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public abstract void renderWordArea(WordArea var1);

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public abstract void setOptions(Hashtable var1);

    public abstract void setProducer(String var1);

    public abstract void setupFontInfo(FontInfo var1);

    public abstract void startRenderer(OutputStream var1) throws IOException;

    public abstract void stopRenderer(OutputStream var1) throws IOException;
}

