/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.mif;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.mif.MIFDocument;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.mif.FontSetup;
import org.apache.fop.svg.SVGArea;

public class MIFRenderer
extends AbstractRenderer {
    private String currentFontName;
    private String currentFontSize;
    private int pageHeight;
    private int pageWidth;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;
    protected MIFDocument mifDoc = new MIFDocument();
    private boolean inTable = false;
    protected Hashtable options;

    protected void addFilledRect(int n, int n2, int n3, int n4, ColorType colorType) {
    }

    protected void doFrame(Area area) {
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        ColorType colorType = area.getBackgroundColor();
        n -= area.getPaddingLeft();
        n4 += area.getPaddingTop();
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        n2 = n2 + area.getBorderLeftWidth() + area.getBorderRightWidth();
        n3 = n3 + area.getBorderTopWidth() + area.getBorderBottomWidth();
        this.mifDoc.setTextRectProp(n -= area.getBorderLeftWidth(), this.pageHeight - (n4 += area.getBorderTopWidth()), n2, n3);
    }

    public void render(Page page, OutputStream outputStream) {
        this.renderPage(page);
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table") {
            this.mifDoc.createTable();
            this.inTable = true;
        } else if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table-body") {
            this.mifDoc.setCurrent("fo:table-body");
        } else if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table-column") {
            int n = ((TableColumn)areaContainer.foCreator).getColumnWidth();
            this.mifDoc.setColumnProp(n);
        } else if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table-row") {
            this.mifDoc.startRow();
        } else if (areaContainer.foCreator != null && areaContainer.foCreator.getName() == "fo:table-cell") {
            int n = ((TableCell)areaContainer.foCreator).getNumRowsSpanned();
            int n2 = ((TableCell)areaContainer.foCreator).getNumColumnsSpanned();
            this.mifDoc.startCell(n, n2);
        } else if (this.inTable) {
            this.inTable = false;
            this.mifDoc.endTable();
        }
        super.renderAreaContainer(areaContainer);
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.mifDoc.setBlockProp(blockArea.getStartIndent(), blockArea.getEndIndent());
        super.renderBlockArea(blockArea);
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage instanceof SVGImage) {
            this.log.warn("SVG images not supported in this version");
        } else {
            String string = fopImage.getURL();
            this.mifDoc.addImage(string, n, this.pageHeight - n2, n3, n4);
        }
    }

    public void renderInlineArea(InlineArea inlineArea) {
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        String string = " ";
        this.mifDoc.addToStream(string);
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLeaderArea(LeaderArea leaderArea) {
    }

    public void renderLineArea(LineArea lineArea) {
        this.mifDoc.startLine();
        super.renderLineArea(lineArea);
    }

    public void renderPage(Page page) {
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = "0";
        this.pageHeight = page.getHeight();
        this.pageWidth = page.getWidth();
        this.mifDoc.setDocumentHeightWidth(this.pageHeight, this.pageWidth);
        this.mifDoc.createPage();
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.mifDoc.createTextRect(1);
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.mifDoc.createTextRect(1);
            this.renderAreaContainer(areaContainer2);
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
    }

    public void renderSpanArea(SpanArea spanArea) {
        this.mifDoc.createTextRect(spanArea.getColumnCount());
        super.renderSpanArea(spanArea);
    }

    public void renderWordArea(WordArea wordArea) {
        String string = wordArea.getText();
        this.mifDoc.addToStream(string);
        this.currentXPosition += wordArea.getContentWidth();
    }

    public void setOptions(Hashtable hashtable) {
        this.options = hashtable;
    }

    public void setProducer(String string) {
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.info("rendering areas to MIF");
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.log.info("writing out MIF");
        this.mifDoc.output(outputStream);
        outputStream.flush();
    }
}

