/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.extensions.Outline;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.LinkedRectangle;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.pdf.CIDFont;
import org.apache.fop.render.pdf.Font;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.pdf.fonts.LazyFont;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.PDFTextPainter;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PDFRenderer
extends PrintRenderer {
    protected PDFDocument pdfDoc;
    protected PDFResources pdfResources;
    PDFStream currentStream;
    PDFAnnotList currentAnnotList;
    PDFPage currentPage;
    PDFColor currentColor;
    boolean textOpen = false;
    int prevWordY = 0;
    int prevWordX = 0;
    int prevWordWidth = 0;
    private StringBuffer _wordAreaPDF = new StringBuffer();
    protected Hashtable options;
    protected Vector extensions = null;

    public PDFRenderer() {
        this.pdfDoc = new PDFDocument();
    }

    protected void addFilledRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(true) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re f\n" + "Q\nBT\n");
    }

    private void addKerning(StringBuffer stringBuffer, Integer n, Integer n2, Hashtable hashtable, String string, String string2) {
        Integer n3;
        Hashtable hashtable2 = (Hashtable)hashtable.get(n);
        if (hashtable2 != null && (n3 = (Integer)hashtable2.get(n2)) != null) {
            stringBuffer.append(string2).append(-n3.intValue()).append(' ').append(string);
        }
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, int n6, PDFPathPaint pDFPathPaint) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(false) + this.setRuleStylePattern(n6) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " m " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " l " + (float)n5 / 1000.0f + " w S\n" + "Q\nBT\n");
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, PDFPathPaint pDFPathPaint) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " m " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " l " + (float)n5 / 1000.0f + " w S\n" + "Q\nBT\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re s\n" + "Q\nBT\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint, PDFPathPaint pDFPathPaint2) {
        this.closeText();
        this.currentStream.add("ET\nq\n" + pDFPathPaint2.getColorSpaceOut(true) + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re b\n" + "Q\nBT\n");
    }

    private void closeText() {
        if (this.textOpen) {
            this.currentStream.add("] TJ\n");
            this.textOpen = false;
            this.prevWordX = 0;
            this.prevWordY = 0;
        }
    }

    private String getUnicodeString(char c) {
        StringBuffer stringBuffer = new StringBuffer(4);
        byte[] byArray = null;
        try {
            char[] cArray = new char[]{c};
            byArray = new String(cArray).getBytes("UnicodeBigUnmarked");
        }
        catch (Exception exception) {}
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] < 0 ? 256 + byArray[n] : byArray[n];
            String string = Integer.toHexString(n2);
            stringBuffer = string.length() == 1 ? stringBuffer.append("0" + string) : stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void render(Page page, OutputStream outputStream) throws FOPException, IOException {
        this.idReferences = page.getIDReferences();
        this.pdfResources = this.pdfDoc.getResources();
        this.pdfDoc.setIDReferences(this.idReferences);
        this.renderPage(page);
        Vector vector = page.getExtensions();
        if (vector != null) {
            this.extensions = vector;
        }
        this.pdfDoc.output(outputStream);
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        this.currentXPosition += foreignObjectArea.getXOffset();
        this.currentYPosition = this.currentYPosition;
        switch (foreignObjectArea.getAlign()) {
            default: 
        }
        switch (foreignObjectArea.getVerticalAlign()) {
            default: 
        }
        this.closeText();
        this.currentStream.add("ET\n");
        this.currentStream.add("q\n");
        switch (foreignObjectArea.scalingMethod()) {
            default: 
        }
        switch (foreignObjectArea.getOverflow()) {
            default: 
        }
        foreignObjectArea.getObject().render(this);
        this.currentStream.add("Q\n");
        this.currentStream.add("BT\n");
        this.currentXPosition += foreignObjectArea.getEffectiveWidth();
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        if (fopImage instanceof SVGImage) {
            try {
                this.closeText();
                SVGDocument sVGDocument = ((SVGImage)fopImage).getSVGDocument();
                this.currentStream.add("ET\nq\n");
                this.renderSVGDocument((Document)sVGDocument, n, n2, imageArea.getFontState());
                this.currentStream.add("Q\nBT\n");
            }
            catch (FopImageException fopImageException) {}
        } else {
            int n5 = this.pdfDoc.addImage(fopImage);
            this.closeText();
            this.currentStream.add("ET\nq\n" + (float)n3 / 1000.0f + " 0 0 " + (float)n4 / 1000.0f + " " + (float)n / 1000.0f + " " + (float)(n2 - n4) / 1000.0f + " cm\n" + "/Im" + n5 + " Do\nQ\nBT\n");
        }
        this.currentXPosition += imageArea.getContentWidth();
    }

    private void renderOutline(Outline outline) {
        Object object;
        PDFOutline pDFOutline = this.pdfDoc.getOutlineRoot();
        PDFOutline pDFOutline2 = null;
        Outline outline2 = outline.getParentOutline();
        if (outline2 == null) {
            pDFOutline2 = this.pdfDoc.makeOutline(pDFOutline, outline.getLabel().toString(), outline.getInternalDestination());
        } else {
            object = (PDFOutline)outline2.getRendererObject();
            if (object == null) {
                this.log.error("pdfParentOutline is null");
            } else {
                pDFOutline2 = this.pdfDoc.makeOutline((PDFOutline)object, outline.getLabel().toString(), outline.getInternalDestination());
            }
        }
        outline.setRendererObject(pDFOutline2);
        object = outline.getOutlines();
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            this.renderOutline((Outline)enumeration.nextElement());
        }
    }

    public void renderPage(Page page) {
        this.currentStream = this.pdfDoc.makeStream();
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        AreaContainer areaContainer3 = page.getStart();
        AreaContainer areaContainer4 = page.getEnd();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.currentStream.add("BT\n");
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        if (areaContainer3 != null) {
            this.renderAreaContainer(areaContainer3);
        }
        if (areaContainer4 != null) {
            this.renderAreaContainer(areaContainer4);
        }
        this.closeText();
        float f = page.getWidth();
        float f2 = page.getHeight();
        this.currentStream.add("ET\n");
        this.currentPage = this.pdfDoc.makePage(this.pdfResources, this.currentStream, Math.round(f / 1000.0f), Math.round(f2 / 1000.0f), page);
        if (page.hasLinks() || this.currentAnnotList != null) {
            if (this.currentAnnotList == null) {
                this.currentAnnotList = this.pdfDoc.makeAnnotList();
            }
            this.currentPage.setAnnotList(this.currentAnnotList);
            Enumeration enumeration = page.getLinkSets().elements();
            while (enumeration.hasMoreElements()) {
                LinkSet linkSet = (LinkSet)enumeration.nextElement();
                linkSet.align();
                String string = linkSet.getDest();
                int n = linkSet.getLinkType();
                Enumeration enumeration2 = linkSet.getRects().elements();
                while (enumeration2.hasMoreElements()) {
                    LinkedRectangle linkedRectangle = (LinkedRectangle)enumeration2.nextElement();
                    this.currentAnnotList.addLink(this.pdfDoc.makeLink(linkedRectangle.getRectangle(), string, n));
                }
            }
            this.currentAnnotList = null;
        } else {
            this.currentAnnotList = null;
        }
        this.currentFill = null;
    }

    protected void renderRootExtensions(Vector vector) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ExtensionObj extensionObj = (ExtensionObj)enumeration.nextElement();
                if (!(extensionObj instanceof Outline)) continue;
                this.renderOutline((Outline)extensionObj);
            }
        }
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        this.renderSVGDocument(sVGArea.getSVGDocument(), n, n2, sVGArea.getFontState());
    }

    protected void renderSVGDocument(Document document, int n, int n2, FontState fontState) {
        Object object;
        GraphicsNode graphicsNode;
        float f = 1.0f;
        float f2 = -1.0f;
        int n3 = n;
        int n4 = n2;
        SVGUserAgent sVGUserAgent = new SVGUserAgent(new AffineTransform());
        sVGUserAgent.setLogger(this.log);
        GVTBuilder gVTBuilder = new GVTBuilder();
        BridgeContext bridgeContext = new BridgeContext((UserAgent)sVGUserAgent);
        Object object2 = null;
        Boolean bl = Configuration.getBooleanValue("strokeSVGText");
        object2 = bl == null || bl != false ? new StrokingTextPainter() : new PDFTextPainter(fontState);
        bridgeContext.setTextPainter((TextPainter)object2);
        PDFAElementBridge pDFAElementBridge = new PDFAElementBridge();
        pDFAElementBridge.setCurrentTransform(new AffineTransform(f, 0.0f, 0.0f, f2, (float)n3 / 1000.0f, (float)n4 / 1000.0f));
        bridgeContext.putBridge((Bridge)pDFAElementBridge);
        try {
            graphicsNode = gVTBuilder.build(bridgeContext, document);
        }
        catch (Exception exception) {
            this.log.error("svg graphic could not be built: " + exception.getMessage(), (Throwable)exception);
            return;
        }
        float f3 = (float)bridgeContext.getDocumentSize().getWidth() * 1000.0f;
        float f4 = (float)bridgeContext.getDocumentSize().getHeight() * 1000.0f;
        bridgeContext = null;
        gVTBuilder = null;
        this.currentStream.add("q\n");
        if (f3 != 0.0f && f4 != 0.0f) {
            this.currentStream.add(String.valueOf((float)n / 1000.0f) + " " + (float)n2 / 1000.0f + " m\n");
            this.currentStream.add(String.valueOf(((float)n + f3) / 1000.0f) + " " + (float)n2 / 1000.0f + " l\n");
            this.currentStream.add(String.valueOf(((float)n + f3) / 1000.0f) + " " + ((float)n2 - f4) / 1000.0f + " l\n");
            this.currentStream.add(String.valueOf((float)n / 1000.0f) + " " + ((float)n2 - f4) / 1000.0f + " l\n");
            this.currentStream.add("h\n");
            this.currentStream.add("W\n");
            this.currentStream.add("n\n");
        }
        this.currentStream.add(String.valueOf(f) + " 0 0 " + f2 + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " cm\n");
        SVGSVGElement sVGSVGElement = ((SVGDocument)document).getRootElement();
        AffineTransform affineTransform = ViewBox.getPreserveAspectRatioTransform((Element)sVGSVGElement, (float)(f3 / 1000.0f), (float)(f4 / 1000.0f));
        if (!affineTransform.isIdentity()) {
            object = new double[6];
            affineTransform.getMatrix((double[])object);
            this.currentStream.add(String.valueOf(PDFNumber.doubleOut(object[0])) + " " + PDFNumber.doubleOut(object[1]) + " " + PDFNumber.doubleOut((double)object[2]) + " " + PDFNumber.doubleOut((double)object[3]) + " " + PDFNumber.doubleOut((double)object[4]) + " " + PDFNumber.doubleOut((double)object[5]) + " cm\n");
        }
        object = (Object)new PDFGraphics2D(true, fontState, this.pdfDoc, this.currentFontName, this.currentFontSize, this.currentXPosition, this.currentYPosition);
        ((PDFGraphics2D)((Object)object)).setGraphicContext(new GraphicContext());
        try {
            graphicsNode.paint((Graphics2D)object);
            this.currentStream.add(((PDFGraphics2D)((Object)object)).getString());
        }
        catch (Exception exception) {
            this.log.error("svg graphic could not be rendered: " + exception.getMessage(), (Throwable)exception);
        }
        this.currentAnnotList = ((PDFGraphics2D)((Object)object)).getAnnotList();
        this.currentStream.add("Q\n");
    }

    public void renderWordArea(WordArea wordArea) {
        StringBuffer stringBuffer = this._wordAreaPDF;
        synchronized (stringBuffer) {
            String string;
            String string2;
            StringBuffer stringBuffer2 = this._wordAreaPDF;
            stringBuffer2.setLength(0);
            Hashtable hashtable = null;
            boolean bl = false;
            hashtable = wordArea.getFontState().getKerning();
            if (hashtable != null && !hashtable.isEmpty()) {
                bl = true;
            }
            String string3 = wordArea.getFontState().getFontName();
            int n = wordArea.getFontState().getFontSize();
            boolean bl2 = false;
            Font font = (Font)wordArea.getFontState().getFontInfo().getFonts().get(string3);
            if (font instanceof LazyFont) {
                if (((LazyFont)font).getRealFont() instanceof CIDFont) {
                    bl2 = true;
                }
            } else if (font instanceof CIDFont) {
                bl2 = true;
            }
            String string4 = bl2 ? "<" : "(";
            String string5 = string2 = bl2 ? "> " : ") ";
            if (!string3.equals(this.currentFontName) || n != this.currentFontSize) {
                this.closeText();
                this.currentFontName = string3;
                this.currentFontSize = n;
                stringBuffer2 = stringBuffer2.append("/" + string3 + " " + n / 1000 + " Tf\n");
            }
            PDFColor pDFColor = null;
            if (this.currentFill instanceof PDFColor) {
                pDFColor = (PDFColor)this.currentFill;
            }
            if (pDFColor == null || pDFColor.red() != (double)wordArea.getRed() || pDFColor.green() != (double)wordArea.getGreen() || pDFColor.blue() != (double)wordArea.getBlue()) {
                pDFColor = new PDFColor(wordArea.getRed(), wordArea.getGreen(), wordArea.getBlue());
                this.closeText();
                this.currentFill = pDFColor;
                stringBuffer2.append(this.currentFill.getColorSpaceOut(true));
            }
            int n2 = this.currentXPosition;
            int n3 = this.currentYPosition;
            this.addWordLines(wordArea, n2, n3, n, pDFColor);
            if (!this.textOpen || n3 != this.prevWordY) {
                this.closeText();
                stringBuffer2.append("1 0 0 1 " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " Tm [" + string4);
                this.prevWordY = n3;
                this.textOpen = true;
            } else {
                int n4 = this.prevWordX - n2 + this.prevWordWidth;
                float f = (float)n4 / (float)this.currentFontSize * 1000.0f;
                if (f < -33000.0f) {
                    this.closeText();
                    stringBuffer2.append("1 0 0 1 " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " Tm [" + string4);
                    this.textOpen = true;
                } else {
                    stringBuffer2.append(Float.toString(f));
                    stringBuffer2.append(" ");
                    stringBuffer2.append(string4);
                }
            }
            this.prevWordWidth = wordArea.getContentWidth();
            this.prevWordX = n2;
            if (wordArea.getPageNumberID() != null) {
                string = this.idReferences.getPageNumber(wordArea.getPageNumberID());
                if (string == null) {
                    string = "";
                }
            } else {
                string = wordArea.getText();
            }
            int n5 = string.length();
            int n6 = 0;
            while (n6 < n5) {
                char c = wordArea.getFontState().mapChar(string.charAt(n6));
                if (!bl2) {
                    if (c > '\u007f') {
                        stringBuffer2.append("\\");
                        stringBuffer2.append(Integer.toOctalString(c));
                    } else {
                        switch (c) {
                            case '(': 
                            case ')': 
                            case '\\': {
                                stringBuffer2.append("\\");
                                break;
                            }
                        }
                        stringBuffer2.append(c);
                    }
                } else {
                    stringBuffer2.append(this.getUnicodeString(c));
                }
                if (bl && n6 + 1 < n5) {
                    this.addKerning(stringBuffer2, new Integer(c), new Integer(wordArea.getFontState().mapChar(string.charAt(n6 + 1))), hashtable, string4, string2);
                }
                ++n6;
            }
            stringBuffer2.append(string2);
            this.currentStream.add(stringBuffer2.toString());
            this.currentXPosition += wordArea.getContentWidth();
        }
    }

    public void setOptions(Hashtable hashtable) {
        this.options = hashtable;
    }

    public void setProducer(String string) {
        this.pdfDoc.setProducer(string);
    }

    private String setRuleStylePattern(int n) {
        String string = "";
        switch (n) {
            case 70: {
                string = "[] 0 d ";
                break;
            }
            case 16: {
                string = "[3 3] 0 d ";
                break;
            }
            case 20: {
                string = "[1 3] 0 d ";
                break;
            }
            case 21: {
                string = "[] 0 d ";
                break;
            }
            default: {
                string = "[] 0 d ";
            }
        }
        return string;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.pdfDoc.outputHeader(outputStream);
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.renderRootExtensions(this.extensions);
        FontSetup.addToResources(this.pdfDoc, this.fontInfo);
        this.pdfDoc.outputTrailer(outputStream);
        this.pdfDoc = new PDFDocument();
        this.pdfResources = null;
        this.extensions = null;
        this.currentStream = null;
        this.currentAnnotList = null;
        this.currentPage = null;
        this.currentColor = null;
        super.stopRenderer(outputStream);
    }
}

