/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.fonts;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.fop.fonts.FontFileReader;
import org.apache.fop.fonts.TTFSubSetFile;
import org.apache.fop.layout.FontDescriptor;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFWArray;
import org.apache.fop.render.pdf.CIDFont;
import org.apache.fop.render.pdf.fonts.BFEntry;

public class MultiByteFont
extends CIDFont
implements FontDescriptor {
    public String fontName = null;
    public String ttcName = null;
    public String encoding = "Identity-H";
    public int capHeight = 0;
    public int xHeight = 0;
    public int ascender = 0;
    public int descender = 0;
    public int[] fontBBox = new int[4];
    public String embedFileName = null;
    public String embedResourceName = null;
    public PDFTTFStream embeddedFont = null;
    public int flags = 4;
    public int stemV = 0;
    public int italicAngle = 0;
    public int missingWidth = 0;
    public int defaultWidth = 0;
    public byte cidType = 1;
    public Hashtable kerning = new Hashtable();
    public boolean useKerning = true;
    private String namePrefix = null;
    private static int uniqueCounter = 1;
    public PDFWArray warray = new PDFWArray();
    public int[] width = null;
    public BFEntry[] bfentries = null;
    private Hashtable usedGlyphs = new Hashtable();
    private Hashtable usedGlyphsIndex = new Hashtable();
    int usedGlyphsCount = 0;

    public MultiByteFont() {
        this.usedGlyphs.put(new Integer(0), new Integer(0));
        this.usedGlyphsIndex.put(new Integer(0), new Integer(0));
        ++this.usedGlyphsCount;
        this.usedGlyphs.put(new Integer(1), new Integer(1));
        this.usedGlyphsIndex.put(new Integer(1), new Integer(1));
        ++this.usedGlyphsCount;
        this.usedGlyphs.put(new Integer(2), new Integer(2));
        this.usedGlyphsIndex.put(new Integer(2), new Integer(2));
        ++this.usedGlyphsCount;
        int n = 0;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            n = uniqueCounter++;
        }
        int n2 = (int)(System.currentTimeMillis() & 0xFFFFL);
        this.namePrefix = new String(String.valueOf(n) + "E" + Integer.toHexString(n2));
    }

    public String encoding() {
        return this.encoding;
    }

    public String fontName() {
        return this.isEmbeddable() ? String.valueOf(this.namePrefix) + this.fontName : this.fontName;
    }

    public int getAscender() {
        return this.ascender;
    }

    public int getAscender(int n) {
        return n * this.ascender;
    }

    public int getAvgWidth() {
        return -1;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public int getCapHeight(int n) {
        return n * this.capHeight;
    }

    public String getCharEncoding() {
        return "Identity-H";
    }

    public String getCidBaseFont() {
        return this.isEmbeddable() ? String.valueOf(this.namePrefix) + this.fontName : this.fontName;
    }

    public byte getCidType() {
        return this.cidType;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public int getDescender() {
        return this.descender;
    }

    public int getDescender(int n) {
        return n * this.descender;
    }

    public int getFirstChar() {
        return 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBBox() {
        return this.fontBBox;
    }

    public PDFStream getFontFile(int n) {
        try {
            FontFileReader fontFileReader = new FontFileReader(this.embedFileName);
            TTFSubSetFile tTFSubSetFile = new TTFSubSetFile();
            byte[] byArray = tTFSubSetFile.readFont(fontFileReader, this.ttcName, this.usedGlyphs);
            this.embeddedFont = new PDFTTFStream(n, byArray.length);
            this.embeddedFont.addFilter("flate");
            this.embeddedFont.addFilter("ascii-85");
            this.embeddedFont.setData(byArray, byArray.length);
        }
        catch (IOException iOException) {
            MessageHandler.errorln("Failed to embed font [" + n + "] " + this.fontName + ": " + iOException.getMessage());
            return null;
        }
        return this.embeddedFont;
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public final Hashtable getKerningInfo() {
        if (this.useKerning) {
            return this.kerning;
        }
        return new Hashtable();
    }

    public String getLang() {
        return null;
    }

    public int getLastChar() {
        return 255;
    }

    public int getMaxWidth() {
        return -1;
    }

    public int getMinWidth() {
        return -1;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    public String getOrdering() {
        return "UCS";
    }

    public String getPanose() {
        return null;
    }

    public String getRegistry() {
        return "Adobe";
    }

    public int getStemH() {
        return 0;
    }

    public int getStemV() {
        return this.stemV;
    }

    public byte getSubType() {
        return 0;
    }

    public int getSupplement() {
        return 0;
    }

    public PDFWArray getWidths() {
        if (this.isEmbeddable()) {
            this.warray = new PDFWArray();
            int[] nArray = new int[this.usedGlyphsCount];
            int n = 0;
            while (n < this.usedGlyphsCount) {
                Integer n2 = (Integer)this.usedGlyphsIndex.get(new Integer(n));
                int n3 = n2 == null ? 0 : n2;
                nArray[n] = this.width[n3];
                ++n;
            }
            this.warray.addEntry(0, nArray);
        }
        return this.warray;
    }

    public int[] getWidths(int n) {
        int[] nArray = new int[this.width.length];
        System.arraycopy(this.width, 0, nArray, 0, this.width.length - 1);
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] * n;
        }
        return nArray;
    }

    public int getXHeight(int n) {
        return n * this.xHeight;
    }

    public int getleading() {
        return -1;
    }

    public final boolean hasKerningInfo() {
        return this.useKerning & this.kerning.isEmpty();
    }

    public boolean isEmbeddable() {
        return this.embedFileName != null || this.embedResourceName != null;
    }

    public char mapChar(char c) {
        char c2 = c;
        int n = 0;
        int n2 = 0;
        while (n2 < this.bfentries.length && n == 0) {
            if (this.bfentries[n2].unicodeStart <= c2 && this.bfentries[n2].unicodeEnd >= c2) {
                n = this.bfentries[n2].glyphStartIndex + c2 - this.bfentries[n2].unicodeStart;
            }
            ++n2;
        }
        if (this.isEmbeddable()) {
            Integer n3 = (Integer)this.usedGlyphs.get(new Integer(n));
            if (n3 == null) {
                this.usedGlyphs.put(new Integer(n), new Integer(this.usedGlyphsCount));
                this.usedGlyphsIndex.put(new Integer(this.usedGlyphsCount), new Integer(n));
                n = this.usedGlyphsCount++;
            } else {
                n = n3;
            }
        }
        return (char)n;
    }

    public Integer reMap(Integer n) {
        if (this.isEmbeddable()) {
            Integer n2 = (Integer)this.usedGlyphsIndex.get(n);
            if (n2 == null) {
                n2 = n;
            }
            return n2;
        }
        return n;
    }

    public int width(int n, int n2) {
        if (this.isEmbeddable()) {
            Integer n3 = (Integer)this.usedGlyphsIndex.get(new Integer(n));
            return n2 * this.width[n3];
        }
        return n2 * this.width[n];
    }
}

