/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.fop.render.ps.Filter;
import org.apache.fop.render.ps.FilterThread;

public class ASCII85EncodeFilter
implements Filter {
    private static final char ASCII85_ZERO = 'z';
    private static final char ASCII85_START = '!';
    private static final char ASCII85_EOL = '\n';
    private static final String ASCII85_EOD = "~>";
    private static final String ENCODING = "US-ASCII";
    private static final long base85_4 = 85L;
    private static final long base85_3 = 7225L;
    private static final long base85_2 = 614125L;
    private static final long base85_1 = 52200625L;

    protected ASCII85EncodeFilter() {
    }

    private byte[] convertWord(long l) {
        if ((l &= 0xFFFFFFFFFFFFFFFFL) < 0L) {
            l = -l;
        }
        if (l == 0L) {
            byte[] byArray = new byte[]{122};
            return byArray;
        }
        byte by = (byte)(l / 52200625L & 0xFFL);
        byte by2 = (byte)((l - (long)by * 52200625L) / 614125L & 0xFFL);
        byte by3 = (byte)((l - (long)by * 52200625L - (long)by2 * 614125L) / 7225L & 0xFFL);
        byte by4 = (byte)((l - (long)by * 52200625L - (long)by2 * 614125L - (long)by3 * 7225L) / 85L & 0xFFL);
        byte by5 = (byte)(l - (long)by * 52200625L - (long)by2 * 614125L - (long)by3 * 7225L - (long)by4 * 85L & 0xFFL);
        byte[] byArray = new byte[]{(byte)(by + 33), (byte)(by2 + 33), (byte)(by3 + 33), (byte)(by4 + 33), (byte)(by5 + 33)};
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] < 33 || byArray[n] > 117) {
                System.out.println("Illegal char value " + new Integer(byArray[n]));
            }
            ++n;
        }
        return byArray;
    }

    public void doFilter(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        byte[] byArray = new byte[4];
        while ((n = inputStream.read(byArray)) == byArray.length) {
            long l2 = ((long)(byArray[0] << 24) & 0xFF000000L) + ((long)(byArray[1] << 16) & 0xFF0000L) + ((long)(byArray[2] << 8) & 0xFF00L) + ((long)byArray[3] & 0xFFL);
            byte[] byArray2 = this.convertWord(l2);
            l = this.write(outputStream, byArray2, byArray2.length, l);
        }
        if (n < byArray.length && n >= 0) {
            byte[] byArray3;
            int n2 = byArray.length - n;
            byte[] byArray4 = new byte[4];
            int n3 = 0;
            int n4 = 0;
            while (n4 < 4) {
                byArray4[n4] = n4 < n2 ? byArray[n3++] : (byte)0;
                ++n4;
            }
            long l3 = ((long)(byArray4[0] << 24) & 0xFF000000L) + ((long)(byArray4[1] << 16) & 0xFF0000L) + ((long)(byArray4[2] << 8) & 0xFF00L) + ((long)byArray4[3] & 0xFFL);
            if (l3 != 0L) {
                byArray3 = this.convertWord(l3);
            } else {
                byArray3 = new byte[5];
                int n5 = 0;
                while (n5 < 5) {
                    byArray3[n5] = 33;
                    ++n5;
                }
            }
            l = this.write(outputStream, byArray3, n2 + 1, l);
        }
        byte[] byArray5 = ASCII85_EOD.getBytes();
        l = this.write(outputStream, byArray5, byArray5.length, l);
    }

    public static InputStream filter(InputStream inputStream) throws IOException {
        ASCII85EncodeFilter aSCII85EncodeFilter = new ASCII85EncodeFilter();
        return FilterThread.filter(inputStream, aSCII85EncodeFilter);
    }

    public long write(OutputStream outputStream, byte[] byArray, int n, long l) throws IOException {
        int n2 = (int)(l % 80L) + n;
        if (n2 >= 80) {
            int n3 = n - (n2 - 80);
            outputStream.write(byArray, 0, n3);
            outputStream.write(10);
            outputStream.write(byArray, n3, n - n3);
        } else {
            outputStream.write(byArray, 0, n);
        }
        return l + (long)n;
    }
}

