/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.txt;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.pcl.PCLStream;
import org.apache.fop.svg.SVGArea;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class TXTRenderer
extends PrintRenderer {
    PCLStream currentStream;
    private int pageHeight = 7920;
    public int curdiv = 0;
    private int divisions = -1;
    private int paperheight = -1;
    public int orientation = -1;
    public int topmargin = -1;
    public int leftmargin = -1;
    private int fullmargin = 0;
    final boolean debug = false;
    StringBuffer[] charData;
    StringBuffer[] decoData;
    public float textCPI = 16.67f;
    public float textLPI = 8.0f;
    int maxX = (int)(8.5f * this.textCPI + 1.0f);
    int maxY = (int)(11.0f * this.textLPI + 1.0f);
    float xFactor;
    float yFactor;
    public String lineEnding = "\r\n";
    public String pageEnding = "\f";
    public boolean suppressGraphics = false;
    boolean firstPage = false;
    protected Hashtable options;

    protected void addLine(float f, float f2, float f3, float f4, PDFColor pDFColor, float f5) {
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, int n6, PDFPathPaint pDFPathPaint) {
        PDFColor pDFColor = null;
        pDFColor = n6 == 20 ? new PDFColor(0.7f, 0.7f, 0.7f) : (PDFColor)pDFPathPaint;
        if (n == n3) {
            this.addRect(n, n2, n5, n4 - n2 + 1, pDFColor, pDFColor);
        } else if (n2 == n4) {
            this.addRect(n, n2, n3 - n + 1, n5, pDFColor, pDFColor);
        }
    }

    protected void addLine(int n, int n2, int n3, int n4, int n5, PDFPathPaint pDFPathPaint) {
        if (n == n3) {
            this.addRect(n, n2, n5, n4 - n2 + 1, pDFPathPaint, pDFPathPaint);
        } else if (n2 == n4) {
            this.addRect(n, n2, n3 - n + 1, n5, pDFPathPaint, pDFPathPaint);
        }
    }

    protected void addPolyline(Vector vector, int n, int n2, PDFColor pDFColor, PDFColor pDFColor2, float f, boolean bl) {
    }

    protected void addRect(float f, float f2, float f3, float f4, float f5, float f6, PDFColor pDFColor, PDFColor pDFColor2, float f7) {
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint) {
        if (n4 < 0) {
            n4 *= -1;
        }
        if (n4 < 720 || n3 < 720) {
            if (n3 < 720) {
                n3 = 720;
            }
            if (n4 < 720) {
                n4 = 720;
            }
            this.addRect(n, n2, n3, n4, pDFPathPaint, pDFPathPaint);
        } else {
            this.addRect(n, n2, n3, 720, pDFPathPaint, pDFPathPaint);
            this.addRect(n, n2, 720, n4, pDFPathPaint, pDFPathPaint);
            this.addRect(n + n3 - 720, n2, 720, n4, pDFPathPaint, pDFPathPaint);
            this.addRect(n, n2 - n4 + 720, n3, 720, pDFPathPaint, pDFPathPaint);
        }
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint, PDFPathPaint pDFPathPaint2) {
        int n5;
        int n6;
        if (n3 == 0 || n4 == 0) {
            return;
        }
        if (n4 < 0) {
            n4 *= -1;
        }
        int n7 = (int)((float)((this.pageHeight - n2 / 100) * 100) * this.yFactor);
        int n8 = (int)((float)n * this.xFactor);
        PDFColor pDFColor = (PDFColor)pDFPathPaint;
        PDFColor pDFColor2 = (PDFColor)pDFPathPaint2;
        pDFColor.setColorSpace(ColorSpace.DEVICE_RGB);
        pDFColor2.setColorSpace(ColorSpace.DEVICE_RGB);
        int n9 = (int)(100.0 - ((double)0.3f * pDFColor.red() + (double)0.59f * pDFColor.green() + (double)0.11f * pDFColor.blue()) * 100.0);
        int n10 = (int)(100.0 - ((double)0.3f * pDFColor2.red() + (double)0.59f * pDFColor2.green() + (double)0.11f * pDFColor2.blue()) * 100.0);
        char c = ' ';
        if (n10 >= 75) {
            c = '#';
        } else if (n10 >= 50) {
            c = '*';
        } else if (n10 >= 25) {
            c = ':';
        }
        if (c != ' ') {
            StringBuffer stringBuffer = new StringBuffer();
            n6 = (int)((float)n3 * this.xFactor);
            int n11 = (int)((float)n4 * this.yFactor);
            if (n6 == 0 || n11 == 0) {
                c = n10 >= 50 ? (n4 > n3 ? (char)'|' : '-') : (n4 > n3 ? (char)':' : '.');
            }
            if (n6 == 0) {
                stringBuffer.append(c);
            } else {
                n5 = 0;
                while (n5 < n6) {
                    stringBuffer.append(c);
                    ++n5;
                }
            }
            if (n11 == 0) {
                this.addStr(n7, n8, stringBuffer.toString(), false);
            } else {
                n5 = 0;
                while (n5 < n11) {
                    this.addStr(n7 + n5, n8, stringBuffer.toString(), false);
                    ++n5;
                }
            }
        }
        if (n9 >= 25) {
            char c2 = '|';
            n6 = 45;
            if (n9 < 50) {
                c2 = ':';
                n6 = 46;
            }
            StringBuffer stringBuffer = new StringBuffer();
            n5 = (int)((float)n3 * this.xFactor);
            int n12 = 0;
            while (n12 < n5) {
                stringBuffer.append((char)n6);
                ++n12;
            }
            int n13 = (int)((float)n4 * this.yFactor);
            if (n3 > n4) {
                int n14 = 1;
                while (n14 < n13 - 1) {
                    this.addStr(n7 + n14, n8, String.valueOf(c2), false);
                    this.addStr(n7 + n14, n8 + n5, String.valueOf(c2), false);
                    ++n14;
                }
                this.addStr(n7, n8, stringBuffer.toString(), false);
                this.addStr(n7 + n13, n8, stringBuffer.toString(), false);
            } else {
                this.addStr(n7, n8, stringBuffer.toString(), false);
                this.addStr(n7 + n13, n8, stringBuffer.toString(), false);
                int n15 = 1;
                while (n15 < n13 - 1) {
                    this.addStr(n7 + n15, n8, String.valueOf(c2), false);
                    this.addStr(n7 + n15, n8 + n5, String.valueOf(c2), false);
                    ++n15;
                }
            }
        }
    }

    void addStr(int n, int n2, String string, boolean bl) {
        StringBuffer stringBuffer;
        if (this.suppressGraphics && !bl) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if ((stringBuffer = bl ? this.charData[n] : this.decoData[n]) == null) {
            stringBuffer = new StringBuffer();
        }
        if (n2 + string.length() > this.maxX) {
            n2 = this.maxX - string.length();
        }
        if (n2 < 0) {
            n2 = 0;
            if (string.length() > this.maxX) {
                string = string.substring(0, this.maxX);
            }
        }
        int n3 = stringBuffer.length();
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        int n4 = n2;
        while (n4 < n2 + string.length()) {
            if (n4 >= stringBuffer.length()) {
                stringBuffer.append(string.charAt(n4 - n2));
            } else {
                stringBuffer.setCharAt(n4, string.charAt(n4 - n2));
            }
            ++n4;
        }
        if (bl) {
            this.charData[n] = stringBuffer;
        } else {
            this.decoData[n] = stringBuffer;
        }
    }

    boolean printBMP(FopImage fopImage, int n, int n2, int n3, int n4) throws FopImageException {
        int n5;
        this.addRect(n, n2, n3, n4, new PDFColor(1.0, 1.0, 1.0), new PDFColor(0.0, 0.0, 0.0));
        int n6 = (int)((float)n4 * this.yFactor / 2.0f);
        if (n6 > 0 && (n5 = (int)((float)n3 * this.xFactor)) > 4) {
            String string = fopImage.getURL();
            if (string.length() >= n5) {
                this.addStr((int)((float)((this.pageHeight - n2 / 100) * 100) * this.yFactor) + n6, (int)((float)n * this.xFactor), string.substring(string.length() - n5), true);
            } else {
                this.addStr((int)((float)((this.pageHeight - n2 / 100) * 100) * this.yFactor) + n6, (int)((float)n * this.xFactor + (float)((n5 - string.length()) / 2)), string, true);
            }
        }
        return true;
    }

    public void render(Page page, OutputStream outputStream) {
        this.idReferences = page.getIDReferences();
        if (this.firstPage) {
            this.firstPage = false;
        } else {
            this.currentStream.add(this.pageEnding);
        }
        this.renderPage(page);
        this.currentStream.add(this.lineEnding);
    }

    public void renderForeignObjectArea(ForeignObjectArea foreignObjectArea) {
        this.currentXPosition += foreignObjectArea.getXOffset();
        this.currentYPosition = this.currentYPosition;
        switch (foreignObjectArea.getAlign()) {
            default: 
        }
        switch (foreignObjectArea.getVerticalAlign()) {
            default: 
        }
        switch (foreignObjectArea.scalingMethod()) {
            default: 
        }
        switch (foreignObjectArea.getOverflow()) {
            default: 
        }
        foreignObjectArea.getObject().render(this);
        this.currentXPosition += foreignObjectArea.getEffectiveWidth();
    }

    public void renderImage(FontState fontState, String string, float f, float f2, float f3, float f4) {
        try {
            FopImage fopImage;
            if (string.indexOf(":") == -1) {
                string = "file:" + string;
            }
            if ((fopImage = FopImageFactory.Make(string)) != null) {
                if (fopImage instanceof SVGImage) {
                    SVGSVGElement sVGSVGElement = ((SVGImage)fopImage).getSVGDocument().getRootElement();
                    this.renderSVG(fontState, sVGSVGElement, (int)f * 1000, (int)f2 * 1000);
                } else {
                    this.printBMP(fopImage, (int)f, (int)f2, (int)f3, (int)f4);
                }
            }
        }
        catch (Exception exception) {
            this.log.error("could not add image to SVG: " + string, (Throwable)exception);
        }
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        try {
            this.printBMP(fopImage, n, n2, n3, n4);
        }
        catch (FopImageException fopImageException) {
            this.log.error("TXTRenderer.renderImageArea() printing BMP (" + fopImageException.toString() + ").", (Throwable)fopImageException);
        }
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderPage(Page page) {
        this.maxX = (int)(this.textCPI * (float)page.getWidth() / 72000.0f + 1.0f);
        this.maxY = (int)(this.textLPI * (float)page.getHeight() / 72000.0f + 1.0f);
        this.xFactor = (float)(this.maxX - 1) / (float)page.getWidth();
        this.yFactor = (float)(this.maxY - 1) / (float)page.getHeight();
        this.charData = new StringBuffer[this.maxY + 1];
        this.decoData = new StringBuffer[this.maxY + 1];
        this.pageHeight = this.paperheight > 0 ? this.paperheight : page.getHeight() / 100;
        BodyAreaContainer bodyAreaContainer = page.getBody();
        AreaContainer areaContainer = page.getBefore();
        AreaContainer areaContainer2 = page.getAfter();
        AreaContainer areaContainer3 = page.getStart();
        AreaContainer areaContainer4 = page.getEnd();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.renderBodyAreaContainer(bodyAreaContainer);
        if (areaContainer != null) {
            this.renderAreaContainer(areaContainer);
        }
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        if (areaContainer3 != null) {
            this.renderAreaContainer(areaContainer3);
        }
        if (areaContainer4 != null) {
            this.renderAreaContainer(areaContainer4);
        }
        int n = 0;
        while (n <= this.maxY) {
            StringBuffer stringBuffer = this.charData[n];
            StringBuffer stringBuffer2 = this.decoData[n];
            StringBuffer stringBuffer3 = null;
            if (stringBuffer != null && stringBuffer2 == null) {
                stringBuffer3 = stringBuffer;
            } else if (stringBuffer2 != null && stringBuffer == null) {
                stringBuffer3 = stringBuffer2;
            } else if (stringBuffer != null && stringBuffer2 != null) {
                int n2 = stringBuffer2.length();
                if (stringBuffer.length() > n2) {
                    n2 = stringBuffer.length();
                }
                stringBuffer3 = new StringBuffer();
                int n3 = 0;
                while (n3 < n2) {
                    if (n3 < stringBuffer.length() && stringBuffer.charAt(n3) != ' ') {
                        stringBuffer3.append(stringBuffer.charAt(n3));
                    } else if (n3 < stringBuffer2.length()) {
                        stringBuffer3.append(stringBuffer2.charAt(n3));
                    } else {
                        stringBuffer3.append(' ');
                    }
                    ++n3;
                }
            }
            if (stringBuffer3 != null) {
                this.currentStream.add(stringBuffer3.toString());
            }
            if (n < this.maxY) {
                this.currentStream.add(this.lineEnding);
            }
            ++n;
        }
    }

    void renderSVG(FontState fontState, SVGSVGElement sVGSVGElement, int n, int n2) {
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentAreaContainerXPosition;
        int n2 = this.currentYPosition;
        SVGSVGElement sVGSVGElement = ((SVGDocument)sVGArea.getSVGDocument()).getRootElement();
        int n3 = (int)(sVGSVGElement.getWidth().getBaseVal().getValue() * 1000.0f);
        int n4 = (int)(sVGSVGElement.getHeight().getBaseVal().getValue() * 1000.0f);
        this.renderSVG(sVGArea.getFontState(), sVGSVGElement, n, n2);
    }

    public void renderWordArea(WordArea wordArea) {
        String string;
        int n = this.currentXPosition;
        int n2 = this.currentYPosition;
        if (wordArea.getPageNumberID() != null) {
            string = this.idReferences.getPageNumber(wordArea.getPageNumberID());
            if (string == null) {
                string = "";
            }
        } else {
            string = wordArea.getText();
        }
        this.addStr((int)((float)((this.pageHeight - n2 / 100) * 100) * this.yFactor) - 1, (int)((float)n * this.xFactor), string, true);
        this.currentXPosition += wordArea.getContentWidth();
    }

    private void setFont(String string, float f) {
    }

    public void setOptions(Hashtable hashtable) {
        this.options = hashtable;
    }

    public void setProducer(String string) {
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.info("rendering areas to TEXT");
        this.currentStream = new PCLStream(outputStream);
        this.firstPage = true;
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.log.info("writing out TEXT");
        outputStream.flush();
    }

    private void xferLineBytes(int n, int n2, Vector vector, int n3) {
    }
}

