/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.geom.AffineTransform;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.DefaultSVGContext;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.SVGObj;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SVGElement
extends SVGObj {
    FontState fs;
    public static final List FONT_FAMILY = new ArrayList();

    static {
        FONT_FAMILY.add("Helvetica");
        FONT_FAMILY.add("Times");
        FONT_FAMILY.add("Courier");
        FONT_FAMILY.add("sans-serif");
        FONT_FAMILY.add("serif");
    }

    public SVGElement(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList, "svg");
        this.init();
    }

    private void init() {
        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        String string = "http://www.w3.org/2000/svg";
        this.doc = dOMImplementation.createDocument(string, "svg", null);
        this.element = this.doc.getDocumentElement();
        this.buildTopLevel(this.doc, this.element);
    }

    public Status layout(final Area area) throws FOPException {
        String string;
        if (!(area instanceof ForeignObjectArea)) {
            throw new FOPException("SVG not in fo:instream-foreign-object");
        }
        if (this.marker == -1000) {
            this.fs = area.getFontState();
            this.marker = 0;
        }
        final Element element = this.element;
        DefaultSVGContext defaultSVGContext = new DefaultSVGContext(){

            public List getDefaultFontFamilyValue() {
                return FONT_FAMILY;
            }

            public float getPixelToMM() {
                return 0.35277778f;
            }

            public float getViewportHeight(Element element2) throws IllegalStateException {
                ForeignObjectArea foreignObjectArea;
                if (element2 == element && !(foreignObjectArea = (ForeignObjectArea)area).isContentHeightAuto()) {
                    return foreignObjectArea.getContentHeight();
                }
                return super.getViewportHeight(element2);
            }

            public float getViewportWidth(Element element2) throws IllegalStateException {
                ForeignObjectArea foreignObjectArea;
                if (element2 == element && !(foreignObjectArea = (ForeignObjectArea)area).isContentWidthAuto()) {
                    return foreignObjectArea.getContentWidth();
                }
                return super.getViewportWidth(element2);
            }
        };
        ((SVGOMDocument)this.doc).setSVGContext((SVGContext)defaultSVGContext);
        try {
            string = Configuration.getStringValue("baseDir");
            ((SVGOMDocument)this.doc).setURLObject(new URL(string));
        }
        catch (Exception exception) {
            this.log.error("Could not set base URL for svg", (Throwable)exception);
        }
        string = ((SVGDocument)this.doc).getRootElement();
        SVGUserAgent sVGUserAgent = new SVGUserAgent(new AffineTransform());
        sVGUserAgent.setLogger(this.log);
        BridgeContext bridgeContext = new BridgeContext((UserAgent)sVGUserAgent);
        UnitProcessor.Context context = UnitProcessor.createContext((BridgeContext)bridgeContext, (Element)((Object)string));
        String string2 = string.getAttributeNS(null, "width");
        if (string2.length() == 0) {
            string2 = "100%";
        }
        float f = UnitProcessor.svgHorizontalLengthToUserSpace((String)string2, (String)"width", (UnitProcessor.Context)context);
        string2 = string.getAttributeNS(null, "height");
        if (string2.length() == 0) {
            string2 = "100%";
        }
        float f2 = UnitProcessor.svgVerticalLengthToUserSpace((String)string2, (String)"height", (UnitProcessor.Context)context);
        SVGArea sVGArea = new SVGArea(this.fs, f, f2);
        sVGArea.setSVGDocument(this.doc);
        sVGArea.start();
        sVGArea.end();
        ForeignObjectArea foreignObjectArea = (ForeignObjectArea)area;
        foreignObjectArea.setObject(sVGArea);
        foreignObjectArea.setIntrinsicWidth(sVGArea.getWidth());
        foreignObjectArea.setIntrinsicHeight(sVGArea.getHeight());
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new SVGElement(fObj, propertyList);
        }
    }
}

