/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.fop.configuration.Configuration;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.StreamTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TestConverter {
    boolean failOnly = false;
    boolean outputPDF = false;
    File destdir;
    File compare = null;
    String baseDir = "./";
    Hashtable differ = new Hashtable();
    private Logger log;

    public TestConverter() {
        this.setupLogging();
    }

    protected boolean compareFiles(File file, File file2) {
        if (file.length() != file2.length()) {
            return false;
        }
        try {
            int n;
            int n2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file2));
            while ((n2 = ((InputStream)bufferedInputStream).read()) == (n = ((InputStream)bufferedInputStream2).read())) {
                if (n2 != -1) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Node locateResult(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            String string2;
            Node node2 = nodeList.item(n);
            String string3 = node2.getNodeName();
            if (string3.equals("result") && string.equals(string2 = node2.getAttributes().getNamedItem("id").getNodeValue())) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            System.out.println("test suite file name required");
        }
        TestConverter testConverter = new TestConverter();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-failOnly")) {
                testConverter.setFailOnly(true);
            } else if (stringArray[n].equals("-pdf")) {
                testConverter.setOutputPDF(true);
            } else if (stringArray[n].equals("-b")) {
                testConverter.setBaseDir(stringArray[n + 1]);
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        if (string == null) {
            System.out.println("test suite file name required");
        }
        testConverter.runTests(string, "results", null);
    }

    protected void runTest(Node node, Node node2) {
        String string;
        String string2 = node2.getAttributes().getNamedItem("id").getNodeValue();
        Node node3 = this.locateResult(node, string2);
        boolean bl = false;
        if (node3 != null) {
            string = node3.getAttributes().getNamedItem("agreement").getNodeValue();
            bl = string.equals("full");
        }
        if (bl && this.failOnly) {
            return;
        }
        string = node2.getAttributes().getNamedItem("xml").getNodeValue();
        Node node4 = node2.getAttributes().getNamedItem("xsl");
        String string3 = null;
        if (node4 != null) {
            string3 = node4.getNodeValue();
        }
        this.log.debug("converting xml:" + string + " and xsl:" + string3 + " to area tree");
        try {
            File file;
            File file2;
            File file3 = new File(String.valueOf(this.baseDir) + "/" + string);
            try {
                Configuration.put("baseDir", file3.getParentFile().toURL().toExternalForm());
            }
            catch (Exception exception) {
                this.log.error("Error setting base directory");
            }
            InputHandler inputHandler = null;
            inputHandler = string3 == null ? new FOInputHandler(file3) : new XSLTInputHandler(file3, new File(String.valueOf(this.baseDir) + "/" + string3));
            XMLReader xMLReader = inputHandler.getParser();
            this.setParserFeatures(xMLReader);
            Logger logger = this.log.getChildLogger("fop");
            Driver driver = new Driver();
            driver.setLogger(logger);
            if (this.outputPDF) {
                driver.setRenderer(1);
            } else {
                driver.setRenderer(4);
            }
            Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
            hashtable.put("fineDetail", new Boolean(false));
            hashtable.put("consistentOutput", new Boolean(true));
            driver.getRenderer().setOptions(hashtable);
            driver.getRenderer().setProducer("Testsuite Converter");
            String string4 = file3.getName();
            if (string4.endsWith(".xml")) {
                string4 = string4.substring(0, string4.length() - 4);
            }
            driver.setOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.destdir, String.valueOf(string4) + (this.outputPDF ? ".pdf" : ".at.xml")))));
            this.log.debug("ddir:" + this.destdir + " on:" + string4 + ".pdf");
            driver.render(xMLReader, inputHandler.getInputSource());
            if (this.compare != null && !this.compareFiles(file2 = new File(this.destdir, String.valueOf(string4) + ".at.xml"), file = new File(this.compare, String.valueOf(string4) + ".at.xml"))) {
                this.differ.put(String.valueOf(string4) + ".at.xml", new Boolean(bl));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void runTestCase(Node node) {
        Object object;
        if (node.hasAttributes()) {
            object = node.getAttributes().getNamedItem("profile").getNodeValue();
            this.log.debug("testing profile:" + (String)object);
        }
        object = node.getChildNodes();
        int n = 0;
        while (n < object.getLength()) {
            Node node2 = object.item(n);
            String string = node2.getNodeName();
            if (string.equals("testcases")) {
                this.runTestCase(node2);
            } else if (string.equals("test")) {
                this.runTest(node, node2);
            } else {
                string.equals("result");
            }
            ++n;
        }
    }

    public Hashtable runTests(String string, String string2, String string3) {
        this.log.debug("running tests in file:" + string);
        try {
            Object object;
            if (string3 != null) {
                this.compare = new File(String.valueOf(this.baseDir) + "/" + string3);
            }
            this.destdir = new File(String.valueOf(this.baseDir) + "/" + string2);
            this.destdir.mkdirs();
            File file = new File(String.valueOf(this.baseDir) + "/" + string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getChildNodes();
            if (nodeList.getLength() == 0) {
                return this.differ;
            }
            Element element = null;
            element = document.getDocumentElement();
            if (element.hasAttributes()) {
                object = element.getAttributes().getNamedItem("profile").getNodeValue();
                this.log.debug("testing test suite:" + (String)object);
            }
            object = element.getChildNodes();
            int n = 0;
            while (n < object.getLength()) {
                Node node = object.item(n);
                if (node.getNodeName().equals("testcases")) {
                    this.runTestCase(node);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.differ;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public void setFailOnly(boolean bl) {
        this.failOnly = bl;
    }

    public void setOutputPDF(boolean bl) {
        this.outputPDF = bl;
    }

    public void setParserFeatures(XMLReader xMLReader) throws FOPException {
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException sAXException) {
            throw new FOPException("Error in setting up parser feature namespace-prefixes\nYou need a parser which supports SAX version 2", sAXException);
        }
    }

    private void setupLogging() {
        Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
        PatternFormatter patternFormatter = new PatternFormatter("[%{priority}]: %{message}\n%{throwable}");
        StreamTarget streamTarget = null;
        streamTarget = new StreamTarget((OutputStream)System.out, (Formatter)patternFormatter);
        hierarchy.setDefaultLogTarget((LogTarget)streamTarget);
        this.log = hierarchy.getLoggerFor("test");
        this.log.setPriority(Priority.ERROR);
    }
}

