/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout.hyphenation;

import java.io.Serializable;

public class ByteVector
implements Serializable {
    private static final int DEFAULT_BLOCK_SIZE = 2048;
    private int BLOCK_SIZE;
    private byte[] array;
    private int n;

    public ByteVector() {
        this(2048);
    }

    public ByteVector(int n) {
        this.BLOCK_SIZE = n > 0 ? n : 2048;
        this.array = new byte[this.BLOCK_SIZE];
        this.n = 0;
    }

    public ByteVector(byte[] byArray) {
        this.BLOCK_SIZE = 2048;
        this.array = byArray;
        this.n = 0;
    }

    public ByteVector(byte[] byArray, int n) {
        this.BLOCK_SIZE = n > 0 ? n : 2048;
        this.array = byArray;
        this.n = 0;
    }

    public byte[] getArray() {
        return this.array;
    }

    public int length() {
        return this.n;
    }

    public int capacity() {
        return this.array.length;
    }

    public void put(int n, byte by) {
        this.array[n] = by;
    }

    public byte get(int n) {
        return this.array[n];
    }

    public int alloc(int n) {
        int n2 = this.n;
        int n3 = this.array.length;
        if (this.n + n >= n3) {
            byte[] byArray = new byte[n3 + this.BLOCK_SIZE];
            System.arraycopy(this.array, 0, byArray, 0, n3);
            this.array = byArray;
        }
        this.n += n;
        return n2;
    }

    public void trimToSize() {
        if (this.n < this.array.length) {
            byte[] byArray = new byte[this.n];
            System.arraycopy(this.array, 0, byArray, 0, this.n);
            this.array = byArray;
        }
    }
}

