/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public class Compare {
    private String referenceDirectory;
    private String testDirectory;
    private String[] filenameList;
    private String filenames;
    private static boolean IDENTICAL_FILES = true;
    private static boolean NOTIDENTICAL_FILES = false;
    private BufferedInputStream oldfileInput;
    private BufferedInputStream newfileInput;

    public void setTestDirectory(String string) {
        if (!(string.endsWith("/") | string.endsWith("\\"))) {
            string = string + File.separator;
        }
        this.testDirectory = string;
    }

    public void setReferenceDirectory(String string) {
        if (!(string.endsWith("/") | string.endsWith("\\"))) {
            string = string + File.separator;
        }
        this.referenceDirectory = string;
    }

    public void setFilenames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>(20);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        this.filenameList = new String[vector.size()];
        vector.copyInto(this.filenameList);
    }

    private boolean compareBytes(File file, File file2) {
        try {
            this.oldfileInput = new BufferedInputStream(new FileInputStream(file));
            this.newfileInput = new BufferedInputStream(new FileInputStream(file2));
            int n = 0;
            int n2 = 0;
            boolean bl = true;
            while (bl & n != -1) {
                if (n == n2) {
                    n = this.oldfileInput.read();
                    n2 = this.newfileInput.read();
                    continue;
                }
                return NOTIDENTICAL_FILES;
            }
            return IDENTICAL_FILES;
        }
        catch (IOException iOException) {
            System.err.println("Task Compare - Error: \n" + iOException.toString());
            return NOTIDENTICAL_FILES;
        }
    }

    private boolean compareFileSize(File file, File file2) {
        if (file.length() != file2.length()) {
            return NOTIDENTICAL_FILES;
        }
        return IDENTICAL_FILES;
    }

    private boolean filesExist(File file, File file2) {
        if (!file.exists()) {
            System.err.println("Task Compare - ERROR: File " + this.referenceDirectory + file.getName() + " doesn't exist!");
            return false;
        }
        if (!file2.exists()) {
            System.err.println("Task Compare - ERROR: File " + this.testDirectory + file2.getName() + " doesn't exist!");
            return false;
        }
        return true;
    }

    public void writeHeader(PrintWriter printWriter) {
        String string = DateFormat.getDateTimeInstance(2, 2).format(new Date());
        printWriter.println("<html><head><title>Test Results</title></head><body>\n");
        printWriter.println("<h2>Compare Results<br>");
        printWriter.println("<font size='1'>created " + string + "</font></h2>");
        printWriter.println("<table cellpadding='10' border='2'><thead><th align='center'>reference file</th><th align='center'>test file</th><th align='center'>identical?</th></thead>");
    }

    public void execute() throws BuildException {
        boolean bl = false;
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter("results.html"), true);
            this.writeHeader(printWriter);
            int n = 0;
            while (n < this.filenameList.length) {
                File file;
                File file2 = new File(this.referenceDirectory + this.filenameList[n]);
                if (this.filesExist(file2, file = new File(this.testDirectory + this.filenameList[n]))) {
                    bl = this.compareFileSize(file2, file);
                    if (bl) {
                        bl = this.compareBytes(file2, file);
                    }
                    if (!bl) {
                        System.out.println("Task Compare: \nFiles " + this.referenceDirectory + file2.getName() + " - " + this.testDirectory + file.getName() + " are *not* identical.");
                        printWriter.println("<tr><td><a href='" + this.referenceDirectory + file2.getName() + "'>" + file2.getName() + "</a> </td><td> <a href='" + this.testDirectory + file.getName() + "'>" + file.getName() + "</a>" + " </td><td><font color='red'>No</font></td></tr>");
                    } else {
                        printWriter.println("<tr><td><a href='" + this.referenceDirectory + file2.getName() + "'>" + file2.getName() + "</a> </td><td> <a href='" + this.testDirectory + file.getName() + "'>" + file.getName() + "</a>" + " </td><td>Yes</td></tr>");
                    }
                }
                ++n;
            }
            printWriter.println("</table></html>");
        }
        catch (IOException iOException) {
            System.err.println("ERROR: " + iOException);
        }
    }
}

