/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.AttributeList;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CompileXMLFiles
extends Task
implements EntityResolver,
DTDHandler,
DocumentHandler,
ErrorHandler {
    private String configFile;
    private String outFile;
    private String[] filenameList;
    private String filenames;
    private Vector files = new Vector();

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public void setOutFile(String string) {
        this.outFile = string;
    }

    public void execute() throws BuildException {
        Parser parser;
        boolean bl = false;
        if (!new File(this.configFile).exists()) {
            bl = true;
            System.err.println("Task CompileXMLFiles - ERROR: config file " + this.configFile + " is missing.");
        }
        if ((parser = CompileXMLFiles.createParser()) == null) {
            System.err.println("Task  CompileXMLFiles - ERROR: Unable to create SAX parser");
            bl = true;
        }
        parser.setDocumentHandler(this);
        try {
            parser.parse(CompileXMLFiles.fileInputSource(this.configFile));
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        return null;
    }

    public void notationDecl(String string, String string2, String string3) {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        Enumeration enumeration = this.files.elements();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("compileXMLFiles-tmp.xml"));
            bufferedWriter.write("<?xml version=\"1.0\"?>\n<!DOCTYPE documentation [\n<!ENTITY nbsp \" \">\n]>\n<documentation>");
            while (enumeration.hasMoreElements()) {
                String string;
                String string2 = (String)enumeration.nextElement();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.indexOf("<!DOCTYPE ") != -1 || string.indexOf("<?xml ") != -1) {
                        string = "";
                    }
                    bufferedWriter.write(string + "\n");
                }
                bufferedWriter.flush();
            }
            bufferedWriter.write("\n</documentation>");
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals("document") || string.equals("entry")) {
            String string2 = attributeList.getValue("source");
            this.files.addElement(string2);
        }
    }

    public void endElement(String string) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    static Parser createParser() {
        String string = System.getProperty("org.xml.sax.parser");
        if (string == null) {
            string = "org.apache.xerces.parsers.SAXParser";
        }
        System.err.println("using SAX parser " + string);
        try {
            return (Parser)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(string + " is not a SAX driver");
        }
        return null;
    }

    protected static InputSource fileInputSource(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = '/' + string2;
        }
        try {
            return new InputSource(new URL("file", null, string2).toString());
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }
}

