/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.fop.apps.CommandLineStarter;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.Starter;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.StreamTarget;

public class CommandLineOptions {
    private static final int NOT_SET = 0;
    private static final int FO_INPUT = 1;
    private static final int XSLT_INPUT = 2;
    private static final int PDF_OUTPUT = 1;
    private static final int AWT_OUTPUT = 2;
    private static final int MIF_OUTPUT = 3;
    private static final int PRINT_OUTPUT = 4;
    private static final int PCL_OUTPUT = 5;
    private static final int PS_OUTPUT = 6;
    private static final int TXT_OUTPUT = 7;
    private static final int BUFFER_FILE = 8;
    private static final int AREA_OUTPUT = 9;
    Boolean errorDump = new Boolean(false);
    Boolean dumpConfiguration = new Boolean(false);
    Boolean quiet = new Boolean(false);
    Boolean suppressLowLevelAreas = new Boolean(false);
    File userConfigFile = null;
    File fofile = null;
    File xsltfile = null;
    File xmlfile = null;
    File outfile = null;
    File bufferFile = null;
    int inputmode = 0;
    int outputmode = 0;
    int buffermode = 0;
    String language = null;
    private Hashtable rendererOptions;
    private Logger log;
    static /* synthetic */ Class class$org$apache$fop$apps$CommandLineOptions;

    public CommandLineOptions(String[] stringArray) throws FOPException, FileNotFoundException {
        Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
        PatternFormatter patternFormatter = new PatternFormatter("[%{priority}]: %{message}\n%{throwable}");
        StreamTarget streamTarget = null;
        boolean bl = true;
        if (bl) {
            streamTarget = new StreamTarget((OutputStream)System.out, (Formatter)patternFormatter);
        } else {
            try {
                File file = new File("fop.log");
                streamTarget = new FileTarget(file, false, (Formatter)patternFormatter);
            }
            catch (IOException iOException) {}
        }
        hierarchy.setDefaultLogTarget((LogTarget)streamTarget);
        this.log = hierarchy.getLoggerFor("fop");
        this.log.setPriority(Priority.INFO);
        boolean bl2 = true;
        this.rendererOptions = new Hashtable();
        try {
            bl2 = this.parseOptions(stringArray);
            if (bl2) {
                this.checkSettings();
                if (this.errorDump != null && this.errorDump.booleanValue()) {
                    this.debug();
                }
            }
        }
        catch (FOPException fOPException) {
            CommandLineOptions.printUsage();
            throw fOPException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            CommandLineOptions.printUsage();
            throw fileNotFoundException;
        }
    }

    private void checkSettings() throws FOPException, FileNotFoundException {
        if (this.inputmode == 0) {
            throw new FOPException("No input file specified");
        }
        if (this.outputmode == 0) {
            throw new FOPException("No output file specified");
        }
        if (this.inputmode == 2) {
            if (this.xmlfile == null) {
                throw new FOPException("XML file must be specified for the tranform mode");
            }
            if (this.xsltfile == null) {
                throw new FOPException("XSLT file must be specified for the tranform mode");
            }
            if (this.fofile != null) {
                this.log.warn("Can't use fo file with transform mode! Ignoring.\nYour input is \n xmlfile: " + this.xmlfile.getAbsolutePath() + "\nxsltfile: " + this.xsltfile.getAbsolutePath() + "\n  fofile: " + this.fofile.getAbsolutePath());
            }
            if (!this.xmlfile.exists()) {
                throw new FileNotFoundException("xml file " + this.xmlfile.getAbsolutePath() + " not found ");
            }
            if (!this.xsltfile.exists()) {
                throw new FileNotFoundException("xsl file " + this.xsltfile.getAbsolutePath() + " not found ");
            }
        } else if (this.inputmode == 1) {
            if (this.xmlfile != null || this.xsltfile != null) {
                this.log.warn("fo input mode, but xmlfile or xslt file are set:");
                this.log.error("xml file: " + this.xmlfile.toString());
                this.log.error("xslt file: " + this.xsltfile.toString());
            }
            if (!this.fofile.exists()) {
                throw new FileNotFoundException("fo file " + this.fofile.getAbsolutePath() + " not found ");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void debug() {
        this.log.debug("Input mode: ");
        switch (this.inputmode) {
            case 0: {
                this.log.debug("not set");
                break;
            }
            case 1: {
                this.log.debug("FO ");
                this.log.debug("fo input file: " + this.fofile.toString());
                break;
            }
            case 2: {
                this.log.debug("xslt transformation");
                this.log.debug("xml input file: " + this.xmlfile.toString());
                this.log.debug("xslt stylesheet: " + this.xsltfile.toString());
                break;
            }
            default: {
                this.log.debug("unknown input type");
            }
        }
        this.log.debug("Output mode: ");
        switch (this.outputmode) {
            case 0: {
                this.log.debug("not set");
                break;
            }
            case 1: {
                this.log.debug("pdf");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            case 2: {
                this.log.debug("awt on screen");
                if (this.outfile == null) break;
                this.log.error("awt mode, but outfile is set:");
                this.log.debug("out file: " + this.outfile.toString());
                break;
            }
            case 3: {
                this.log.debug("mif");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            case 4: {
                this.log.debug("print directly");
                if (this.outfile == null) break;
                this.log.error("print mode, but outfile is set:");
                this.log.error("out file: " + this.outfile.toString());
                break;
            }
            case 5: {
                this.log.debug("pcl");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            case 6: {
                this.log.debug("PostScript");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            case 7: {
                this.log.debug("txt");
                this.log.debug("output file: " + this.outfile.toString());
                break;
            }
            default: {
                this.log.debug("unknown input type");
            }
        }
        this.log.debug("OPTIONS");
        if (this.userConfigFile != null) {
            this.log.debug("user configuration file: " + this.userConfigFile.toString());
        } else {
            this.log.debug("no user configuration file is used [default]");
        }
        if (this.errorDump != null) {
            this.log.debug("debug mode on");
        } else {
            this.log.debug("debug mode off [default]");
        }
        if (this.dumpConfiguration != null) {
            this.log.debug("dump configuration");
        } else {
            this.log.debug("don't dump configuration [default]");
        }
        if (this.quiet != null) {
            this.log.debug("quiet mode on");
        } else {
            this.log.debug("quiet mode off [default]");
        }
    }

    public Boolean dumpConfiguration() {
        return this.dumpConfiguration;
    }

    public File getBufferFile() {
        return this.bufferFile;
    }

    public File getFOFile() {
        return this.fofile;
    }

    public File getInputFile() {
        switch (this.inputmode) {
            case 1: {
                return this.fofile;
            }
            case 2: {
                return this.xmlfile;
            }
        }
        return this.fofile;
    }

    public InputHandler getInputHandler() {
        switch (this.inputmode) {
            case 1: {
                return new FOInputHandler(this.fofile);
            }
            case 2: {
                return new XSLTInputHandler(this.xmlfile, this.xsltfile);
            }
        }
        return new FOInputHandler(this.fofile);
    }

    public int getInputMode() {
        return this.inputmode;
    }

    public String getLanguage() {
        return this.language;
    }

    public File getOutputFile() {
        return this.outfile;
    }

    public int getOutputMode() {
        return this.outputmode;
    }

    public int getRenderer() throws FOPException {
        switch (this.outputmode) {
            case 0: {
                throw new FOPException("Renderer has not been set!");
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 9: {
                this.rendererOptions.put("fineDetail", this.isCoarseAreaXml());
                return 4;
            }
        }
        throw new FOPException("Invalid Renderer setting!");
    }

    public Hashtable getRendererOptions() {
        return this.rendererOptions;
    }

    public Starter getStarter() throws FOPException {
        Starter starter = null;
        switch (this.outputmode) {
            case 2: {
                try {
                    starter = (Starter)Class.forName("org.apache.fop.apps.AWTStarter").getConstructor(class$org$apache$fop$apps$CommandLineOptions != null ? class$org$apache$fop$apps$CommandLineOptions : (class$org$apache$fop$apps$CommandLineOptions = CommandLineOptions.class$("org.apache.fop.apps.CommandLineOptions"))).newInstance(this);
                    break;
                }
                catch (Exception exception) {
                    if (exception instanceof FOPException) {
                        throw (FOPException)exception;
                    }
                    throw new FOPException("AWTStarter could not be loaded.", exception);
                }
            }
            case 4: {
                try {
                    starter = (Starter)Class.forName("org.apache.fop.apps.PrintStarter").getConstructor(class$org$apache$fop$apps$CommandLineOptions != null ? class$org$apache$fop$apps$CommandLineOptions : (class$org$apache$fop$apps$CommandLineOptions = CommandLineOptions.class$("org.apache.fop.apps.CommandLineOptions"))).newInstance(this);
                    break;
                }
                catch (Exception exception) {
                    if (exception instanceof FOPException) {
                        throw (FOPException)exception;
                    }
                    throw new FOPException("PrintStarter could not be loaded.", exception);
                }
            }
            default: {
                starter = new CommandLineStarter(this);
            }
        }
        starter.setLogger(this.log);
        return starter;
    }

    public File getUserConfigFile() {
        return this.userConfigFile;
    }

    public File getXMLFile() {
        return this.xmlfile;
    }

    public File getXSLFile() {
        return this.xsltfile;
    }

    public Boolean isCoarseAreaXml() {
        return this.suppressLowLevelAreas;
    }

    public Boolean isDebugMode() {
        return this.errorDump;
    }

    public Boolean isQuiet() {
        return this.quiet;
    }

    public static void main(String[] stringArray) {
        try {
            CommandLineOptions commandLineOptions = new CommandLineOptions(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseOptions(String[] stringArray) throws FOPException {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d") || stringArray[n].equals("--full-error-dump")) {
                this.errorDump = new Boolean(true);
                this.log.setPriority(Priority.DEBUG);
            } else if (stringArray[n].equals("-x") || stringArray[n].equals("--dump-config")) {
                this.dumpConfiguration = new Boolean(true);
            } else if (stringArray[n].equals("-q") || stringArray[n].equals("--quiet")) {
                this.quiet = new Boolean(true);
                this.log.setPriority(Priority.ERROR);
            } else if (stringArray[n].equals("-c")) {
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("if you use '-c', you must specify the name of the configuration file");
                }
                this.userConfigFile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].equals("-l")) {
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("if you use '-l', you must specify a language");
                }
                this.language = stringArray[n + 1];
                ++n;
            } else if (stringArray[n].equals("-s")) {
                this.suppressLowLevelAreas = new Boolean(true);
            } else if (stringArray[n].equals("-fo")) {
                this.inputmode = 1;
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the fo file for the '-fo' option");
                }
                this.fofile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].equals("-xsl")) {
                this.inputmode = 2;
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the stylesheet file for the '-xsl' option");
                }
                this.xsltfile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].equals("-xml")) {
                this.inputmode = 2;
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the input file for the '-xml' option");
                }
                this.xmlfile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].equals("-awt")) {
                this.setOutputMode(2);
            } else if (stringArray[n].equals("-pdf")) {
                this.setOutputMode(1);
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the pdf output file");
                }
                this.outfile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].equals("-mif")) {
                this.setOutputMode(3);
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the mif output file");
                }
                this.outfile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].equals("-print")) {
                this.setOutputMode(4);
                if (n + 1 < stringArray.length && stringArray[n + 1].equals("help")) {
                    this.printUsagePrintOutput();
                    return false;
                }
            } else if (stringArray[n].equals("-pcl")) {
                this.setOutputMode(5);
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the pdf output file");
                }
                this.outfile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].equals("-ps")) {
                this.setOutputMode(6);
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the PostScript output file");
                }
                this.outfile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].equals("-txt")) {
                this.setOutputMode(7);
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the text output file");
                }
                this.outfile = new File(stringArray[n + 1]);
                ++n;
            } else if (stringArray[n].charAt(0) != '-') {
                if (this.inputmode == 0) {
                    this.inputmode = 1;
                    this.fofile = new File(stringArray[n]);
                } else {
                    if (this.outputmode != 0) throw new FOPException("Don't know what to do with " + stringArray[n]);
                    this.outputmode = 1;
                    this.outfile = new File(stringArray[n]);
                }
            } else if (stringArray[n].equals("-buf")) {
                if (this.buffermode == 0) {
                    this.buffermode = 8;
                } else {
                    this.log.error("you can only set one buffer method");
                    CommandLineOptions.printUsage();
                }
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    this.log.error("you must specify the buffer output file");
                    CommandLineOptions.printUsage();
                } else {
                    this.bufferFile = new File(stringArray[n + 1]);
                    ++n;
                }
            } else if (stringArray[n].equals("-at")) {
                this.setOutputMode(9);
                if (n + 1 == stringArray.length || stringArray[n + 1].charAt(0) == '-') {
                    throw new FOPException("you must specify the area-tree output file");
                }
                this.outfile = new File(stringArray[n + 1]);
                ++n;
            } else {
                CommandLineOptions.printUsage();
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void printUsage() {
        System.err.println("\nUSAGE\nFop [options] [-fo|-xml] infile [-xsl file] [-awt|-pdf|-mif|-pcl|-ps|-txt|-at|-print] <outfile>\n [OPTIONS]  \n  -d          debug mode   \n  -x          dump configuration settings  \n  -q          quiet mode  \n  -c cfg.xml  use additional configuration file cfg.xml\n  -l lang     the language to use for user information \n  -s          for area tree XML, down to block areas only\n\n [INPUT]  \n  infile            xsl:fo input file (the same as the next) \n  -fo  infile       xsl:fo input file  \n  -xml infile       xml input file, must be used together with -xsl \n  -xsl stylesheet   xslt stylesheet \n \n [OUTPUT] \n  outfile           input will be rendered as pdf file into outfile \n  -pdf outfile      input will be rendered as pdf file (outfile req'd) \n  -awt              input will be displayed on screen \n  -mif outfile      input will be rendered as mif file (outfile req'd)\n  -pcl outfile      input will be rendered as pcl file (outfile req'd) \n  -ps outfile       input will be rendered as PostScript file (outfile req'd) \n  -txt outfile      input will be rendered as text file (outfile req'd) \n  -at outfile       representation of area tree as XML (outfile req'd) \n  -print            input file will be rendered and sent to the printer \n                    see options with \"-print help\" \n\n [Examples]\n  Fop foo.fo foo.pdf \n  Fop -fo foo.fo -pdf foo.pdf (does the same as the previous line)\n  Fop -xsl foo.xsl -xml foo.xml -pdf foo.pdf\n  Fop foo.fo -mif foo.mif\n  Fop foo.fo -print or Fop -print foo.fo \n  Fop foo.fo -awt \n");
    }

    public void printUsagePrintOutput() {
        System.err.println("USAGE: -print [-Dstart=i] [-Dend=i] [-Dcopies=i] [-Deven=true|false]  org.apache.fop.apps.Fop (..) -print \nExample:\njava -Dstart=1 -Dend=2 org.apache.Fop.apps.Fop infile.fo -print ");
    }

    private void setOutputMode(int n) throws FOPException {
        if (this.outputmode != 0) {
            throw new FOPException("you can only set one output method");
        }
        this.outputmode = n;
    }
}

