/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.FileOutputStream;
import org.apache.fop.apps.CommandLineOptions;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Starter;
import org.apache.fop.apps.Version;
import org.apache.fop.configuration.Configuration;
import org.xml.sax.XMLReader;

public class CommandLineStarter
extends Starter {
    CommandLineOptions commandLineOptions;
    boolean errorDump;

    public CommandLineStarter(CommandLineOptions commandLineOptions) throws FOPException {
        this.commandLineOptions = commandLineOptions;
        this.options.setCommandLineOptions(commandLineOptions);
        this.errorDump = Configuration.getBooleanValue("debugMode");
        super.setInputHandler(commandLineOptions.getInputHandler());
    }

    public void run() throws FOPException {
        String string = Version.getVersion();
        this.log.info(string);
        XMLReader xMLReader = this.inputHandler.getParser();
        this.setParserFeatures(xMLReader);
        Driver driver = new Driver();
        driver.setLogger(this.log);
        driver.setBufferFile(this.commandLineOptions.getBufferFile());
        if (this.errorDump) {
            driver.setErrorDump(true);
        }
        try {
            driver.setRenderer(this.commandLineOptions.getRenderer());
            driver.setOutputStream(new FileOutputStream(this.commandLineOptions.getOutputFile()));
            driver.getRenderer().setOptions(this.commandLineOptions.getRendererOptions());
            driver.render(xMLReader, this.inputHandler.getInputSource());
            System.exit(0);
        }
        catch (Exception exception) {
            if (exception instanceof FOPException) {
                throw (FOPException)exception;
            }
            throw new FOPException(exception);
        }
    }
}

