/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.extensions.ExtensionObj;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.Page;
import org.apache.fop.render.Renderer;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public class StreamRenderer {
    private static final boolean MEM_PROFILE_WITH_GC = false;
    private Runtime runtime = Runtime.getRuntime();
    int pageCount = 0;
    private long initialMemory;
    private long startTime;
    private OutputStream outputStream;
    private Renderer renderer;
    private FontInfo fontInfo = new FontInfo();
    private Vector renderQueue = new Vector();
    private IDReferences idReferences = new IDReferences();
    private Vector extensions = new Vector();
    private Logger log;

    public StreamRenderer(OutputStream outputStream, Renderer renderer) {
        this.outputStream = outputStream;
        this.renderer = renderer;
    }

    public void addExtension(ExtensionObj extensionObj) {
        this.extensions.addElement(extensionObj);
    }

    private synchronized void addToRenderQueue(Page page) throws FOPException, IOException {
        RenderQueueEntry renderQueueEntry = new RenderQueueEntry(page);
        this.renderQueue.addElement(renderQueueEntry);
        this.processQueue(false);
    }

    public IDReferences getIDReferences() {
        return this.idReferences;
    }

    public Page getNextPage(Page page, boolean bl, boolean bl2) {
        Page page2 = null;
        int n = 0;
        n = bl2 ? this.renderQueue.size() : this.renderQueue.indexOf(page);
        if (n + 1 < this.renderQueue.size()) {
            page2 = (Page)this.renderQueue.elementAt(n + 1);
            if (bl && !page2.getPageSequence().equals(page.getPageSequence())) {
                page2 = null;
            }
        }
        return page2;
    }

    public Page getPreviousPage(Page page, boolean bl, boolean bl2) {
        Page page2 = null;
        int n = 0;
        n = bl2 ? this.renderQueue.size() : this.renderQueue.indexOf(page);
        if (n - 1 >= 0) {
            page2 = (Page)this.renderQueue.elementAt(n - 1);
            PageSequence pageSequence = page.getPageSequence();
            PageSequence pageSequence2 = page2.getPageSequence();
            if (bl && !pageSequence2.equals(pageSequence)) {
                page2 = null;
            }
        }
        return page2;
    }

    private synchronized void processQueue(boolean bl) throws FOPException, IOException {
        while (this.renderQueue.size() > 0) {
            RenderQueueEntry renderQueueEntry = (RenderQueueEntry)this.renderQueue.elementAt(0);
            if (!bl && !renderQueueEntry.isResolved()) break;
            this.renderer.render(renderQueueEntry.getPage(), this.outputStream);
            this.renderQueue.removeElementAt(0);
        }
    }

    public synchronized void queuePage(Page page) throws FOPException, IOException {
        if (this.renderQueue.size() == 0 && this.idReferences.isEveryIdValid()) {
            this.renderer.render(page, this.outputStream);
        } else {
            this.addToRenderQueue(page);
        }
        ++this.pageCount;
    }

    public void render(PageSequence pageSequence) throws SAXException {
        AreaTree areaTree = new AreaTree(this);
        areaTree.setFontInfo(this.fontInfo);
        Enumeration enumeration = this.extensions.elements();
        while (enumeration.hasMoreElements()) {
            ExtensionObj extensionObj = (ExtensionObj)enumeration.nextElement();
            try {
                extensionObj.format(areaTree);
            }
            catch (FOPException fOPException) {
                throw new SAXException(fOPException);
            }
        }
        try {
            pageSequence.format(areaTree);
        }
        catch (FOPException fOPException) {
            throw new SAXException(fOPException);
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void startRenderer() throws SAXException {
        this.pageCount = 0;
        this.initialMemory = this.runtime.totalMemory() - this.runtime.freeMemory();
        this.startTime = System.currentTimeMillis();
        try {
            this.renderer.setupFontInfo(this.fontInfo);
            this.renderer.startRenderer(this.outputStream);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void stopRenderer() throws SAXException {
        try {
            this.processQueue(true);
            this.renderer.stopRenderer(this.outputStream);
        }
        catch (FOPException fOPException) {
            throw new SAXException(fOPException);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        long l = this.runtime.totalMemory() - this.runtime.freeMemory();
        long l2 = (l - this.initialMemory) / 1024L;
        this.log.debug("Initial heap size: " + this.initialMemory / 1024L + "Kb");
        this.log.debug("Current heap size: " + l / 1024L + "Kb");
        this.log.debug("Total memory used: " + l2 + "Kb");
        this.log.debug("  Memory use is indicative; no GC was performed");
        this.log.debug("  These figures should not be used comparatively");
        long l3 = System.currentTimeMillis() - this.startTime;
        this.log.debug("Total time used: " + l3 + "ms");
        this.log.debug("Pages rendererd: " + this.pageCount);
        this.log.debug("Avg render time: " + l3 / (long)this.pageCount + "ms/page");
    }

    class RenderQueueEntry {
        private Page page;
        private Vector unresolvedIdReferences = new Vector();

        public RenderQueueEntry(Page page) {
            this.page = page;
            Enumeration enumeration = StreamRenderer.this.idReferences.getInvalidElements();
            while (enumeration.hasMoreElements()) {
                this.unresolvedIdReferences.addElement(enumeration.nextElement());
            }
        }

        public Page getPage() {
            return this.page;
        }

        public boolean isResolved() {
            if (this.unresolvedIdReferences.size() == 0 || StreamRenderer.this.idReferences.isEveryIdValid()) {
                return true;
            }
            Enumeration enumeration = this.unresolvedIdReferences.elements();
            while (enumeration.hasMoreElements()) {
                if (StreamRenderer.this.idReferences.doesIDExist((String)enumeration.nextElement())) continue;
                return false;
            }
            this.unresolvedIdReferences.removeAllElements();
            return true;
        }
    }
}

