/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Page;

public class Footnote
extends FObj {
    public Footnote(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:footnote";
    }

    protected static void decreaseMaxHeight(Area area, int n) {
        area.setMaxHeight(area.getMaxHeight() - n);
        Vector vector = area.getChildren();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Area)) continue;
            Area area2 = (Area)e;
            Footnote.decreaseMaxHeight(area2, n);
        }
    }

    public Status layout(Area area) throws FOPException {
        FONode fONode = null;
        FONode fONode2 = null;
        if (this.marker == -1000) {
            this.marker = 0;
        }
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            Object object;
            FONode fONode3 = (FONode)this.children.elementAt(n2);
            if (fONode3 instanceof Inline) {
                fONode = fONode3;
                object = fONode3.layout(area);
                if (((Status)object).isIncomplete()) {
                    return object;
                }
            } else if (fONode != null && fONode3 instanceof FootnoteBody) {
                fONode2 = fONode3;
                if (area instanceof BlockArea) {
                    ((BlockArea)area).addFootnote((FootnoteBody)fONode2);
                } else {
                    object = area.getPage();
                    Footnote.layoutFootnote((Page)object, (FootnoteBody)fONode2, area);
                }
            }
            ++n2;
        }
        if (fONode2 == null) {
            this.log.error("no footnote-body in footnote");
        }
        return new Status(1);
    }

    public static boolean layoutFootnote(Page page, FootnoteBody footnoteBody, Area area) {
        try {
            BodyAreaContainer bodyAreaContainer = page.getBody();
            AreaContainer areaContainer = bodyAreaContainer.getFootnoteReferenceArea();
            areaContainer.setIDReferences(bodyAreaContainer.getIDReferences());
            int n = areaContainer.getCurrentYPosition() - areaContainer.getHeight();
            int n2 = areaContainer.getHeight();
            if (area != null) {
                areaContainer.setMaxHeight(area.getMaxHeight() - area.getHeight() + areaContainer.getHeight());
            } else {
                areaContainer.setMaxHeight(bodyAreaContainer.getMaxHeight() + areaContainer.getHeight());
            }
            Status status = footnoteBody.layout(areaContainer);
            if (status.isIncomplete()) {
                return false;
            }
            if (area != null) {
                area.setMaxHeight(area.getMaxHeight() - areaContainer.getHeight() + n2);
            }
            if (bodyAreaContainer.getFootnoteState() == 0) {
                AreaContainer areaContainer2 = bodyAreaContainer.getMainReferenceArea();
                Footnote.decreaseMaxHeight(areaContainer2, areaContainer.getHeight() - n2);
                areaContainer.setYPosition(n + areaContainer.getHeight());
            }
        }
        catch (FOPException fOPException) {
            return false;
        }
        return true;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Footnote(fObj, propertyList);
        }
    }
}

