/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.RelativePositionProps;

public class Inline
extends FObjMixed {
    protected boolean underlined = false;
    protected boolean overlined = false;
    protected boolean lineThrough = false;

    public Inline(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:inline";
        if (fObj.getName().equals("fo:flow")) {
            throw new FOPException("inline formatting objects cannot be directly under flow");
        }
        AccessibilityProps accessibilityProps = this.propMgr.getAccessibilityProps();
        AuralProps auralProps = this.propMgr.getAuralProps();
        BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
        BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
        MarginInlineProps marginInlineProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
        int n = this.properties.get("text-decoration").getEnum();
        if (n == 82) {
            this.underlined = true;
        }
        if (n == 57) {
            this.overlined = true;
        }
        if (n == 40) {
            this.lineThrough = true;
        }
    }

    protected void addCharacters(char[] cArray, int n, int n2) {
        FOText fOText = new FOText(cArray, n, n2, this);
        fOText.setLogger(this.log);
        fOText.setUnderlined(this.underlined);
        fOText.setOverlined(this.overlined);
        fOText.setLineThrough(this.lineThrough);
        this.children.addElement(fOText);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new Inline(fObj, propertyList);
        }
    }
}

