/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.RelativePositionProps;

public class ListBlock
extends FObj {
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int spaceBetweenListRows = 0;
    ColorType backgroundColor;

    public ListBlock(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:list-block";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Object object2;
        Object object3;
        if (this.marker == -1000) {
            object3 = this.propMgr.getAccessibilityProps();
            AuralProps auralProps = this.propMgr.getAuralProps();
            BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
            object2 = this.propMgr.getBackgroundProps();
            object = this.propMgr.getMarginProps();
            RelativePositionProps relativePositionProps = this.propMgr.getRelativePositionProps();
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.spaceBetweenListRows = 0;
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.marker = 0;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.spaceBefore != 0) {
                area.addDisplaySpace(this.spaceBefore);
            }
            if (this.isInTableCell) {
                this.startIndent += this.forcedStartOffset;
                this.endIndent += area.getAllocationWidth() - this.forcedWidth - this.forcedStartOffset;
            }
            String string = this.properties.get("id").getString();
            area.getIDReferences().initializeID(string, area);
        }
        object3 = new BlockArea(this.propMgr.getFontState(area.getFontInfo()), area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, this.align, this.alignLast, this.lineHeight);
        ((Area)object3).setGeneratedBy(this);
        ++this.areasGenerated;
        if (this.areasGenerated == 1) {
            ((Area)object3).isFirst(true);
        }
        ((Area)object3).addLineagePair(this, this.areasGenerated);
        if (this.hasMarkers()) {
            ((Area)object3).addMarkers(this.getMarkers());
        }
        ((Area)object3).setPage(area.getPage());
        ((Area)object3).setBackgroundColor(this.backgroundColor);
        ((BlockArea)object3).start();
        ((Area)object3).setAbsoluteHeight(area.getAbsoluteHeight());
        ((Area)object3).setIDReferences(area.getIDReferences());
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            if (!(this.children.elementAt(n2) instanceof ListItem)) {
                this.log.error("children of list-blocks must be list-items");
                return new Status(1);
            }
            object2 = (ListItem)this.children.elementAt(n2);
            object = ((ListItem)object2).layout((Area)object3);
            if (((Status)object).isIncomplete()) {
                if (((Status)object).getCode() == 2 && n2 > 0) {
                    object = new Status(3);
                }
                this.marker = n2;
                ((BlockArea)object3).end();
                area.addChild((Box)object3);
                area.increaseHeight(((Area)object3).getHeight());
                area.setAbsoluteHeight(((Area)object3).getAbsoluteHeight());
                return object;
            }
            ++n2;
        }
        ((BlockArea)object3).end();
        area.addChild((Box)object3);
        area.increaseHeight(((Area)object3).getHeight());
        area.setAbsoluteHeight(((Area)object3).getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        ((Area)object3).isLast(true);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new ListBlock(fObj, propertyList);
        }
    }
}

