/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.Page;

public class RetrieveMarker
extends FObjMixed {
    private String retrieveClassName;
    private int retrievePosition;
    private int retrieveBoundary;

    public RetrieveMarker(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:retrieve-marker";
        this.retrieveClassName = this.properties.get("retrieve-class-name").getString();
        this.retrievePosition = this.properties.get("retrieve-position").getEnum();
        this.retrieveBoundary = this.properties.get("retrieve-boundary").getEnum();
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        Page page = area.getPage();
        Marker marker = this.searchPage(page, true);
        if (marker == null && this.retrieveBoundary != 58) {
            object = page;
            boolean bl = true;
            while (marker == null) {
                Page page2 = this.locatePreviousPage((Page)object, this.retrieveBoundary, bl);
                bl = false;
                marker = this.searchPage(page2, false);
                object = page2;
            }
        }
        object = new Status(2);
        if (marker != null) {
            marker.resetMarker();
            object = marker.layoutMarker(area);
        }
        return object;
    }

    private Page locatePreviousPage(Page page, int n, boolean bl) {
        boolean bl2 = true;
        if (n == 18) {
            bl2 = false;
        }
        return page.getAreaTree().getPreviousPage(page, bl2, bl);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    private Marker searchPage(Page page, boolean bl) throws FOPException {
        Marker marker;
        int n;
        Vector vector = page.getMarkers();
        if (vector.isEmpty()) {
            return null;
        }
        if (!bl) {
            n = vector.size();
            while (n > 0) {
                marker = (Marker)vector.elementAt(n - 1);
                if (marker.getMarkerClassName().equals(this.retrieveClassName)) {
                    return marker;
                }
                --n;
            }
        }
        if (this.retrievePosition == 28) {
            n = 0;
            while (n < vector.size()) {
                marker = (Marker)vector.elementAt(n);
                if (marker.getMarkerClassName().equals(this.retrieveClassName)) {
                    return marker;
                }
                ++n;
            }
        } else if (this.retrievePosition == 32) {
            n = 0;
            while (n < vector.size()) {
                marker = (Marker)vector.elementAt(n);
                if (marker.getMarkerClassName().equals(this.retrieveClassName) && marker.getRegistryArea().isFirst()) {
                    return marker;
                }
                ++n;
            }
        } else if (this.retrievePosition == 42) {
            n = vector.size();
            while (n > 0) {
                marker = (Marker)vector.elementAt(n - 1);
                if (marker.getMarkerClassName().equals(this.retrieveClassName) && marker.getRegistryArea().isFirst()) {
                    return marker;
                }
                --n;
            }
        } else if (this.retrievePosition == 39) {
            n = vector.size();
            while (n > 0) {
                marker = (Marker)vector.elementAt(n - 1);
                if (marker.getMarkerClassName().equals(this.retrieveClassName) && marker.getRegistryArea().isLast()) {
                    return marker;
                }
                --n;
            }
        } else {
            throw new FOPException("Illegal 'retrieve-position' value");
        }
        return null;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new RetrieveMarker(fObj, propertyList);
        }
    }
}

