/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Flow;
import org.apache.fop.fo.flow.StaticContent;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageNumberGenerator;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.PageMaster;

public class PageSequence
extends FObj {
    private static final int EXPLICIT = 0;
    private static final int AUTO = 1;
    private static final int AUTO_EVEN = 2;
    private static final int AUTO_ODD = 3;
    private Root root;
    private LayoutMasterSet layoutMasterSet;
    private Hashtable _flowMap;
    private String masterName;
    private boolean isFlowSet = false;
    private Page currentPage;
    private String ipnValue;
    private int currentPageNumber = 0;
    private PageNumberGenerator pageNumberGenerator;
    private int forcePageCount = 0;
    private int pageCount = 0;
    private boolean isForcing = false;
    private int pageNumberType;
    private boolean thisIsFirstPage;
    private SubSequenceSpecifier currentSubsequence;
    private int currentSubsequenceNumber = -1;
    private String currentPageMasterName;

    protected PageSequence(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:page-sequence";
        if (!fObj.getName().equals("fo:root")) {
            throw new FOPException("page-sequence must be child of root, not " + fObj.getName());
        }
        this.root = (Root)fObj;
        this.layoutMasterSet = this.root.getLayoutMasterSet();
        this.layoutMasterSet.checkRegionNames();
        this._flowMap = new Hashtable();
        this.thisIsFirstPage = true;
        this.ipnValue = this.properties.get("initial-page-number").getString();
        if (this.ipnValue.equals("auto")) {
            this.pageNumberType = 1;
        } else if (this.ipnValue.equals("auto-even")) {
            this.pageNumberType = 2;
        } else if (this.ipnValue.equals("auto-odd")) {
            this.pageNumberType = 3;
        } else {
            this.pageNumberType = 0;
            try {
                int n = new Integer(this.ipnValue);
                this.currentPageNumber = n > 0 ? n - 1 : 0;
            }
            catch (NumberFormatException numberFormatException) {
                throw new FOPException("\"" + this.ipnValue + "\" is not a valid value for initial-page-number");
            }
        }
        this.masterName = this.properties.get("master-name").getString();
        this.pageNumberGenerator = new PageNumberGenerator(this.properties.get("format").getString(), this.properties.get("grouping-separator").getCharacter(), this.properties.get("grouping-size").getNumber().intValue(), this.properties.get("letter-value").getEnum());
        this.forcePageCount = this.properties.get("force-page-count").getEnum();
    }

    public void addFlow(Flow flow) throws FOPException {
        if (this._flowMap.containsKey(flow.getFlowName())) {
            throw new FOPException("flow-names must be unique within an fo:page-sequence");
        }
        if (!this.layoutMasterSet.regionNameExists(flow.getFlowName())) {
            this.log.error("region-name '" + flow.getFlowName() + "' doesn't exist in the layout-master-set.");
        }
        this._flowMap.put(flow.getFlowName(), flow);
        this.setIsFlowSet(true);
    }

    private boolean flowsAreIncomplete() {
        boolean bl = false;
        Enumeration enumeration = this._flowMap.elements();
        while (enumeration.hasMoreElements()) {
            Flow flow = (Flow)enumeration.nextElement();
            if (flow instanceof StaticContent) continue;
            Status status = flow.getStatus();
            bl |= status.isIncomplete();
        }
        return bl;
    }

    private void forcePage(AreaTree areaTree, int n) {
        block21: {
            Object object;
            boolean bl = false;
            if (this.forcePageCount == 7) {
                object = this.root.getSucceedingPageSequence(this);
                if (object != null && !((PageSequence)object).getIpnValue().equals("auto")) {
                    if (((PageSequence)object).getIpnValue().equals("auto-odd")) {
                        if (n % 2 == 0) {
                            bl = true;
                        }
                    } else if (((PageSequence)object).getIpnValue().equals("auto-even")) {
                        if (n % 2 != 0) {
                            bl = true;
                        }
                    } else {
                        int n2 = ((PageSequence)object).getCurrentPageNumber();
                        if (n2 % 2 == 0 && n % 2 == 0) {
                            bl = true;
                        } else if (n2 % 2 != 0 && n % 2 != 0) {
                            bl = true;
                        }
                    }
                }
            } else if (this.forcePageCount == 25 && this.pageCount % 2 != 0) {
                bl = true;
            } else if (this.forcePageCount == 54 && this.pageCount % 2 == 0) {
                bl = true;
            } else if (this.forcePageCount == 23 && n % 2 == 0) {
                bl = true;
            } else if (this.forcePageCount == 24 && n % 2 != 0) {
                bl = true;
            }
            if (!bl) break block21;
            try {
                this.isForcing = true;
                ++this.currentPageNumber;
                n = this.currentPageNumber;
                this.currentPage = this.makePage(areaTree, n, false, true);
                object = this.pageNumberGenerator.makeFormattedPageNumber(this.currentPageNumber);
                this.currentPage.setFormattedNumber((String)object);
                this.currentPage.setPageSequence(this);
                this.formatStaticContent(areaTree);
                this.log.debug("[forced-" + n + "]");
                areaTree.addPage(this.currentPage);
                this.root.setRunningPageNumberCounter(this.currentPageNumber);
                this.isForcing = false;
            }
            catch (FOPException fOPException) {
                this.log.debug("'force-page-count' failure");
            }
        }
    }

    public void format(AreaTree areaTree) throws FOPException {
        Status status = new Status(1);
        this.layoutMasterSet.resetPageMasters();
        int n = 0;
        do {
            n = this.root.getRunningPageNumberCounter();
            boolean bl = false;
            if (this.thisIsFirstPage) {
                bl = this.thisIsFirstPage;
                if (this.pageNumberType == 1) {
                    this.currentPageNumber = this.root.getRunningPageNumberCounter();
                } else if (this.pageNumberType == 3) {
                    this.currentPageNumber = this.root.getRunningPageNumberCounter();
                    if (this.currentPageNumber % 2 == 1) {
                        ++this.currentPageNumber;
                    }
                } else if (this.pageNumberType == 2) {
                    this.currentPageNumber = this.root.getRunningPageNumberCounter();
                    if (this.currentPageNumber % 2 == 0) {
                        ++this.currentPageNumber;
                    }
                }
                this.thisIsFirstPage = false;
            }
            ++this.currentPageNumber;
            boolean bl2 = false;
            bl2 = status.getCode() == 5 && this.currentPageNumber % 2 == 1 ? true : status.getCode() == 6 && this.currentPageNumber % 2 == 0;
            this.currentPage = this.makePage(areaTree, n, bl, bl2);
            this.currentPage.setNumber(this.currentPageNumber);
            String string = this.pageNumberGenerator.makeFormattedPageNumber(this.currentPageNumber);
            this.currentPage.setFormattedNumber(string);
            this.root.setRunningPageNumberCounter(this.currentPageNumber);
            this.log.info("[" + this.currentPageNumber + "]");
            if (!(status.getCode() == 5 && this.currentPageNumber % 2 == 1 || status.getCode() == 6 && this.currentPageNumber % 2 == 0)) {
                BodyAreaContainer bodyAreaContainer = this.currentPage.getBody();
                bodyAreaContainer.setIDReferences(areaTree.getIDReferences());
                Flow flow = this.getCurrentFlow("body");
                if (flow == null) {
                    this.log.error("No flow found for region-body in page-master '" + this.currentPageMasterName + "'");
                    break;
                }
                status = flow.layout(bodyAreaContainer);
            }
            this.currentPage.setPageSequence(this);
            this.formatStaticContent(areaTree);
            areaTree.addPage(this.currentPage);
            ++this.pageCount;
        } while (this.flowsAreIncomplete());
        this.forcePage(areaTree, n);
        this.currentPage = null;
    }

    private void formatStaticContent(AreaTree areaTree) throws FOPException {
        AreaContainer areaContainer;
        Flow flow;
        SimplePageMaster simplePageMaster = this.getCurrentSimplePageMaster();
        if (simplePageMaster.getRegion("before") != null && this.currentPage.getBefore() != null && (flow = (Flow)this._flowMap.get(simplePageMaster.getRegion("before").getRegionName())) != null) {
            areaContainer = this.currentPage.getBefore();
            areaContainer.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(flow, simplePageMaster.getRegion("before"), areaContainer);
        }
        if (simplePageMaster.getRegion("after") != null && this.currentPage.getAfter() != null && (flow = (Flow)this._flowMap.get(simplePageMaster.getRegion("after").getRegionName())) != null) {
            areaContainer = this.currentPage.getAfter();
            areaContainer.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(flow, simplePageMaster.getRegion("after"), areaContainer);
        }
        if (simplePageMaster.getRegion("start") != null && this.currentPage.getStart() != null && (flow = (Flow)this._flowMap.get(simplePageMaster.getRegion("start").getRegionName())) != null) {
            areaContainer = this.currentPage.getStart();
            areaContainer.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(flow, simplePageMaster.getRegion("start"), areaContainer);
        }
        if (simplePageMaster.getRegion("end") != null && this.currentPage.getEnd() != null && (flow = (Flow)this._flowMap.get(simplePageMaster.getRegion("end").getRegionName())) != null) {
            areaContainer = this.currentPage.getEnd();
            areaContainer.setIDReferences(areaTree.getIDReferences());
            this.layoutStaticContent(flow, simplePageMaster.getRegion("end"), areaContainer);
        }
    }

    private Flow getCurrentFlow(String string) {
        Region region = this.getCurrentSimplePageMaster().getRegion(string);
        if (region != null) {
            Flow flow = (Flow)this._flowMap.get(region.getRegionName());
            return flow;
        }
        System.out.println("flow is null. regionClass = '" + string + "' currentSPM = " + this.getCurrentSimplePageMaster());
        return null;
    }

    private String getCurrentPageMasterName() {
        return this.currentPageMasterName;
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    private SimplePageMaster getCurrentSimplePageMaster() {
        return this.layoutMasterSet.getSimplePageMaster(this.currentPageMasterName);
    }

    public String getIpnValue() {
        return this.ipnValue;
    }

    private PageMaster getNextPageMaster(String string, int n, boolean bl, boolean bl2) throws FOPException {
        PageMaster pageMaster = null;
        PageSequenceMaster pageSequenceMaster = this.layoutMasterSet.getPageSequenceMaster(string);
        if (pageSequenceMaster != null) {
            pageMaster = this.getNextSimplePageMaster(pageSequenceMaster, n, bl, bl2).getPageMaster();
        } else {
            SimplePageMaster simplePageMaster = this.layoutMasterSet.getSimplePageMaster(string);
            if (simplePageMaster == null) {
                throw new FOPException("'master-name' for 'fo:page-sequence'matches no 'simple-page-master' or 'page-sequence-master'");
            }
            this.currentPageMasterName = string;
            pageMaster = simplePageMaster.getNextPageMaster();
        }
        return pageMaster;
    }

    private String getNextPageMasterName(PageSequenceMaster pageSequenceMaster, int n, boolean bl, boolean bl2) {
        String string;
        if (this.currentSubsequence == null) {
            this.currentSubsequence = this.getNextSubsequence(pageSequenceMaster);
        }
        if ((string = this.currentSubsequence.getNextPageMaster(n, bl, bl2)) == null || this.isFlowForMasterNameDone(this.currentPageMasterName)) {
            SubSequenceSpecifier subSequenceSpecifier = this.getNextSubsequence(pageSequenceMaster);
            if (subSequenceSpecifier == null) {
                this.log.error("Page subsequences exhausted. Using previous subsequence.");
                bl = true;
                this.currentSubsequence.reset();
            } else {
                this.currentSubsequence = subSequenceSpecifier;
            }
            string = this.currentSubsequence.getNextPageMaster(n, bl, bl2);
        }
        this.currentPageMasterName = string;
        return string;
    }

    private SimplePageMaster getNextSimplePageMaster(PageSequenceMaster pageSequenceMaster, int n, boolean bl, boolean bl2) {
        if (this.isForcing) {
            String string = this.getNextPageMasterName(pageSequenceMaster, n, false, true);
            return this.layoutMasterSet.getSimplePageMaster(string);
        }
        String string = this.getNextPageMasterName(pageSequenceMaster, n, bl, bl2);
        return this.layoutMasterSet.getSimplePageMaster(string);
    }

    private SubSequenceSpecifier getNextSubsequence(PageSequenceMaster pageSequenceMaster) {
        if (pageSequenceMaster.getSubSequenceSpecifierCount() > this.currentSubsequenceNumber + 1) {
            this.currentSubsequence = pageSequenceMaster.getSubSequenceSpecifier(this.currentSubsequenceNumber + 1);
            ++this.currentSubsequenceNumber;
            return this.currentSubsequence;
        }
        return null;
    }

    private boolean isFlowForMasterNameDone(String string) {
        if (this.isForcing) {
            return false;
        }
        if (string != null) {
            SimplePageMaster simplePageMaster = this.layoutMasterSet.getSimplePageMaster(string);
            Region region = simplePageMaster.getRegion("body");
            Flow flow = (Flow)this._flowMap.get(region.getRegionName());
            return flow != null && !flow.getStatus().isIncomplete();
        }
        return false;
    }

    public boolean isFlowSet() {
        return this.isFlowSet;
    }

    private void layoutStaticContent(Flow flow, Region region, AreaContainer areaContainer) throws FOPException {
        if (flow instanceof StaticContent) {
            AreaContainer areaContainer2 = this.currentPage.getBefore();
            ((StaticContent)flow).layout(areaContainer, region);
        } else {
            this.log.error(region.getName() + " only supports static-content flows currently. Cannot use flow named '" + flow.getFlowName() + "'");
        }
    }

    private Page makePage(AreaTree areaTree, int n, boolean bl, boolean bl2) throws FOPException {
        PageMaster pageMaster = this.getNextPageMaster(this.masterName, n, bl, bl2);
        if (pageMaster == null) {
            throw new FOPException("page masters exhausted. Cannot recover.");
        }
        Page page = pageMaster.makePage(areaTree);
        if (this.currentPage != null) {
            Vector vector = this.currentPage.getPendingFootnotes();
            page.setPendingFootnotes(vector);
        }
        return page;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setIsFlowSet(boolean bl) {
        this.isFlowSet = bl;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new PageSequence(fObj, propertyList);
        }
    }
}

