/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BodyRegionArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RegionArea;

public class RegionBody
extends Region {
    public static final String REGION_CLASS = "body";
    ColorType backgroundColor;

    protected RegionBody(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
    }

    protected String getDefaultRegionName() {
        return "xsl-region-body";
    }

    protected String getElementName() {
        return "fo:region-body";
    }

    public String getRegionClass() {
        return REGION_CLASS;
    }

    RegionArea makeRegionArea(int n, int n2, int n3, int n4) {
        BorderAndPadding borderAndPadding = this.propMgr.getBorderAndPadding();
        BackgroundProps backgroundProps = this.propMgr.getBackgroundProps();
        MarginProps marginProps = this.propMgr.getMarginProps();
        this.backgroundColor = this.properties.get("background-color").getColorType();
        BodyRegionArea bodyRegionArea = new BodyRegionArea(n + marginProps.marginLeft, n2 - marginProps.marginTop, n3 - marginProps.marginLeft - marginProps.marginRight, n4 - marginProps.marginTop - marginProps.marginBottom);
        int n5 = this.properties.get("overflow").getEnum();
        String string = this.properties.get("column-count").getString();
        int n6 = 1;
        try {
            n6 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.error("Bad value on region body 'column-count'");
            n6 = 1;
        }
        if (n6 > 1 && n5 == 67) {
            this.log.error("Setting 'column-count' to 1 because 'overflow' is set to 'scroll'");
            n6 = 1;
        }
        bodyRegionArea.setColumnCount(n6);
        int n7 = this.properties.get("column-gap").getLength().mvalue();
        bodyRegionArea.setColumnGap(n7);
        bodyRegionArea.setBackgroundColor(this.backgroundColor);
        return bodyRegionArea;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new RegionBody(fObj, propertyList);
        }
    }
}

