/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.TextState;
import org.apache.fop.layout.hyphenation.Hyphenation;
import org.apache.fop.layout.hyphenation.Hyphenator;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.PageNumberInlineArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.render.Renderer;

public class LineArea
extends Area {
    protected int lineHeight;
    protected int halfLeading;
    protected int nominalFontSize;
    protected int nominalGlyphHeight;
    protected int allocationHeight;
    protected int startIndent;
    protected int endIndent;
    private int placementOffset;
    private FontState currentFontState;
    private float red;
    private float green;
    private float blue;
    private int wrapOption;
    private int whiteSpaceCollapse;
    int vAlign;
    HyphenationProps hyphProps;
    protected int finalWidth = 0;
    protected int embeddedLinkStart = 0;
    protected static final int NOTHING = 0;
    protected static final int WHITESPACE = 1;
    protected static final int TEXT = 2;
    protected int prev = 0;
    protected int spaceWidth = 0;
    protected Vector pendingAreas = new Vector();
    protected int pendingWidth = 0;
    protected boolean prevUlState = false;
    protected boolean prevOlState = false;
    protected boolean prevLTState = false;

    public LineArea(FontState fontState, int n, int n2, int n3, int n4, int n5, LineArea lineArea) {
        super(fontState);
        this.currentFontState = fontState;
        this.lineHeight = n;
        this.nominalFontSize = fontState.getFontSize();
        this.nominalGlyphHeight = fontState.getAscender() - fontState.getDescender();
        this.placementOffset = fontState.getAscender();
        this.contentRectangleWidth = n3 - n4 - n5;
        this.fontState = fontState;
        this.allocationHeight = this.nominalGlyphHeight;
        this.halfLeading = this.lineHeight - this.allocationHeight;
        this.startIndent = n4;
        this.endIndent = n5;
        if (lineArea != null) {
            Enumeration enumeration = lineArea.pendingAreas.elements();
            Box box = null;
            boolean bl = true;
            int n6 = 0;
            while (bl) {
                if (enumeration.hasMoreElements()) {
                    box = (Box)enumeration.nextElement();
                    if (box instanceof InlineSpace) {
                        InlineSpace inlineSpace = (InlineSpace)box;
                        if (inlineSpace.isEatable()) {
                            n6 += inlineSpace.getSize();
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
                box = null;
            }
            while (box != null) {
                this.pendingAreas.addElement(box);
                box = enumeration.hasMoreElements() ? (Box)enumeration.nextElement() : null;
            }
            this.pendingWidth = lineArea.getPendingWidth() - n6;
        }
    }

    public int addCharacter(char c, LinkSet linkSet, boolean bl) {
        WordArea wordArea = null;
        int n = this.getContentWidth() - this.getCurrentXPosition();
        int n2 = this.currentFontState.width(this.currentFontState.mapChar(c));
        if (n2 > n) {
            return 1;
        }
        if (Character.isSpaceChar(c) && this.whiteSpaceCollapse == 81) {
            return 0;
        }
        wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new Character(c).toString(), n2);
        wordArea.setYOffset(this.placementOffset);
        wordArea.setUnderlined(bl);
        this.pendingAreas.addElement(wordArea);
        if (Character.isSpaceChar(c)) {
            this.spaceWidth = n2;
            this.prev = 1;
        } else {
            this.pendingWidth += n2;
            this.prev = 2;
        }
        return 0;
    }

    public void addInlineArea(Area area) {
        this.addPending();
        this.addChild(area);
        this.prev = 2;
        this.finalWidth += area.getContentWidth();
    }

    public void addInlineSpace(InlineSpace inlineSpace, int n) {
        this.addChild(inlineSpace);
        this.finalWidth += n;
    }

    public void addLeader(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        char c = '.';
        int n10 = this.currentFontState.width(this.currentFontState.mapChar(c));
        char c2 = ' ';
        int n11 = this.currentFontState.width(this.currentFontState.mapChar(c2));
        int n12 = this.getContentWidth() - this.getCurrentXPosition();
        if (n12 <= n3 || n12 <= n4) {
            n9 = n12;
        } else if (n12 > n3 && n12 > n4) {
            n9 = n4;
        } else if (n3 > n4 && n3 < n12) {
            n9 = n3;
        }
        if (n9 <= 0) {
            return;
        }
        switch (n) {
            case 71: {
                InlineSpace inlineSpace = new InlineSpace(n9);
                this.pendingAreas.addElement(inlineSpace);
                break;
            }
            case 66: {
                LeaderArea leaderArea = new LeaderArea(this.fontState, this.red, this.green, this.blue, "", n9, n, n6, n5);
                leaderArea.setYOffset(this.placementOffset);
                this.pendingAreas.addElement(leaderArea);
                break;
            }
            case 19: {
                int n13;
                if (n7 < n10) {
                    n7 = 0;
                }
                if (n7 == 0) {
                    this.pendingAreas.addElement(this.buildSimpleLeader(c, n9));
                    break;
                }
                if (n8 == 60 && (n13 = this.getLeaderAlignIndent(n9, n7)) != 0) {
                    this.pendingAreas.addElement(new InlineSpace(n13, false));
                    this.pendingWidth += n13;
                    n9 -= n13;
                }
                InlineSpace inlineSpace = new InlineSpace(n7 - n10, false);
                WordArea wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new String("."), n10);
                wordArea.setYOffset(this.placementOffset);
                int n14 = (int)Math.floor((double)n9 / (double)n7);
                int n15 = 0;
                while (n15 < n14) {
                    this.pendingAreas.addElement(wordArea);
                    this.pendingAreas.addElement(inlineSpace);
                    ++n15;
                }
                this.pendingAreas.addElement(new InlineSpace(n9 - n14 * n7));
                break;
            }
            case 84: {
                MessageHandler.errorln("leader-pattern=\"use-content\" not supported by this version of Fop");
                return;
            }
        }
        this.pendingWidth += n9;
        this.prev = 2;
    }

    private void addMapWord(char c, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length());
        int n = 0;
        while (n < stringBuffer.length()) {
            stringBuffer2.append(this.currentFontState.mapChar(stringBuffer.charAt(n)));
            ++n;
        }
        this.addWord(c, stringBuffer2);
    }

    public int addPageNumberCitation(String string, LinkSet linkSet) {
        int n = this.currentFontState.width(this.currentFontState.mapChar(' '));
        PageNumberInlineArea pageNumberInlineArea = new PageNumberInlineArea(this.currentFontState, this.red, this.green, this.blue, string, n);
        pageNumberInlineArea.setYOffset(this.placementOffset);
        this.pendingAreas.addElement(pageNumberInlineArea);
        this.pendingWidth += n;
        this.prev = 2;
        return -1;
    }

    public void addPending() {
        if (this.spaceWidth > 0) {
            this.addChild(new InlineSpace(this.spaceWidth));
            this.finalWidth += this.spaceWidth;
            this.spaceWidth = 0;
        }
        Enumeration enumeration = this.pendingAreas.elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            this.addChild(box);
        }
        this.finalWidth += this.pendingWidth;
        this.pendingWidth = 0;
        this.pendingAreas = new Vector();
    }

    private void addSpacedWord(String string, LinkSet linkSet, int n, int n2, TextState textState, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u00a0\u202f\u3000\ufeff", true);
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 1 && this.isNBSP(string2.charAt(0))) {
                int n4 = this.getCharWidth(string2.charAt(0));
                if (n4 <= 0) continue;
                object = new InlineSpace(n4);
                n3 += n4;
                if (this.prevUlState) {
                    ((InlineSpace)object).setUnderlined(textState.getUnderlined());
                }
                if (this.prevOlState) {
                    ((InlineSpace)object).setOverlined(textState.getOverlined());
                }
                if (this.prevLTState) {
                    ((InlineSpace)object).setLineThrough(textState.getLineThrough());
                }
                if (bl) {
                    this.pendingAreas.addElement(object);
                    this.pendingWidth += n4;
                    continue;
                }
                this.addChild((Box)object);
                continue;
            }
            WordArea wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, string2, this.getWordWidth(string2));
            wordArea.setYOffset(this.placementOffset);
            wordArea.setUnderlined(textState.getUnderlined());
            this.prevUlState = textState.getUnderlined();
            wordArea.setOverlined(textState.getOverlined());
            this.prevOlState = textState.getOverlined();
            wordArea.setLineThrough(textState.getLineThrough());
            this.prevLTState = textState.getLineThrough();
            wordArea.setVerticalAlign(this.vAlign);
            if (bl) {
                this.pendingAreas.addElement(wordArea);
                this.pendingWidth += this.getWordWidth(string2);
            } else {
                this.addChild(wordArea);
            }
            if (linkSet == null) continue;
            object = new Rectangle(n + n3, n2, wordArea.getContentWidth(), this.fontState.getFontSize());
            linkSet.addRect((Rectangle)object, this, wordArea);
        }
    }

    public int addText(char[] cArray, int n, int n2, LinkSet linkSet, TextState textState) {
        if (n == -1) {
            return -1;
        }
        boolean bl = false;
        int n3 = n;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getCharWidth(' ');
        char[] cArray2 = new char[cArray.length];
        char[] cArray3 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        boolean bl2 = false;
        int n7 = n;
        while (n7 < n2) {
            int n8;
            char c = cArray2[n7];
            if (!this.isSpace(c) && c != '\n' && c != '\r' && c != '\t' && c != '\u2028') {
                n8 = this.getCharWidth(c);
                bl2 = true;
                if (n8 <= 0 && c != '\u200b' && c != '\ufeff') {
                    n8 = n6;
                }
            } else {
                Object object;
                n8 = c == '\n' || c == '\r' || c == '\t' ? n6 : this.getCharWidth(c);
                bl2 = false;
                if (this.prev == 1) {
                    if (this.whiteSpaceCollapse == 27) {
                        if (this.isSpace(c)) {
                            this.spaceWidth += this.getCharWidth(c);
                        } else {
                            if (c == '\n' || c == '\u2028') {
                                if (this.spaceWidth > 0) {
                                    object = new InlineSpace(this.spaceWidth);
                                    ((InlineSpace)object).setUnderlined(textState.getUnderlined());
                                    ((InlineSpace)object).setOverlined(textState.getOverlined());
                                    ((InlineSpace)object).setLineThrough(textState.getLineThrough());
                                    this.addChild((Box)object);
                                    this.finalWidth += this.spaceWidth;
                                    this.spaceWidth = 0;
                                }
                                return n7 + 1;
                            }
                            if (c == '\t') {
                                this.spaceWidth += 8 * n6;
                            }
                        }
                    } else if (c == '\u2028') {
                        if (this.spaceWidth > 0) {
                            object = new InlineSpace(this.spaceWidth);
                            ((InlineSpace)object).setUnderlined(textState.getUnderlined());
                            ((InlineSpace)object).setOverlined(textState.getOverlined());
                            ((InlineSpace)object).setLineThrough(textState.getLineThrough());
                            this.addChild((Box)object);
                            this.finalWidth += this.spaceWidth;
                            this.spaceWidth = 0;
                        }
                        return n7 + 1;
                    }
                } else if (this.prev == 2) {
                    if (this.spaceWidth > 0) {
                        object = new InlineSpace(this.spaceWidth);
                        if (this.prevUlState) {
                            ((InlineSpace)object).setUnderlined(textState.getUnderlined());
                        }
                        if (this.prevOlState) {
                            ((InlineSpace)object).setOverlined(textState.getOverlined());
                        }
                        if (this.prevLTState) {
                            ((InlineSpace)object).setLineThrough(textState.getLineThrough());
                        }
                        this.addChild((Box)object);
                        this.finalWidth += this.spaceWidth;
                        this.spaceWidth = 0;
                    }
                    object = this.pendingAreas.elements();
                    while (object.hasMoreElements()) {
                        Box box = (Box)object.nextElement();
                        if (box instanceof InlineArea && linkSet != null) {
                            Rectangle rectangle = new Rectangle(this.finalWidth, 0, ((InlineArea)box).getContentWidth(), this.fontState.getFontSize());
                            linkSet.addRect(rectangle, this, (InlineArea)box);
                        }
                        this.addChild(box);
                    }
                    this.finalWidth += this.pendingWidth;
                    this.pendingWidth = 0;
                    this.pendingAreas = new Vector();
                    if (n4 > 0) {
                        this.addSpacedWord(new String(cArray2, n3, n4), linkSet, this.finalWidth, 0, textState, false);
                        this.finalWidth += n5;
                        n5 = 0;
                    }
                    this.prev = 1;
                    this.embeddedLinkStart = 0;
                    this.spaceWidth = this.getCharWidth(c);
                    if (this.whiteSpaceCollapse == 27) {
                        if (c == '\n' || c == '\u2028') {
                            return n7 + 1;
                        }
                        if (c == '\t') {
                            this.spaceWidth = n6;
                        }
                    } else if (c == '\u2028') {
                        return n7 + 1;
                    }
                } else if (this.whiteSpaceCollapse == 27) {
                    if (this.isSpace(c)) {
                        this.prev = 1;
                        this.spaceWidth = this.getCharWidth(c);
                    } else {
                        if (c == '\n') {
                            object = new InlineSpace(this.spaceWidth);
                            this.addChild((Box)object);
                            return n7 + 1;
                        }
                        if (c == '\t') {
                            this.prev = 1;
                            this.spaceWidth = 8 * n6;
                        }
                    }
                } else {
                    ++n3;
                }
            }
            if (bl2) {
                if (this.prev == 1) {
                    n5 = n8;
                    if (this.finalWidth + this.spaceWidth + n5 > this.getContentWidth()) {
                        if (bl) {
                            MessageHandler.error(">");
                        }
                        if (this.wrapOption == 86) {
                            return n7;
                        }
                    }
                    this.prev = 2;
                    n3 = n7;
                    n4 = 1;
                } else if (this.prev == 2) {
                    ++n4;
                    n5 += n8;
                } else {
                    this.prev = 2;
                    n3 = n7;
                    n4 = 1;
                    n5 = n8;
                }
                if (this.finalWidth + this.spaceWidth + this.pendingWidth + n5 > this.getContentWidth()) {
                    if (this.canBreakMidWord()) {
                        this.addSpacedWord(new String(cArray2, n3, n4 - 1), linkSet, this.finalWidth + this.spaceWidth + this.embeddedLinkStart, this.spaceWidth, textState, false);
                        this.finalWidth += n5;
                        n5 = 0;
                        return n7;
                    }
                    if (this.wrapOption == 86) {
                        if (this.hyphProps.hyphenate == 81) {
                            int n9 = n3;
                            n9 = this.doHyphenation(cArray3, n7, n3, this.getContentWidth() - (this.finalWidth + this.spaceWidth + this.pendingWidth));
                            if (n9 == n3 && n3 == n && this.finalWidth == 0) {
                                MessageHandler.error(">");
                                this.addSpacedWord(new String(cArray2, n3, n4 - 1), linkSet, this.finalWidth + this.spaceWidth + this.embeddedLinkStart, this.spaceWidth, textState, false);
                                this.finalWidth += n5;
                                n5 = 0;
                                n9 = n7;
                            }
                            return n9;
                        }
                        if (n3 == n) {
                            bl = true;
                            if (this.finalWidth > 0) {
                                return n3;
                            }
                        } else {
                            return n3;
                        }
                    }
                }
            }
            ++n7;
        }
        if (this.prev == 2) {
            if (this.spaceWidth > 0) {
                InlineSpace inlineSpace = new InlineSpace(this.spaceWidth);
                inlineSpace.setEatable(true);
                if (this.prevUlState) {
                    inlineSpace.setUnderlined(textState.getUnderlined());
                }
                if (this.prevOlState) {
                    inlineSpace.setOverlined(textState.getOverlined());
                }
                if (this.prevLTState) {
                    inlineSpace.setLineThrough(textState.getLineThrough());
                }
                this.pendingAreas.addElement(inlineSpace);
                this.pendingWidth += this.spaceWidth;
                this.spaceWidth = 0;
            }
            this.addSpacedWord(new String(cArray2, n3, n4), linkSet, this.finalWidth + this.spaceWidth + this.embeddedLinkStart, this.spaceWidth, textState, true);
            this.embeddedLinkStart += n5;
            n5 = 0;
        }
        if (bl) {
            MessageHandler.error(">");
        }
        return -1;
    }

    private void addWord(char c, StringBuffer stringBuffer) {
        WordArea wordArea;
        String string = stringBuffer != null ? stringBuffer.toString() : "";
        int n = this.getCharWidth(c);
        if (this.isAnySpace(c)) {
            this.addChild(new InlineSpace(n));
        } else {
            wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new Character(c).toString(), 1);
            wordArea.setYOffset(this.placementOffset);
            this.addChild(wordArea);
        }
        int n2 = this.getWordWidth(string);
        wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, string, string.length());
        wordArea.setYOffset(this.placementOffset);
        this.addChild(wordArea);
        this.finalWidth += n + n2;
    }

    public void align(int n) {
        int n2 = 0;
        switch (n) {
            case 72: {
                n2 = this.getContentWidth() - this.finalWidth;
                this.endIndent += n2;
                break;
            }
            case 22: {
                n2 = this.getContentWidth() - this.finalWidth;
                this.startIndent += n2;
                break;
            }
            case 13: {
                n2 = (this.getContentWidth() - this.finalWidth) / 2;
                this.startIndent += n2;
                this.endIndent += n2;
                break;
            }
            case 37: {
                InlineSpace inlineSpace;
                Box box;
                int n3 = 0;
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    box = (Box)enumeration.nextElement();
                    if (!(box instanceof InlineSpace) || !(inlineSpace = (InlineSpace)box).getResizeable()) continue;
                    ++n3;
                }
                n2 = n3 > 0 ? (this.getContentWidth() - this.finalWidth) / n3 : 0;
                n3 = 0;
                enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    box = (Box)enumeration.nextElement();
                    if (box instanceof InlineSpace) {
                        inlineSpace = (InlineSpace)box;
                        if (!inlineSpace.getResizeable()) continue;
                        inlineSpace.setSize(inlineSpace.getSize() + n2);
                        ++n3;
                        continue;
                    }
                    if (!(box instanceof InlineArea)) continue;
                    ((InlineArea)box).setXOffset(n3 * n2);
                }
                break;
            }
        }
    }

    private InlineArea buildSimpleLeader(char c, int n) {
        int n2 = this.currentFontState.width(this.currentFontState.mapChar(c));
        if (n2 == 0) {
            MessageHandler.errorln("char " + c + " has width 0. Using width 100 instead.");
            n2 = 100;
        }
        int n3 = (int)Math.floor(n / n2);
        char[] cArray = new char[n3];
        int n4 = 0;
        while (n4 < n3) {
            cArray[n4] = c;
            ++n4;
        }
        WordArea wordArea = new WordArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray), n);
        wordArea.setYOffset(this.placementOffset);
        return wordArea;
    }

    private boolean canBreakMidWord() {
        String string;
        boolean bl = false;
        if (this.hyphProps != null && this.hyphProps.language != null && !this.hyphProps.language.equals("NONE") && ("zh".equals(string = this.hyphProps.language.toLowerCase()) || "ja".equals(string) || "ko".equals(string) || "vi".equals(string))) {
            bl = true;
        }
        return bl;
    }

    public void changeColor(float f, float f2, float f3) {
        this.red = f;
        this.green = f2;
        this.blue = f3;
    }

    public void changeFont(FontState fontState) {
        this.currentFontState = fontState;
    }

    public void changeHyphenation(HyphenationProps hyphenationProps) {
        this.hyphProps = hyphenationProps;
    }

    public void changeVerticalAlign(int n) {
        this.vAlign = n;
    }

    public void changeWhiteSpaceCollapse(int n) {
        this.whiteSpaceCollapse = n;
    }

    public void changeWrapOption(int n) {
        this.wrapOption = n;
    }

    public int doHyphenation(char[] cArray, int n, int n2, int n3) {
        Hyphenation hyphenation;
        char c;
        String string;
        if (this.hyphProps.language.equalsIgnoreCase("none")) {
            MessageHandler.errorln("if property 'hyphenate' is used, a language must be specified");
            return n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        char c2 = ' ';
        int n4 = this.currentFontState.width(this.currentFontState.mapChar(this.hyphProps.hyphenationChar));
        n3 -= n4;
        if (cArray[n2] == '\"' || cArray[n2] == '\'') {
            stringBuffer.append(cArray[n2]);
            string = this.getHyphenationWord(cArray, n2 + 1);
        } else {
            string = this.getHyphenationWord(cArray, n2);
        }
        if (this.getWordWidth(string) < n3 && ((c = cArray[n2 + string.length()]) == '-' || c == '/')) {
            stringBuffer2 = new StringBuffer(string);
            stringBuffer2 = stringBuffer2.append(c);
            string = this.getHyphenationWord(cArray, n2 + string.length() + 1);
            n3 -= this.getWordWidth(string) + this.currentFontState.width(this.currentFontState.mapChar(c));
        }
        if ((hyphenation = Hyphenator.hyphenate(this.hyphProps.language, this.hyphProps.country, string, this.hyphProps.hyphenationRemainCharacterCount, this.hyphProps.hyphenationPushCharacterCount)) == null && stringBuffer2 == null) {
            if (stringBuffer.length() > 0) {
                return n2 - 1;
            }
            return n2;
        }
        if (hyphenation == null && stringBuffer2 != null) {
            stringBuffer.append((Object)stringBuffer2);
            this.addWord(c2, stringBuffer);
            return n2 + stringBuffer.length();
        }
        if (hyphenation != null && stringBuffer2 == null) {
            int n5 = this.getFinalHyphenationPoint(hyphenation, n3);
            if (n5 != -1) {
                stringBuffer.append(hyphenation.getPreHyphenText(n5));
                stringBuffer.append(this.hyphProps.hyphenationChar);
                this.addWord(c2, stringBuffer);
                return n2 + stringBuffer.length() - 1;
            }
        } else if (hyphenation != null && stringBuffer2 != null) {
            int n6 = this.getFinalHyphenationPoint(hyphenation, n3);
            if (n6 != -1) {
                stringBuffer.append((Object)stringBuffer2.append(hyphenation.getPreHyphenText(n6)));
                stringBuffer.append(this.hyphProps.hyphenationChar);
                this.addWord(c2, stringBuffer);
                return n2 + stringBuffer.length() - 1;
            }
            stringBuffer.append((Object)stringBuffer2);
            this.addWord(c2, stringBuffer);
            return n2 + stringBuffer.length();
        }
        return n2;
    }

    private int getCharWidth(char c) {
        int n = this.currentFontState.width(this.currentFontState.mapChar(c));
        if (n <= 0) {
            int n2 = this.currentFontState.width(this.currentFontState.mapChar('m'));
            int n3 = this.currentFontState.width(this.currentFontState.mapChar('n'));
            if (n2 <= 0) {
                n2 = 500 * this.currentFontState.getFontSize();
            }
            if (n3 <= 0) {
                n3 = n2 - 10;
            }
            if (c == ' ') {
                n = n2;
            }
            if (c == '\u2000') {
                n = n3;
            }
            if (c == '\u2001') {
                n = n2;
            }
            if (c == '\u2002') {
                n = n2 / 2;
            }
            if (c == '\u2003') {
                n = this.currentFontState.getFontSize();
            }
            if (c == '\u2004') {
                n = n2 / 3;
            }
            if (c == '\u2005') {
                n = n2 / 4;
            }
            if (c == '\u2006') {
                n = n2 / 6;
            }
            if (c == '\u2007') {
                n = this.getCharWidth(' ');
            }
            if (c == '\u2008') {
                n = this.getCharWidth('.');
            }
            if (c == '\u2009') {
                n = n2 / 5;
            }
            if (c == '\u200a') {
                n = 5;
            }
            if (c == '\u200b') {
                n = 100;
            }
            if (c == '\u00a0') {
                n = this.getCharWidth(' ');
            }
            if (c == '\u202f') {
                n = this.getCharWidth(' ') / 2;
            }
            if (c == '\u3000') {
                n = this.getCharWidth(' ') * 2;
            }
            if (c == '\n' || c == '\r' || c == '\t') {
                n = this.getCharWidth(' ');
            }
        }
        return n;
    }

    private int getCurrentXPosition() {
        return this.finalWidth + this.spaceWidth + this.startIndent + this.pendingWidth;
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    private int getFinalHyphenationPoint(Hyphenation hyphenation, int n) {
        int[] nArray = hyphenation.getHyphenationPoints();
        int n2 = nArray.length;
        int n3 = -1;
        String string = "";
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            string = hyphenation.getPreHyphenText(n4);
            if (this.getWordWidth(string) > n) break;
            n3 = n4++;
        }
        return n3;
    }

    public int getHeight() {
        return this.allocationHeight;
    }

    private String getHyphenationWord(char[] cArray, int n) {
        boolean bl = false;
        int n2 = 0;
        char[] cArray2 = new char[100];
        while (!bl && n + n2 < cArray.length) {
            char c = cArray[n + n2];
            if (Character.isLetter(c)) {
                cArray2[n2] = c;
                ++n2;
                continue;
            }
            bl = true;
        }
        return new String(cArray2, 0, n2);
    }

    private int getLeaderAlignIndent(int n, int n2) {
        double d = this.getCurrentXPosition();
        double d2 = Math.ceil(d / (double)n2);
        double d3 = (double)n2 * d2 - d;
        return (int)d3;
    }

    public Vector getPendingAreas() {
        return this.pendingAreas;
    }

    public int getPendingWidth() {
        return this.pendingWidth;
    }

    public int getPlacementOffset() {
        return this.placementOffset;
    }

    public int getRemainingWidth() {
        return this.getContentWidth() - this.getCurrentXPosition();
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    private int getWordWidth(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        while (n3 < n) {
            n2 += this.getCharWidth(cArray[n3]);
            ++n3;
        }
        return n2;
    }

    private boolean isAnySpace(char c) {
        boolean bl = this.isSpace(c) || this.isNBSP(c);
        return bl;
    }

    public boolean isEmpty() {
        return (this.pendingAreas.size() > 0 || this.children.size() > 0) ^ true;
    }

    private boolean isNBSP(char c) {
        return c == '\u00a0' || c == '\u202f' || c == '\u3000' || c == '\ufeff';
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\u2000' || c == '\u2001' || c == '\u2002' || c == '\u2003' || c == '\u2004' || c == '\u2005' || c == '\u2006' || c == '\u2007' || c == '\u2008' || c == '\u2009' || c == '\u200a' || c == '\u200b';
    }

    public void render(Renderer renderer) {
        renderer.renderLineArea(this);
    }

    public void setLinkSet(LinkSet linkSet) {
    }

    public void setPendingAreas(Vector vector) {
        this.pendingAreas = vector;
    }

    public void setPendingWidth(int n) {
        this.pendingWidth = n;
    }

    public void verticalAlign() {
        int n = -this.placementOffset;
        int n2 = this.allocationHeight;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            int n3;
            int n4;
            Box box = (Box)enumeration.nextElement();
            if (!(box instanceof InlineArea)) continue;
            InlineArea inlineArea = (InlineArea)box;
            if (inlineArea instanceof WordArea) {
                inlineArea.setYOffset(this.placementOffset);
            }
            if (inlineArea.getHeight() > n2) {
                n2 = inlineArea.getHeight();
            }
            if ((n4 = inlineArea.getVerticalAlign()) == 75) {
                n3 = this.fontState.getAscender();
                inlineArea.setYOffset((int)((double)this.placementOffset - (double)(2 * n3) / 3.0));
                continue;
            }
            if (n4 != 74) continue;
            n3 = this.fontState.getAscender();
            inlineArea.setYOffset((int)((double)this.placementOffset + (double)(2 * n3) / 3.0));
        }
        this.allocationHeight = n2;
    }
}

