/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkedRectangle;
import org.apache.fop.layout.inline.InlineArea;

public class LinkSet {
    String destination;
    Vector rects = new Vector();
    private int xoffset = 0;
    private int yoffset = 0;
    private int maxY = 0;
    protected int startIndent;
    protected int endIndent;
    private int linkType;
    private Area area;
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    int contentRectangleWidth = 0;

    public LinkSet(String string, Area area, int n) {
        this.destination = string;
        this.area = area;
        this.linkType = n;
    }

    public void addRect(Rectangle rectangle, LineArea lineArea, InlineArea inlineArea) {
        LinkedRectangle linkedRectangle = new LinkedRectangle(rectangle, lineArea, inlineArea);
        linkedRectangle.setY(this.yoffset);
        if (this.yoffset > this.maxY) {
            this.maxY = this.yoffset;
        }
        this.rects.addElement(linkedRectangle);
    }

    public void align() {
        Enumeration enumeration = this.rects.elements();
        while (enumeration.hasMoreElements()) {
            LinkedRectangle linkedRectangle = (LinkedRectangle)enumeration.nextElement();
            linkedRectangle.setX(linkedRectangle.getX() + linkedRectangle.getLineArea().getStartIndent() + linkedRectangle.getInlineArea().getXOffset());
        }
    }

    public void applyAreaContainerOffsets(AreaContainer areaContainer, Area area) {
        int n = area.getAbsoluteHeight();
        BlockArea blockArea = (BlockArea)area;
        Enumeration enumeration = this.rects.elements();
        while (enumeration.hasMoreElements()) {
            LinkedRectangle linkedRectangle = (LinkedRectangle)enumeration.nextElement();
            linkedRectangle.setX(linkedRectangle.getX() + areaContainer.getXPosition() + area.getTableCellXOffset());
            linkedRectangle.setY(areaContainer.getYPosition() - n + (this.maxY - linkedRectangle.getY()) - blockArea.getHalfLeading());
        }
    }

    public Area getArea() {
        return this.area;
    }

    public String getDest() {
        return this.destination;
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public int getLinkType() {
        return this.linkType;
    }

    public Vector getRects() {
        return this.rects;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public void mergeLinks() {
        int n = this.rects.size();
        if (n == 1) {
            return;
        }
        LinkedRectangle linkedRectangle = new LinkedRectangle((LinkedRectangle)this.rects.elementAt(0));
        Vector<LinkedRectangle> vector = new Vector<LinkedRectangle>();
        int n2 = 1;
        while (n2 < n) {
            LinkedRectangle linkedRectangle2 = (LinkedRectangle)this.rects.elementAt(n2);
            if (linkedRectangle2.getLineArea() == linkedRectangle.getLineArea()) {
                linkedRectangle.setWidth(linkedRectangle2.getX() + linkedRectangle2.getWidth() - linkedRectangle.getX());
            } else {
                vector.addElement(linkedRectangle);
                linkedRectangle = new LinkedRectangle(linkedRectangle2);
            }
            if (n2 == n - 1) {
                vector.addElement(linkedRectangle);
            }
            ++n2;
        }
        this.rects = vector;
    }

    public void setContentRectangleWidth(int n) {
        this.contentRectangleWidth = n;
    }

    public void setXOffset(int n) {
        this.xoffset = n;
    }

    public void setYOffset(int n) {
        this.yoffset = n;
    }
}

