/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.Vector;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFShading;

public class PDFPattern
extends PDFPathPaint {
    protected PDFResources resources = null;
    protected int patternType = 2;
    protected String patternName = null;
    protected int paintType = 2;
    protected int tilingType = 1;
    protected Vector bBox = null;
    protected double xStep = -1.0;
    protected double yStep = -1.0;
    protected PDFShading shading = null;
    protected Vector xUID = null;
    protected StringBuffer extGState = null;
    protected Vector matrix = null;
    protected StringBuffer patternDataStream = null;

    public PDFPattern(int n, String string, int n2, PDFShading pDFShading, Vector vector, StringBuffer stringBuffer, Vector vector2) {
        super(n);
        this.patternName = string;
        this.patternType = 2;
        this.shading = pDFShading;
        this.xUID = vector;
        this.extGState = stringBuffer;
        this.matrix = vector2;
    }

    public PDFPattern(int n, String string, PDFResources pDFResources, int n2, int n3, int n4, Vector vector, double d, double d2, Vector vector2, Vector vector3, StringBuffer stringBuffer) {
        super(n);
        this.patternName = string;
        this.resources = pDFResources;
        this.patternType = 1;
        this.paintType = n3;
        this.tilingType = n4;
        this.bBox = vector;
        this.xStep = d;
        this.yStep = d2;
        this.matrix = vector2;
        this.xUID = vector3;
        this.patternDataStream = stringBuffer;
    }

    public String getColorSpaceOut(boolean bl) {
        if (bl) {
            return "/Pattern cs /" + this.getName() + " scn \n";
        }
        return "/Pattern CS /" + this.getName() + " SCN \n";
    }

    public String getName() {
        return this.patternName;
    }

    public byte[] toPDF() {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.number) + " " + this.generation + " obj\n<< \n/Type /Pattern \n");
        if (this.resources != null) {
            stringBuffer.append("/Resources " + this.resources.referencePDF() + " \n");
        }
        stringBuffer.append("/PatternType " + this.patternType + " \n");
        if (this.patternType == 1) {
            stringBuffer.append("/PaintType " + this.paintType + " \n");
            stringBuffer.append("/TilingType " + this.tilingType + " \n");
            if (this.bBox != null) {
                n = this.bBox.size();
                stringBuffer.append("/BBox [ ");
                n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.bBox.elementAt(n2)));
                    stringBuffer.append(" ");
                    ++n2;
                }
                stringBuffer.append("] \n");
            }
            stringBuffer.append("/XStep " + PDFNumber.doubleOut(new Double(this.xStep)) + " \n");
            stringBuffer.append("/YStep " + PDFNumber.doubleOut(new Double(this.yStep)) + " \n");
            if (this.matrix != null) {
                n = this.matrix.size();
                stringBuffer.append("/Matrix [ ");
                n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.matrix.elementAt(n2)));
                    stringBuffer.append(" ");
                    ++n2;
                }
                stringBuffer.append("] \n");
            }
            if (this.xUID != null) {
                n = this.xUID.size();
                stringBuffer.append("/XUID [ ");
                n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(String.valueOf(String.valueOf((Integer)this.xUID.elementAt(n2))) + " ");
                    ++n2;
                }
                stringBuffer.append("] \n");
            }
            if (this.patternDataStream != null) {
                stringBuffer.append("/Length " + (this.patternDataStream.length() + 1) + " \n");
            }
        } else {
            if (this.shading != null) {
                stringBuffer.append("/Shading " + this.shading.referencePDF() + " \n");
            }
            if (this.xUID != null) {
                n = this.xUID.size();
                stringBuffer.append("/XUID [ ");
                n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(String.valueOf(String.valueOf((Integer)this.xUID.elementAt(n2))) + " ");
                    ++n2;
                }
                stringBuffer.append("] \n");
            }
            if (this.extGState != null) {
                stringBuffer.append("/ExtGState " + this.extGState + " \n");
            }
            if (this.matrix != null) {
                n = this.matrix.size();
                stringBuffer.append("/Matrix [ ");
                n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.matrix.elementAt(n2)));
                    stringBuffer.append(" ");
                    ++n2;
                }
                stringBuffer.append("] \n");
            }
        }
        stringBuffer.append(">> \n");
        if (this.patternDataStream != null) {
            stringBuffer.append("stream\n" + this.patternDataStream + "\nendstream\n");
        }
        stringBuffer.append("endobj\n");
        return stringBuffer.toString().getBytes();
    }
}

