/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.messaging.MessageHandler;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFXObject
extends PDFObject {
    FopImage fopimage;
    int Xnum;

    public PDFXObject(int n, int n2, FopImage fopImage) {
        super(n);
        this.Xnum = n2;
        if (fopImage == null) {
            MessageHandler.errorln("FISH");
        }
        this.fopimage = fopImage;
    }

    public int getXNumber() {
        return this.Xnum;
    }

    protected int output(OutputStream outputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        try {
            Object object;
            PDFStream pDFStream = new PDFStream(0);
            pDFStream.setData(this.fopimage.getBitmaps());
            if (this.fopimage.getPDFFilter() != null) {
                pDFStream.addFilter(this.fopimage.getPDFFilter());
            }
            pDFStream.addDefaultFilters();
            String string = pDFStream.applyFilters();
            String string2 = String.valueOf(this.number) + " " + this.generation + " obj\n";
            string2 = String.valueOf(string2) + "<</Type /XObject\n";
            string2 = String.valueOf(string2) + "/Subtype /Image\n";
            string2 = String.valueOf(string2) + "/Name /Im" + this.Xnum + "\n";
            string2 = String.valueOf(string2) + "/Length " + pDFStream.getDataLength() + "\n";
            string2 = String.valueOf(string2) + "/Width " + this.fopimage.getWidth() + "\n";
            string2 = String.valueOf(string2) + "/Height " + this.fopimage.getHeight() + "\n";
            string2 = String.valueOf(string2) + "/BitsPerComponent " + this.fopimage.getBitsPerPixel() + "\n";
            ColorSpace colorSpace = this.fopimage.getColorSpace();
            string2 = String.valueOf(string2) + "/ColorSpace /" + colorSpace.getColorSpacePDFString() + "\n";
            if (this.fopimage.isTransparent()) {
                object = this.fopimage.getTransparentColor();
                string2 = String.valueOf(string2) + "/Mask [" + ((PDFColor)object).red255() + " " + ((PDFColor)object).red255() + " " + ((PDFColor)object).green255() + " " + ((PDFColor)object).green255() + " " + ((PDFColor)object).blue255() + " " + ((PDFColor)object).blue255() + "]\n";
            }
            string2 = String.valueOf(string2) + string;
            string2 = String.valueOf(string2) + ">>\n";
            this.fopimage.close();
            object = string2.getBytes();
            outputStream.write((byte[])object);
            n += ((Object)object).length;
            n += pDFStream.outputStreamData(outputStream);
            object = "endobj\n".getBytes();
            outputStream.write((byte[])object);
            n += ((Object)object).length;
        }
        catch (FopImageException fopImageException) {
            MessageHandler.errorln("Error in XObject : " + fopImageException.getMessage());
        }
        return n;
    }

    byte[] toPDF() {
        return null;
    }
}

