/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.fop.render.ps.Filter;
import org.apache.fop.render.ps.FilterThread;

public class ASCIIHexEncodeFilter
implements Filter {
    private static final char ASCIIHEX_EOL = '\n';
    private static final String ASCIIHEX_EOD = ">";
    private static final String ENCODING = "US-ASCII";

    protected ASCIIHexEncodeFilter() {
    }

    public void doFilter(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[2048];
        StringBuffer stringBuffer = new StringBuffer(4096);
        while ((n = inputStream.read(byArray)) != -1) {
            stringBuffer.setLength(0);
            int n2 = 0;
            while (n2 < n) {
                int n3 = byArray[n2] & 0xFF;
                if (n3 < 16) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(Integer.toHexString(n3));
                ++n2;
            }
            l = this.write(outputStream, stringBuffer.toString().getBytes(ENCODING), n * 2, l);
        }
        byte[] byArray2 = ASCIIHEX_EOD.getBytes(ENCODING);
        l = this.write(outputStream, byArray2, byArray2.length, l);
    }

    public static InputStream filter(InputStream inputStream) throws IOException {
        ASCIIHexEncodeFilter aSCIIHexEncodeFilter = new ASCIIHexEncodeFilter();
        return FilterThread.filter(inputStream, aSCIIHexEncodeFilter);
    }

    public long write(OutputStream outputStream, byte[] byArray, int n, long l) throws IOException {
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        while (n3 > 0) {
            int n4 = 80 - (int)((l + (long)n2) % 80L);
            if (n3 < n4) {
                n4 = n3;
                bl = true;
            }
            if (n4 > 0) {
                outputStream.write(byArray, n2, n4);
                n2 += n4;
                if (!bl) {
                    outputStream.write(10);
                }
            }
            n3 = n - n2;
        }
        return l + (long)n;
    }
}

