/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.Starter;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.tools.anttasks.Fop;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.StreamTarget;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.XMLReader;

class FOPTaskStarter
extends Starter {
    Fop task;
    Logger log;

    FOPTaskStarter(Fop fop) throws FOPException {
        this.task = fop;
        Hierarchy hierarchy = new Hierarchy();
        PatternFormatter patternFormatter = new PatternFormatter("%{message}\n%{throwable}");
        StreamTarget streamTarget = null;
        boolean bl = true;
        if (bl) {
            streamTarget = new StreamTarget((OutputStream)System.out, (Formatter)patternFormatter);
        } else {
            try {
                File file = new File("fop.log");
                streamTarget = new FileTarget(file, false, (Formatter)patternFormatter);
            }
            catch (IOException iOException) {}
        }
        hierarchy.setDefaultLogTarget((LogTarget)streamTarget);
        this.log = hierarchy.getLoggerFor("fop");
        this.log.setPriority(Priority.INFO);
    }

    private String determineExtension(int n) {
        switch (n) {
            case 1: {
                return ".pdf";
            }
            case 7: {
                return ".ps";
            }
            case 3: {
                return ".mif";
            }
            case 6: {
                return ".pcl";
            }
            case 8: {
                return ".txt";
            }
            case 4: {
                return ".xml";
            }
        }
        String string = "Unknown renderer: " + n;
        this.log.error(string);
        throw new BuildException(string);
    }

    private int determineRenderer(String string) {
        if (string == null || string.equalsIgnoreCase("application/pdf") || string.equalsIgnoreCase("pdf")) {
            return 1;
        }
        if (string.equalsIgnoreCase("application/postscript") || string.equalsIgnoreCase("ps")) {
            return 7;
        }
        if (string.equalsIgnoreCase("application/vnd.mif") || string.equalsIgnoreCase("mif")) {
            return 3;
        }
        if (string.equalsIgnoreCase("application/vnd.gp-PCL") || string.equalsIgnoreCase("pcl")) {
            return 6;
        }
        if (string.equalsIgnoreCase("text/plain") || string.equalsIgnoreCase("txt")) {
            return 8;
        }
        if (string.equalsIgnoreCase("text/xml") || string.equalsIgnoreCase("at") || string.equalsIgnoreCase("xml")) {
            return 4;
        }
        String string2 = "Couldn't determine renderer to use: " + string;
        this.log.error(string2);
        throw new BuildException(string2);
    }

    private void render(File file, File file2, int n) throws FOPException {
        FOInputHandler fOInputHandler = new FOInputHandler(file);
        XMLReader xMLReader = ((InputHandler)fOInputHandler).getParser();
        this.setParserFeatures(xMLReader);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (Exception exception) {
            this.log.error("Failed to open " + file2);
            throw new BuildException((Throwable)exception);
        }
        this.task.log(String.valueOf(String.valueOf(file)) + " -> " + file2, 2);
        try {
            Driver driver = new Driver(((InputHandler)fOInputHandler).getInputSource(), fileOutputStream);
            driver.setLogger(this.log);
            driver.setRenderer(n);
            driver.setXMLReader(xMLReader);
            driver.run();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.log.error("Couldn't render file: " + exception.getMessage());
            throw new BuildException((Throwable)exception);
        }
    }

    private File replaceExtension(File file, String string, String string2) {
        String string3 = file.getName();
        if (string3.toLowerCase().endsWith(string)) {
            string3 = string3.substring(0, string3.length() - string.length());
        }
        string3 = string3.concat(string2);
        return new File(file.getParentFile(), string3);
    }

    public void run() throws FOPException {
        try {
            Configuration.put("baseDir", this.task.getFofile().getParentFile().toURL().toExternalForm());
        }
        catch (Exception exception) {
            this.task.log("Error setting base directory", 4);
        }
        this.task.log("Using base directory: " + Configuration.getValue("baseDir"), 4);
        int n = this.determineRenderer(this.task.getFormat());
        String string = this.determineExtension(n);
        int n2 = 0;
        if (this.task.getFofile() != null && this.task.getFofile().exists()) {
            File file = this.task.getOutfile();
            if (file == null) {
                throw new BuildException("outfile is required when fofile is used");
            }
            if (this.task.getOutdir() != null) {
                file = new File(this.task.getOutdir(), file.getName());
            }
            this.render(this.task.getFofile(), file, n);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.task.filesets.size()) {
            FileSet fileSet = (FileSet)this.task.filesets.elementAt(n3);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.task.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n4 = 0;
            while (n4 < stringArray.length) {
                File file = new File(fileSet.getDir(this.task.getProject()), stringArray[n4]);
                File file2 = this.replaceExtension(file, ".fo", string);
                if (this.task.getOutdir() != null) {
                    file2 = new File(this.task.getOutdir(), file2.getName());
                }
                this.render(file, file2, n);
                ++n2;
                ++n4;
            }
            ++n3;
        }
        if (n2 == 0) {
            this.task.log("No files processed. No files were selected by the filesets and no fofile was set.", 1);
        }
    }
}

