/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools.anttasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.fop.tools.xslt.XSLTransform;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Xslt
extends Task {
    private String infile;
    private String outfile;
    private String xsltfile;
    private String mergefile;
    private String smart = "no";
    private String dependent = "none";
    private boolean startXslt = false;
    private boolean useTrax = false;

    private Document buildDocument(String string) throws IOException, SAXException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new FileInputStream(string));
            if (this.mergefile != null && !this.mergefile.equals("")) {
                File file = new File(this.mergefile);
                Document document2 = documentBuilder.parse(new FileInputStream(file));
                Node node = document.importNode(document2.getDocumentElement(), true);
                document.getDocumentElement().appendChild(node);
            }
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Task xslt - SAX ERROR:\n      " + parserConfigurationException.getMessage());
            return null;
        }
    }

    private boolean dependenciesCheck(File file, long l) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.dependent, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            File file2 = new File(string);
            if (file2.exists()) {
                if (l >= file2.lastModified()) continue;
                return true;
            }
            System.err.println("Task xslt - ERROR in attribute 'dependent':\n      file " + string + " does not exist.");
        }
        return false;
    }

    public void execute() throws BuildException {
        File file = new File(this.outfile);
        File file2 = new File(this.infile);
        File file3 = new File(this.xsltfile);
        long l = file.lastModified();
        boolean bl = true;
        if (!file2.exists()) {
            System.err.println("Task xslt - ERROR:\n      Input file " + this.infile + " does not exist!");
            bl = false;
        } else if (!file3.exists()) {
            System.err.println("Task xslt - ERROR:\n      Stylesheet file " + this.xsltfile + " does not exist!");
            bl = false;
        }
        if (this.smart.equals("no")) {
            this.startXslt = true;
        } else if (this.smart.equals("yes")) {
            this.startXslt = this.smartCheck(file, l, file2, file3);
            if ((this.dependent.equals("none") ^ true) & !this.startXslt) {
                this.startXslt = this.dependenciesCheck(file, l);
            }
        } else {
            System.err.println("Task xslt - ERROR: Allowed values for the attribute smart are 'yes' or 'no'");
        }
        if (bl & this.startXslt) {
            this.transform();
        }
    }

    public void setDependent(String string) {
        this.dependent = string;
    }

    public void setInfile(String string) {
        this.infile = string;
    }

    public void setMergefile(String string) {
        this.mergefile = string;
    }

    public void setOutfile(String string) {
        this.outfile = string;
    }

    public void setSmart(String string) {
        this.smart = string;
    }

    public void setXsltfile(String string) {
        this.xsltfile = string;
    }

    private boolean smartCheck(File file, long l, File file2, File file3) {
        if (file.exists()) {
            return l < file2.lastModified() | l < file3.lastModified();
        }
        return true;
    }

    private void transform() {
        try {
            Document document = null;
            if (this.mergefile != null && !this.mergefile.equals("")) {
                document = this.buildDocument(this.infile);
            }
            System.out.println("============================");
            System.out.println("xslt \nin: " + this.infile + "\nstyle: " + this.xsltfile + "\nout: " + this.outfile);
            System.out.println("============================");
            if (document != null) {
                XSLTransform.transform(document, this.xsltfile, this.outfile);
            } else {
                XSLTransform.transform(this.infile, this.xsltfile, this.outfile);
            }
        }
        catch (SAXException sAXException) {
            System.out.println("Task xslt - SAX ERROR:\n      " + sAXException);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Task xslt - URL ERROR:\n      " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("Task xslt - IO ERROR:\n      " + iOException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

