/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.AbstractConfiguration;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class DefaultConfiguration
extends AbstractConfiguration
implements Serializable {
    protected static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    private final String m_name;
    private final String m_location;
    private HashMap m_attributes;
    private ArrayList m_children;
    private String m_value;
    private boolean m_readOnly;

    public DefaultConfiguration(String name, String location) {
        this.m_name = name;
        this.m_location = location;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getValue() throws ConfigurationException {
        if (null != this.m_value) {
            return this.m_value;
        }
        throw new ConfigurationException("No value is associated with the configuration element \"" + this.getName() + "\"");
    }

    public String[] getAttributeNames() {
        if (null == this.m_attributes) {
            return new String[0];
        }
        return this.m_attributes.keySet().toArray(new String[0]);
    }

    public Configuration[] getChildren() {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        return this.m_children.toArray(new Configuration[0]);
    }

    public String getAttribute(String name) throws ConfigurationException {
        String value;
        String string = value = null != this.m_attributes ? (String)this.m_attributes.get(name) : null;
        if (null != value) {
            return value;
        }
        throw new ConfigurationException("No attribute named \"" + name + "\" is " + "associated with the configuration element \"" + this.getName() + "\"");
    }

    public Configuration getChild(String name, boolean createNew) {
        if (null != this.m_children) {
            int size = this.m_children.size();
            int i = 0;
            while (i < size) {
                Configuration configuration = (Configuration)this.m_children.get(i);
                if (name.equals(configuration.getName())) {
                    return configuration;
                }
                ++i;
            }
        }
        if (createNew) {
            return new DefaultConfiguration(name, "-");
        }
        return null;
    }

    public Configuration[] getChildren(String name) {
        if (null == this.m_children) {
            return new Configuration[0];
        }
        ArrayList<Configuration> children = new ArrayList<Configuration>();
        int size = this.m_children.size();
        int i = 0;
        while (i < size) {
            Configuration configuration = (Configuration)this.m_children.get(i);
            if (name.equals(configuration.getName())) {
                children.add(configuration);
            }
            ++i;
        }
        return children.toArray(new Configuration[0]);
    }

    public void appendValueData(String value) {
        this.checkWriteable();
        this.m_value = null == this.m_value ? value : this.m_value + value;
    }

    public void setValue(String value) {
        this.checkWriteable();
        this.m_value = value;
    }

    public void setAttribute(String name, String value) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(name, value);
    }

    public String addAttribute(String name, String value) {
        this.checkWriteable();
        if (null == this.m_attributes) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes.put(name, value);
    }

    public void addChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(configuration);
    }

    public void removeChild(Configuration configuration) {
        this.checkWriteable();
        if (null == this.m_children) {
            return;
        }
        ((AbstractCollection)this.m_children).remove(configuration);
    }

    public int getChildCount() {
        if (null == this.m_children) {
            return 0;
        }
        return this.m_children.size();
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Configuration is read only and can not be modified");
        }
    }
}

