/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.rasterizer;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;

public class Main {
    public static void writeImage(Transcoder transcoder, String string, String string2) {
        try {
            System.out.println("Converting " + string + " to " + string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            transcoder.transcode(new TranscoderInput(string), new TranscoderOutput(bufferedOutputStream));
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error while writing " + string + " to " + string2);
        }
    }

    public static void error(String string) {
        System.err.println(string);
    }

    public static void usage(PrintStream printStream) {
        printStream.println("usage: rasterizer [options] [@files]");
        printStream.println("-d <directory>   Destination directory for output files");
        printStream.println("-m <mimetype>    Mime type for output files");
        printStream.println("-w <width>       Width of the output image");
        printStream.println("-h <height>      Height of the output image");
        printStream.println("-bg <color>      Background color (a.r.g.b decimal notation) for the output image. White is the default");
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        String string = "image/png";
        String string2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        float f = Float.NaN;
        float f2 = Float.NaN;
        Object object4 = Color.white;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                if (n + 1 < stringArray.length) {
                    int n2 = ++n;
                    ++n;
                    string2 = stringArray[n2];
                    continue;
                }
                Main.error("option -d requires an argument");
                Main.usage(System.err);
                System.exit(1);
                continue;
            }
            if (stringArray[n].equals("-m")) {
                if (n + 1 < stringArray.length) {
                    int n3 = ++n;
                    ++n;
                    string = stringArray[n3];
                    continue;
                }
                Main.error("option -m requires an argument");
                Main.usage(System.err);
                System.exit(1);
                continue;
            }
            if (stringArray[n].equals("-w")) {
                if (n + 1 < stringArray.length) {
                    ++n;
                    try {
                        f = Float.parseFloat(stringArray[n++]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Main.usage(System.err);
                        System.exit(1);
                    }
                    continue;
                }
                Main.error("option -w requires an argument");
                Main.usage(System.err);
                System.exit(1);
                continue;
            }
            if (stringArray[n].equals("-bg")) {
                if (n + 1 < stringArray.length) {
                    int n4 = ++n;
                    ++n;
                    object3 = stringArray[n4];
                    object2 = Main.parseARGB((String)object3);
                    if (object2 == null) {
                        Main.usage(System.err);
                        System.exit(1);
                    }
                    object4 = object2;
                    continue;
                }
                Main.error("option -w requires an argument");
                Main.usage(System.err);
                System.exit(1);
                continue;
            }
            if (stringArray[n].equals("-h")) {
                if (n + 1 < stringArray.length) {
                    ++n;
                    try {
                        f = Float.parseFloat(stringArray[n++]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Main.usage(System.err);
                        System.exit(1);
                    }
                    continue;
                }
                Main.error("option -h requires an argument");
                Main.usage(System.err);
                System.exit(1);
                continue;
            }
            if (stringArray[n].equals("-help")) {
                Main.usage(System.out);
                System.exit(0);
                continue;
            }
            linkedList.add(stringArray[n++]);
        }
        object3 = null;
        if (string.equals("image/jpg") || string.equals("image/jpeg") || string.equals("image/jpe")) {
            object3 = new JPEGTranscoder();
        } else if (string.equals("image/png")) {
            object3 = new PNGTranscoder();
        } else if (string.equals("application/pdf")) {
            try {
                object2 = Class.forName("org.apache.fop.svg.PDFTranscoder");
                object = ((Class)object2).newInstance();
                object3 = (Transcoder)object;
            }
            catch (Exception exception) {
                object3 = null;
                Main.error("PDF transcoder could not be loaded");
            }
        } else if (string.equals("image/tiff")) {
            object3 = new TIFFTranscoder();
        }
        if (object3 == null) {
            Main.error("No transcoder found for mime type : " + string);
            System.exit(1);
        }
        if (!Float.isNaN(f)) {
            object3.addTranscodingHint(ImageTranscoder.KEY_WIDTH, new Float(f));
        }
        if (!Float.isNaN(f2)) {
            object3.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, new Float(f2));
        }
        object3.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, object4);
        object2 = linkedList.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            URL uRL = Main.getSVGURL(object);
            if (uRL == null) continue;
            String string3 = uRL.getFile();
            int n5 = string3.lastIndexOf(47);
            if (n5 > 0) {
                string3 = string3.substring(n5);
            }
            if (string3.endsWith(".svg")) {
                string3 = string3.substring(0, string3.lastIndexOf(".svg"));
                int n6 = string.lastIndexOf(47);
                if (n6 > 0) {
                    String string4 = string.substring(n6 + 1);
                    if (string4.length() > 0) {
                        string3 = string3 + "." + string4;
                    }
                } else {
                    string3 = string3 + "." + string;
                }
            }
            if (string2 == null) {
                string2 = Main.getDirectory(object);
            }
            if (string2 != null) {
                File file = new File(string2, string3);
                Main.writeImage((Transcoder)object3, uRL.toString(), file.getAbsolutePath());
                continue;
            }
            Main.error("No valid output directory for : " + object);
        }
        System.exit(0);
    }

    public static URL getSVGURL(String string) {
        URL uRL = null;
        try {
            File file = new File(string);
            uRL = file.exists() ? file.toURL() : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Main.error("Bad svg file: " + string);
        }
        return uRL;
    }

    public static String getDirectory(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.getParent();
        }
        return null;
    }

    public static Color parseARGB(String string) {
        StringTokenizer stringTokenizer;
        Color color = null;
        if (string != null && (stringTokenizer = new StringTokenizer(string, ".")).countTokens() == 4) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            int n = -1;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            try {
                n = Integer.parseInt(string2);
                n2 = Integer.parseInt(string3);
                n3 = Integer.parseInt(string4);
                n4 = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n >= 0 && n <= 255 && n2 >= 0 && n2 <= 255 && n3 >= 0 && n3 <= 255 && n4 >= 0 && n4 <= 255) {
                color = new Color(n2, n3, n4, n);
            }
        }
        return color;
    }
}

