/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.batik.gvt.GVTTreeWalker;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class FindDialog
extends JDialog
implements ActionMap {
    protected static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.FindDialog";
    public static final String NEXT_ACTION = "NextButtonAction";
    public static final String PREVIOUS_ACTION = "PreviousButtonAction";
    public static final String CLOSE_ACTION = "CloseButtonAction";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.FindDialog", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected ButtonFactory buttonFactory;
    protected GraphicsNode gvtRoot;
    protected GVTTreeWalker walker;
    protected JTextField search;
    protected JButton next;
    protected JButton previous;
    protected JButton close;
    protected JCheckBox caseSensitive;
    protected JCheckBox enableZoom;
    protected JSVGCanvas svgCanvas;
    protected Map listeners = new HashMap(10);

    public FindDialog(JSVGCanvas jSVGCanvas) {
        this(null, jSVGCanvas);
    }

    public FindDialog(Frame frame, JSVGCanvas jSVGCanvas) {
        super(frame, resources.getString("Dialog.title"));
        this.svgCanvas = jSVGCanvas;
        this.buttonFactory = new ButtonFactory(bundle, this);
        this.listeners.put(NEXT_ACTION, new NextButtonAction());
        this.listeners.put(PREVIOUS_ACTION, new PreviousButtonAction());
        this.listeners.put(CLOSE_ACTION, new CloseButtonAction());
        this.getContentPane().add((Component)this.createFindPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
    }

    protected JPanel createFindPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("Panel.title")));
        ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
        extendedGridBagConstraints.insets = new Insets(2, 2, 2, 2);
        extendedGridBagConstraints.anchor = 13;
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.setWeight(0.0, 0.0);
        extendedGridBagConstraints.setGridBounds(0, 0, 1, 1);
        jPanel.add((Component)new JLabel(resources.getString("FindLabel.text")), extendedGridBagConstraints);
        extendedGridBagConstraints.fill = 2;
        extendedGridBagConstraints.setWeight(1.0, 0.0);
        extendedGridBagConstraints.setGridBounds(1, 0, 2, 1);
        this.search = new JTextField(20);
        jPanel.add((Component)this.search, extendedGridBagConstraints);
        this.search.getDocument().addDocumentListener(new TextTracker());
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.anchor = 17;
        extendedGridBagConstraints.setWeight(0.0, 0.0);
        extendedGridBagConstraints.setGridBounds(1, 1, 1, 1);
        this.caseSensitive = this.buttonFactory.createJCheckBox("CaseSensitiveCheckBox");
        jPanel.add((Component)this.caseSensitive, extendedGridBagConstraints);
        extendedGridBagConstraints.fill = 0;
        extendedGridBagConstraints.anchor = 17;
        extendedGridBagConstraints.setWeight(0.0, 0.0);
        extendedGridBagConstraints.setGridBounds(2, 1, 1, 1);
        this.enableZoom = this.buttonFactory.createJCheckBox("EnableZoomCheckBox");
        jPanel.add((Component)this.enableZoom, extendedGridBagConstraints);
        return jPanel;
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.next = this.buttonFactory.createJButton("NextButton");
        jPanel.add(this.next);
        this.previous = this.buttonFactory.createJButton("PreviousButton");
        jPanel.add(this.previous);
        this.close = this.buttonFactory.createJButton("CloseButton");
        jPanel.add(this.close);
        this.updateButtonState();
        return jPanel;
    }

    public void setGraphicsNode(GraphicsNode graphicsNode) {
        this.gvtRoot = graphicsNode;
        this.walker = graphicsNode != null ? new GVTTreeWalker(graphicsNode) : null;
        this.updateButtonState();
    }

    protected GraphicsNode getNext(String string) {
        GraphicsNode graphicsNode = this.walker.nextGraphicsNode();
        while (graphicsNode != null && !this.match(graphicsNode, string)) {
            graphicsNode = this.walker.nextGraphicsNode();
        }
        return graphicsNode;
    }

    protected GraphicsNode getPrevious(String string) {
        GraphicsNode graphicsNode = this.walker.previousGraphicsNode();
        while (graphicsNode != null && !this.match(graphicsNode, string)) {
            graphicsNode = this.walker.previousGraphicsNode();
        }
        return graphicsNode;
    }

    protected boolean match(GraphicsNode graphicsNode, String string) {
        if (!(graphicsNode instanceof TextNode) || !graphicsNode.isVisible() || string == null || string.length() == 0) {
            return false;
        }
        String string2 = ((TextNode)graphicsNode).getText();
        if (!this.caseSensitive.isSelected()) {
            string2 = string2.toLowerCase();
            string = string.toLowerCase();
        }
        return string2.startsWith(string);
    }

    private void updateButtonState() {
        boolean bl = this.gvtRoot != null;
        String string = this.search.getText();
        boolean bl2 = string != null && string.length() > 0;
        this.next.setEnabled(bl && bl2);
        this.previous.setEnabled(bl && bl2);
        this.search.setEnabled(bl);
    }

    protected void showSelectedGraphicsNode() {
        GraphicsNode graphicsNode = this.walker.getCurrentGraphicsNode();
        if (!(graphicsNode instanceof TextNode)) {
            return;
        }
        System.out.println(((TextNode)graphicsNode).getText());
        if (this.enableZoom.isSelected()) {
            Rectangle2D rectangle2D = graphicsNode.getBounds();
            rectangle2D = graphicsNode.getGlobalTransform().createTransformedShape(rectangle2D).getBounds();
            Dimension dimension = this.svgCanvas.getSize();
            AffineTransform affineTransform = new AffineTransform();
            double d = Math.min((double)dimension.width / rectangle2D.getWidth(), (double)dimension.height / rectangle2D.getHeight());
            affineTransform.scale(d * 0.8, d * 0.8);
            affineTransform.translate(-rectangle2D.getX(), -rectangle2D.getY());
            this.svgCanvas.setRenderingTransform(affineTransform);
        }
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    protected class TextTracker
    implements DocumentListener {
        protected TextTracker() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            FindDialog.this.updateButtonState();
            String string = FindDialog.this.search.getText();
            if (!FindDialog.this.match(FindDialog.this.walker.getCurrentGraphicsNode(), string)) {
                GraphicsNode graphicsNode = FindDialog.this.getNext(string);
                if (graphicsNode != null) {
                    FindDialog.this.previous.setEnabled(true);
                    FindDialog.this.showSelectedGraphicsNode();
                } else {
                    FindDialog.this.next.setEnabled(false);
                }
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FindDialog.this.updateButtonState();
            GraphicsNode graphicsNode = FindDialog.this.getPrevious(FindDialog.this.search.getText());
            if (graphicsNode != null) {
                FindDialog.this.next.setEnabled(true);
                FindDialog.this.showSelectedGraphicsNode();
            } else {
                FindDialog.this.previous.setEnabled(false);
            }
        }
    }

    protected class CloseButtonAction
    extends AbstractAction {
        protected CloseButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FindDialog.this.dispose();
        }
    }

    protected class PreviousButtonAction
    extends AbstractAction {
        protected PreviousButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicsNode graphicsNode = FindDialog.this.getPrevious(FindDialog.this.search.getText());
            if (graphicsNode != null) {
                FindDialog.this.next.setEnabled(true);
                FindDialog.this.showSelectedGraphicsNode();
            } else {
                FindDialog.this.previous.setEnabled(false);
            }
        }
    }

    protected class NextButtonAction
    extends AbstractAction {
        protected NextButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GraphicsNode graphicsNode = FindDialog.this.getNext(FindDialog.this.search.getText());
            if (graphicsNode != null) {
                FindDialog.this.previous.setEnabled(true);
                FindDialog.this.showSelectedGraphicsNode();
            } else {
                FindDialog.this.next.setEnabled(false);
            }
        }
    }
}

