/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.batik.apps.svgbrowser.Application;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;
import org.apache.batik.apps.svgbrowser.PreferenceDialog;
import org.apache.batik.apps.svgbrowser.XMLPreferenceManager;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.util.PreferenceManager;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.batik.util.gui.resource.ResourceManager;

public class Main
implements Application {
    public static final String CSS_PARSER_CLASS_NAME_KEY = "org.w3c.css.sac.parser";
    public static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.Main";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.Main", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected static ImageIcon frameIcon = new ImageIcon((class$org$apache$batik$apps$svgbrowser$Main == null ? (class$org$apache$batik$apps$svgbrowser$Main = Main.class$("org.apache.batik.apps.svgbrowser.Main")) : class$org$apache$batik$apps$svgbrowser$Main).getResource(resources.getString("Frame.icon")));
    protected XMLPreferenceManager preferenceManager;
    protected String[] arguments;
    protected Map handlers = new HashMap();
    protected List viewerFrames;
    protected PreferenceDialog preferenceDialog;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$Main;

    public static void main(String[] stringArray) {
        new Main(stringArray).run();
    }

    public Main(String[] stringArray) {
        this.handlers.put("-font-size", new FontSizeHandler());
        this.viewerFrames = new LinkedList();
        this.arguments = stringArray;
        CSSDocumentHandler.setParserClassName(resources.getString(CSS_PARSER_CLASS_NAME_KEY));
        HashMap<String, Object> hashMap = new HashMap<String, Object>(11);
        hashMap.put("preference.key.languages", Locale.getDefault().getLanguage());
        hashMap.put("preference.key.show.rendering", Boolean.FALSE);
        hashMap.put("preference.key.auto.adjust.window", Boolean.TRUE);
        hashMap.put("preference.key.enable.double.buffering", Boolean.TRUE);
        hashMap.put("preference.key.show.debug.trace", Boolean.FALSE);
        hashMap.put("preference.key.proxy.host", "");
        hashMap.put("preference.key.proxy.port", "");
        try {
            this.preferenceManager = new XMLPreferenceManager("preferences.xml", hashMap);
            String string = System.getProperty("user.home");
            File file = new File(string, ".batik");
            file.mkdir();
            PreferenceManager.setPreferenceDirectory(file.getCanonicalPath());
            this.preferenceManager.load();
            this.setPreferences();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            Object object;
            int n = 0;
            while (n < this.arguments.length) {
                object = (OptionHandler)this.handlers.get(this.arguments[n]);
                if (object == null) break;
                n = object.handleOption(n);
                ++n;
            }
            object = this.createAndShowJSVGViewerFrame();
            while (n < this.arguments.length) {
                if (this.arguments[n].length() == 0) {
                    ++n;
                    continue;
                }
                File file = new File(this.arguments[n]);
                String string = null;
                try {
                    if (file.canRead()) {
                        string = file.toURL().toString();
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (string == null) {
                    string = this.arguments[n];
                    URL uRL = null;
                    try {
                        uRL = new URL(this.arguments[n]);
                    }
                    catch (MalformedURLException malformedURLException) {
                        string = null;
                    }
                }
                if (string != null) {
                    if (object == null) {
                        object = this.createAndShowJSVGViewerFrame();
                    }
                    ((JSVGViewerFrame)object).getJSVGCanvas().loadSVGDocument(string);
                    object = null;
                } else {
                    JOptionPane.showMessageDialog((Component)object, resources.getString("Error.skipping.file") + this.arguments[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printUsage();
        }
    }

    protected void printUsage() {
        System.out.println();
        System.out.println(resources.getString("Command.header"));
        System.out.println(resources.getString("Command.syntax"));
        System.out.println();
        System.out.println(resources.getString("Command.options"));
        Iterator iterator = this.handlers.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println(((OptionHandler)this.handlers.get(string)).getDescription());
        }
    }

    public JSVGViewerFrame createAndShowJSVGViewerFrame() {
        JSVGViewerFrame jSVGViewerFrame = new JSVGViewerFrame(this);
        ((Component)jSVGViewerFrame).setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        ((Frame)jSVGViewerFrame).setIconImage(frameIcon.getImage());
        jSVGViewerFrame.setTitle(resources.getString("Frame.title"));
        jSVGViewerFrame.show();
        this.viewerFrames.add(jSVGViewerFrame);
        this.setPreferences(jSVGViewerFrame);
        return jSVGViewerFrame;
    }

    public void closeJSVGViewerFrame(JSVGViewerFrame jSVGViewerFrame) {
        this.viewerFrames.remove(jSVGViewerFrame);
        if (this.viewerFrames.size() == 0) {
            System.exit(0);
        }
        ((Component)jSVGViewerFrame).setVisible(false);
    }

    public Action createExitAction(JSVGViewerFrame jSVGViewerFrame) {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        };
    }

    public void openLink(String string) {
        JSVGViewerFrame jSVGViewerFrame = this.createAndShowJSVGViewerFrame();
        jSVGViewerFrame.getJSVGCanvas().loadSVGDocument(string);
    }

    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    public void showPreferenceDialog(JSVGViewerFrame jSVGViewerFrame) {
        if (this.preferenceDialog == null) {
            this.preferenceDialog = new PreferenceDialog(this.preferenceManager);
        }
        if (this.preferenceDialog.showDialog() == 0) {
            try {
                this.preferenceManager.save();
                this.setPreferences();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setPreferences() {
        Iterator iterator = this.viewerFrames.iterator();
        while (iterator.hasNext()) {
            this.setPreferences((JSVGViewerFrame)iterator.next());
        }
        System.setProperty("proxyHost", this.preferenceManager.getString("preference.key.proxy.host"));
        System.setProperty("proxyPort", this.preferenceManager.getString("preference.key.proxy.port"));
    }

    private void setPreferences(JSVGViewerFrame jSVGViewerFrame) {
        boolean bl = this.preferenceManager.getBoolean("preference.key.enable.double.buffering");
        jSVGViewerFrame.getJSVGCanvas().setDoubleBufferedRendering(bl);
        boolean bl2 = this.preferenceManager.getBoolean("preference.key.show.rendering");
        jSVGViewerFrame.getJSVGCanvas().setProgressivePaint(bl2);
        boolean bl3 = this.preferenceManager.getBoolean("preference.key.show.debug.trace");
        jSVGViewerFrame.setDebug(bl3);
        boolean bl4 = this.preferenceManager.getBoolean("preference.key.auto.adjust.window");
        jSVGViewerFrame.setAutoAdjust(bl4);
    }

    public String getLanguages() {
        if (this.preferenceDialog == null) {
            return Locale.getDefault().getLanguage();
        }
        return this.preferenceDialog.getPreferenceManager().getString("preference.key.languages");
    }

    public String getUserStyleSheetURI() {
        if (this.preferenceDialog == null) {
            return null;
        }
        return this.preferenceDialog.getPreferenceManager().getString("preference.key.user.stylesheet");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class FontSizeHandler
    implements OptionHandler {
        protected FontSizeHandler() {
        }

        public int handleOption(int n) {
            int n2 = Integer.parseInt(Main.this.arguments[++n]);
            Font font = new Font("Dialog", 0, n2);
            FontUIResource fontUIResource = new FontUIResource(font);
            UIManager.put("CheckBox.font", fontUIResource);
            UIManager.put("PopupMenu.font", fontUIResource);
            UIManager.put("TextPane.font", fontUIResource);
            UIManager.put("MenuItem.font", fontUIResource);
            UIManager.put("ComboBox.font", fontUIResource);
            UIManager.put("Button.font", fontUIResource);
            UIManager.put("Tree.font", fontUIResource);
            UIManager.put("ScrollPane.font", fontUIResource);
            UIManager.put("TabbedPane.font", fontUIResource);
            UIManager.put("EditorPane.font", fontUIResource);
            UIManager.put("TitledBorder.font", fontUIResource);
            UIManager.put("Menu.font", fontUIResource);
            UIManager.put("TextArea.font", fontUIResource);
            UIManager.put("OptionPane.font", fontUIResource);
            UIManager.put("DesktopIcon.font", fontUIResource);
            UIManager.put("MenuBar.font", fontUIResource);
            UIManager.put("ToolBar.font", fontUIResource);
            UIManager.put("RadioButton.font", fontUIResource);
            UIManager.put("ToggleButton.font", fontUIResource);
            UIManager.put("ToolTip.font", fontUIResource);
            UIManager.put("ProgressBar.font", fontUIResource);
            UIManager.put("TableHeader.font", fontUIResource);
            UIManager.put("Panel.font", fontUIResource);
            UIManager.put("List.font", fontUIResource);
            UIManager.put("ColorChooser.font", fontUIResource);
            UIManager.put("PasswordField.font", fontUIResource);
            UIManager.put("TextField.font", fontUIResource);
            UIManager.put("Table.font", fontUIResource);
            UIManager.put("Label.font", fontUIResource);
            UIManager.put("InternalFrameTitlePane.font", fontUIResource);
            UIManager.put("CheckBoxMenuItem.font", fontUIResource);
            return n;
        }

        public String getDescription() {
            return resources.getString("Command.font-size");
        }
    }

    protected static interface OptionHandler {
        public int handleOption(int var1);

        public String getDescription();
    }
}

