/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGAElement;

public class SVGAElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "a";
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
        EventTarget eventTarget = (EventTarget)((Object)element);
        eventTarget.addEventListener("click", new AnchorListener(bridgeContext.getUserAgent()), false);
        eventTarget.addEventListener("mouseover", new CursorMouseOverListener(bridgeContext.getUserAgent()), false);
        eventTarget.addEventListener("mouseout", new CursorMouseOutListener(bridgeContext.getUserAgent()), false);
    }

    public boolean isComposite() {
        return true;
    }

    protected static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOutListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            SVGAElement sVGAElement = null;
            Element element = (Element)((Object)event.getTarget());
            while (element != null) {
                if (element instanceof SVGAElement) {
                    sVGAElement = (SVGAElement)element;
                    break;
                }
                element = HiddenChildElementSupport.getParentElement(element);
            }
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.displayMessage("");
        }
    }

    protected static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOverListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            SVGAElement sVGAElement = null;
            Element element = (Element)((Object)event.getTarget());
            while (element != null) {
                if (element instanceof SVGAElement) {
                    sVGAElement = (SVGAElement)element;
                    break;
                }
                element = HiddenChildElementSupport.getParentElement(element);
            }
            Cursor cursor = Cursor.getPredefinedCursor(12);
            this.userAgent.setSVGCursor(cursor);
            if (sVGAElement != null) {
                String string = XLinkSupport.getXLinkHref(sVGAElement);
                this.userAgent.displayMessage(string);
            }
        }
    }

    protected static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;

        public AnchorListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            SVGAElement sVGAElement = null;
            Element element = (Element)((Object)event.getTarget());
            while (element != null) {
                if (element instanceof SVGAElement) {
                    sVGAElement = (SVGAElement)element;
                    break;
                }
                element = HiddenChildElementSupport.getParentElement(element);
            }
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.openLink(sVGAElement);
        }
    }
}

