/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGGElementBridge
extends AbstractGraphicsNodeBridge {
    public String getLocalName() {
        return "g";
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        UnitProcessor.Context context;
        Rectangle2D rectangle2D;
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)super.createGraphicsNode(bridgeContext, element);
        Map map = CSSUtilities.convertColorRendering(element);
        if (map != null) {
            compositeGraphicsNode.setRenderingHints(new RenderingHints(map));
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground(element, context = UnitProcessor.createContext(bridgeContext, element))) != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        return compositeGraphicsNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new CompositeGraphicsNode();
    }

    public boolean isComposite() {
        return true;
    }
}

