/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.StringReader;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class UnitProcessor {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;

    protected UnitProcessor() {
    }

    public static Context createContext(BridgeContext bridgeContext, Element element) {
        return new DefaultContext(bridgeContext, element);
    }

    public static float svgHorizontalCoordinateToObjectBoundingBox(String string, String string2, Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)2, context);
    }

    public static float svgVerticalCoordinateToObjectBoundingBox(String string, String string2, Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)1, context);
    }

    public static float svgOtherCoordinateToObjectBoundingBox(String string, String string2, Context context) {
        return UnitProcessor.svgToObjectBoundingBox(string, string2, (short)0, context);
    }

    public static float svgHorizontalLengthToObjectBoundingBox(String string, String string2, Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)2, context);
    }

    public static float svgVerticalLengthToObjectBoundingBox(String string, String string2, Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)1, context);
    }

    public static float svgOtherLengthToObjectBoundingBox(String string, String string2, Context context) {
        return UnitProcessor.svgLengthToObjectBoundingBox(string, string2, (short)0, context);
    }

    public static float svgLengthToObjectBoundingBox(String string, String string2, short s, Context context) {
        float f = UnitProcessor.svgToObjectBoundingBox(string, string2, s, context);
        if (f < 0.0f) {
            throw new BridgeException(context.getElement(), "length.negative", new Object[]{string2, string});
        }
        return f;
    }

    public static float svgToObjectBoundingBox(String string, String string2, short s, Context context) {
        try {
            LengthParser lengthParser = new LengthParser();
            UnitResolver unitResolver = new UnitResolver();
            lengthParser.setLengthHandler(unitResolver);
            lengthParser.parse(new StringReader(string));
            return UnitProcessor.svgToObjectBoundingBox(unitResolver.value, unitResolver.unit, s, context);
        }
        catch (ParseException parseException) {
            throw new BridgeException(context.getElement(), "attribute.malformed", new Object[]{string2, string, parseException});
        }
    }

    public static float svgToObjectBoundingBox(float f, short s, short s2, Context context) {
        switch (s) {
            case 1: {
                return f;
            }
            case 2: {
                return f / 100.0f;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return UnitProcessor.svgToUserSpace(f, s, s2, context);
            }
        }
        throw new Error();
    }

    public static float svgHorizontalLengthToUserSpace(String string, String string2, Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)2, context);
    }

    public static float svgVerticalLengthToUserSpace(String string, String string2, Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)1, context);
    }

    public static float svgOtherLengthToUserSpace(String string, String string2, Context context) {
        return UnitProcessor.svgLengthToUserSpace(string, string2, (short)0, context);
    }

    public static float svgHorizontalCoordinateToUserSpace(String string, String string2, Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)2, context);
    }

    public static float svgVerticalCoordinateToUserSpace(String string, String string2, Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)1, context);
    }

    public static float svgOtherCoordinateToUserSpace(String string, String string2, Context context) {
        return UnitProcessor.svgToUserSpace(string, string2, (short)0, context);
    }

    public static float svgLengthToUserSpace(String string, String string2, short s, Context context) {
        float f = UnitProcessor.svgToUserSpace(string, string2, s, context);
        if (f < 0.0f) {
            throw new BridgeException(context.getElement(), "length.negative", new Object[]{string2, string});
        }
        return f;
    }

    public static float svgToUserSpace(String string, String string2, short s, Context context) {
        try {
            LengthParser lengthParser = new LengthParser();
            UnitResolver unitResolver = new UnitResolver();
            lengthParser.setLengthHandler(unitResolver);
            lengthParser.parse(new StringReader(string));
            return UnitProcessor.svgToUserSpace(unitResolver.value, unitResolver.unit, s, context);
        }
        catch (ParseException parseException) {
            throw new BridgeException(context.getElement(), "attribute.malformed", new Object[]{string2, string, parseException});
        }
    }

    public static float svgToUserSpace(float f, short s, short s2, Context context) {
        switch (s) {
            case 1: 
            case 5: {
                return f;
            }
            case 7: {
                return f / context.getPixelToMM();
            }
            case 6: {
                return f * 10.0f / context.getPixelToMM();
            }
            case 8: {
                return f * 25.4f / context.getPixelToMM();
            }
            case 9: {
                return f * 25.4f / (72.0f * context.getPixelToMM());
            }
            case 10: {
                return f * 25.4f / (6.0f * context.getPixelToMM());
            }
            case 3: {
                return UnitProcessor.emsToPixels(f, s2, context);
            }
            case 4: {
                return UnitProcessor.exsToPixels(f, s2, context);
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(f, s2, context);
            }
        }
        throw new Error();
    }

    public static float userSpaceToSVG(float f, short s, short s2, Context context) {
        switch (s) {
            case 1: 
            case 5: {
                return f;
            }
            case 7: {
                return f * context.getPixelToMM();
            }
            case 6: {
                return f * context.getPixelToMM() / 10.0f;
            }
            case 8: {
                return f * context.getPixelToMM() / 25.4f;
            }
            case 9: {
                return f * (72.0f * context.getPixelToMM()) / 25.4f;
            }
            case 10: {
                return f * (6.0f * context.getPixelToMM()) / 25.4f;
            }
            case 3: {
                return UnitProcessor.pixelsToEms(f, s2, context);
            }
            case 4: {
                return UnitProcessor.pixelsToExs(f, s2, context);
            }
            case 2: {
                return UnitProcessor.pixelsToPercentages(f, s2, context);
            }
        }
        throw new Error();
    }

    public static float cssOtherCoordinateToUserSpace(CSSValue cSSValue, String string, Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        short s = cSSPrimitiveValue.getPrimitiveType();
        return UnitProcessor.cssToUserSpace(cSSPrimitiveValue.getFloatValue(s), s, (short)0, context);
    }

    public static float cssHorizontalCoordinateToUserSpace(CSSValue cSSValue, String string, Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        short s = cSSPrimitiveValue.getPrimitiveType();
        return UnitProcessor.cssToUserSpace(cSSPrimitiveValue.getFloatValue(s), s, (short)2, context);
    }

    public static float cssVerticalCoordinateToUserSpace(CSSValue cSSValue, String string, Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        short s = cSSPrimitiveValue.getPrimitiveType();
        return UnitProcessor.cssToUserSpace(cSSPrimitiveValue.getFloatValue(s), s, (short)1, context);
    }

    public static float cssOtherLengthToUserSpace(CSSValue cSSValue, String string, Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        short s = cSSPrimitiveValue.getPrimitiveType();
        return UnitProcessor.cssLengthToUserSpace(cSSPrimitiveValue.getFloatValue(s), string, s, (short)0, context);
    }

    public static float cssHorizontalLengthToUserSpace(CSSValue cSSValue, String string, Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        short s = cSSPrimitiveValue.getPrimitiveType();
        return UnitProcessor.cssLengthToUserSpace(cSSPrimitiveValue.getFloatValue(s), string, s, (short)2, context);
    }

    public static float cssVerticalLengthToUserSpace(CSSValue cSSValue, String string, Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
        short s = cSSPrimitiveValue.getPrimitiveType();
        return UnitProcessor.cssLengthToUserSpace(cSSPrimitiveValue.getFloatValue(s), string, s, (short)1, context);
    }

    public static float cssLengthToUserSpace(float f, String string, short s, short s2, Context context) {
        float f2 = UnitProcessor.cssToUserSpace(f, s, s2, context);
        if (f2 < 0.0f) {
            throw new BridgeException(context.getElement(), "css.length.negative", new Object[]{string});
        }
        return f2;
    }

    public static float cssToUserSpace(float f, short s, short s2, Context context) {
        switch (s) {
            case 1: 
            case 5: {
                return f;
            }
            case 7: {
                return f / context.getPixelToMM();
            }
            case 6: {
                return f * 10.0f / context.getPixelToMM();
            }
            case 8: {
                return f * 25.4f / context.getPixelToMM();
            }
            case 9: {
                return f * 25.4f / (72.0f * context.getPixelToMM());
            }
            case 10: {
                return f * 25.4f / (6.0f * context.getPixelToMM());
            }
            case 3: {
                return UnitProcessor.emsToPixels(f, s2, context);
            }
            case 4: {
                return UnitProcessor.exsToPixels(f, s2, context);
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(f, s2, context);
            }
        }
        throw new Error();
    }

    protected static float percentagesToPixels(float f, short s, Context context) {
        if (s == 2) {
            float f2 = context.getViewportWidth();
            return f2 * f / 100.0f;
        }
        if (s == 1) {
            float f3 = context.getViewportHeight();
            return f3 * f / 100.0f;
        }
        double d = context.getViewportWidth();
        double d2 = context.getViewportHeight();
        double d3 = Math.sqrt(d * d + d2 * d2) / Math.sqrt(2.0);
        return (float)(d3 * (double)f / 100.0);
    }

    protected static float pixelsToPercentages(float f, short s, Context context) {
        if (s == 2) {
            float f2 = context.getViewportWidth();
            return f * 100.0f / f2;
        }
        if (s == 1) {
            float f3 = context.getViewportHeight();
            return f * 100.0f / f3;
        }
        double d = context.getViewportWidth();
        double d2 = context.getViewportHeight();
        double d3 = Math.sqrt(d * d + d2 * d2) / Math.sqrt(2.0);
        return (float)((double)f * 100.0 / d3);
    }

    protected static float pixelsToEms(float f, short s, Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = context.getFontSize();
        short s2 = cSSPrimitiveValue.getPrimitiveType();
        switch (s2) {
            case 21: {
                float f2 = context.getMediumFontSize();
                f2 = TextUtilities.parseFontSize(cSSPrimitiveValue.getStringValue(), f2);
                return f / UnitProcessor.cssToUserSpace(f2, (short)9, s, context);
            }
        }
        return f / UnitProcessor.cssToUserSpace(cSSPrimitiveValue.getFloatValue(s2), s2, s, context);
    }

    protected static float emsToPixels(float f, short s, Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = context.getFontSize();
        short s2 = cSSPrimitiveValue.getPrimitiveType();
        switch (s2) {
            case 21: {
                float f2 = context.getMediumFontSize();
                f2 = TextUtilities.parseFontSize(cSSPrimitiveValue.getStringValue(), f2);
                return f * UnitProcessor.cssToUserSpace(f2, (short)9, s, context);
            }
        }
        return f * UnitProcessor.cssToUserSpace(cSSPrimitiveValue.getFloatValue(s2), s2, s, context);
    }

    protected static float pixelsToExs(float f, short s, Context context) {
        float f2;
        CSSPrimitiveValue cSSPrimitiveValue = context.getFontSize();
        short s2 = cSSPrimitiveValue.getPrimitiveType();
        switch (s2) {
            case 21: {
                float f3 = context.getMediumFontSize();
                f3 = TextUtilities.parseFontSize(cSSPrimitiveValue.getStringValue(), f3);
                f2 = UnitProcessor.cssToUserSpace(f3, (short)9, s, context);
                break;
            }
            default: {
                f2 = UnitProcessor.cssToUserSpace(cSSPrimitiveValue.getFloatValue(s2), s2, s, context);
            }
        }
        float f4 = context.getXHeight();
        return f / f4 / f2;
    }

    protected static float exsToPixels(float f, short s, Context context) {
        float f2;
        CSSPrimitiveValue cSSPrimitiveValue = context.getFontSize();
        short s2 = cSSPrimitiveValue.getPrimitiveType();
        switch (s2) {
            case 21: {
                float f3 = context.getMediumFontSize();
                f3 = TextUtilities.parseFontSize(cSSPrimitiveValue.getStringValue(), f3);
                f2 = UnitProcessor.cssToUserSpace(f3, (short)9, s, context);
                break;
            }
            default: {
                f2 = UnitProcessor.cssToUserSpace(cSSPrimitiveValue.getFloatValue(s2), s2, s, context);
            }
        }
        float f4 = context.getXHeight();
        return f * f4 * f2;
    }

    public static class DefaultContext
    implements Context {
        protected Element e;
        protected BridgeContext ctx;

        public DefaultContext(BridgeContext bridgeContext, Element element) {
            this.ctx = bridgeContext;
            this.e = element;
        }

        public Element getElement() {
            return this.e;
        }

        public float getPixelToMM() {
            return this.ctx.getUserAgent().getPixelToMM();
        }

        public float getMediumFontSize() {
            return 9.0f;
        }

        public CSSPrimitiveValue getFontSize() {
            return CSSUtilities.getComputedStyle(this.e).getPropertyCSSValueInternal("font-size");
        }

        public float getXHeight() {
            return 0.5f;
        }

        public float getViewportWidth() {
            return this.ctx.getViewport(this.e).getWidth();
        }

        public float getViewportHeight() {
            return this.ctx.getViewport(this.e).getHeight();
        }
    }

    public static interface Context {
        public Element getElement();

        public float getPixelToMM();

        public float getMediumFontSize();

        public CSSPrimitiveValue getFontSize();

        public float getXHeight();

        public float getViewportWidth();

        public float getViewportHeight();
    }

    public static class UnitResolver
    implements LengthHandler {
        public float value;
        public short unit = 1;

        public void startLength() throws ParseException {
        }

        public void lengthValue(float f) throws ParseException {
            this.value = f;
        }

        public void em() throws ParseException {
            this.unit = (short)3;
        }

        public void ex() throws ParseException {
            this.unit = (short)4;
        }

        public void in() throws ParseException {
            this.unit = (short)8;
        }

        public void cm() throws ParseException {
            this.unit = (short)6;
        }

        public void mm() throws ParseException {
            this.unit = (short)7;
        }

        public void pc() throws ParseException {
            this.unit = (short)10;
        }

        public void pt() throws ParseException {
            this.unit = (short)9;
        }

        public void px() throws ParseException {
            this.unit = (short)5;
        }

        public void percentage() throws ParseException {
            this.unit = (short)2;
        }

        public void endLength() throws ParseException {
        }
    }
}

