/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.CSSOMRuleList;
import org.apache.batik.css.CSSOMStyleRule;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.DOMMediaList;
import org.apache.batik.css.ElementNonCSSPresentationalHints;
import org.apache.batik.css.ExtendedElementCSSInlineStyle;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.css.sac.ExtendedSelector;
import org.apache.batik.css.value.ImmutableInherit;
import org.apache.batik.css.value.RelativeValueResolver;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ElementCSSInlineStyle;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.views.DocumentView;

public abstract class AbstractViewCSS
implements ViewCSS {
    protected DocumentView document;
    protected ComputedStyleCache styles = new ComputedStyleCache();
    protected MediaList media;
    protected CSSStyleSheet userAgentStyleSheet;
    protected CSSStyleSheet userStyleSheet;
    protected List relativeValueResolvers = new LinkedList();

    protected AbstractViewCSS(DocumentView documentView) {
        this.document = documentView;
    }

    public DocumentView getDocument() {
        return this.document;
    }

    public CSSStyleDeclaration getComputedStyle(Element element, String string) {
        return this.getComputedStyleInternal(element, string);
    }

    public CSSOMReadOnlyStyleDeclaration getComputedStyleInternal(Element element, String string) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = this.styles.get(element, string = string == null ? "" : string);
        if (cSSOMReadOnlyStyleDeclaration == null) {
            cSSOMReadOnlyStyleDeclaration = this.computeStyle(element, string);
            this.styles.put(element, string, cSSOMReadOnlyStyleDeclaration);
        }
        return cSSOMReadOnlyStyleDeclaration;
    }

    public void setComputedStyle(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        string = string == null ? "" : string;
        cSSOMReadOnlyStyleDeclaration.setContext(this, element);
        this.styles.putPermanent(element, string, cSSOMReadOnlyStyleDeclaration);
    }

    public void dispose() {
        this.styles.dispose();
    }

    public void setMedia(String string) {
        this.media = new DOMMediaList(string);
    }

    public void setUserAgentStyleSheet(CSSStyleSheet cSSStyleSheet) {
        this.userAgentStyleSheet = cSSStyleSheet;
    }

    public void setUserStyleSheet(CSSStyleSheet cSSStyleSheet) {
        this.userStyleSheet = cSSStyleSheet;
    }

    protected void addRelativeValueResolver(RelativeValueResolver relativeValueResolver) {
        this.relativeValueResolvers.add(relativeValueResolver);
    }

    public CSSOMReadOnlyStyleDeclaration computeStyle(Element element, String string) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = this.getCascadedStyle(element, string);
        this.computeRelativeValues(element, string, cSSOMReadOnlyStyleDeclaration);
        return cSSOMReadOnlyStyleDeclaration;
    }

    public CSSOMReadOnlyStyleDeclaration getCascadedStyle(Element element, String string) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = new CSSOMReadOnlyStyleDeclaration(this, element);
        this.addUserAgentProperties(element, string, cSSOMReadOnlyStyleDeclaration);
        this.addUserProperties(element, string, cSSOMReadOnlyStyleDeclaration);
        this.addNonCSSPresentationalHints(element, string, cSSOMReadOnlyStyleDeclaration);
        this.addAuthorStyleSheetProperties(element, string, cSSOMReadOnlyStyleDeclaration);
        this.addInlineStyleProperties(element, string, cSSOMReadOnlyStyleDeclaration);
        this.addOverrideStyleProperties(element, string, cSSOMReadOnlyStyleDeclaration);
        return cSSOMReadOnlyStyleDeclaration;
    }

    protected void computeRelativeValues(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        Iterator iterator = this.relativeValueResolvers.iterator();
        while (iterator.hasNext()) {
            RelativeValueResolver relativeValueResolver = (RelativeValueResolver)iterator.next();
            String string2 = relativeValueResolver.getPropertyName();
            CSSOMReadOnlyValue cSSOMReadOnlyValue = (CSSOMReadOnlyValue)cSSOMReadOnlyStyleDeclaration.getLocalPropertyCSSValue(string2);
            String string3 = cSSOMReadOnlyStyleDeclaration.getLocalPropertyPriority(string2);
            int n = cSSOMReadOnlyStyleDeclaration.getLocalPropertyOrigin(string2);
            if (!(cSSOMReadOnlyValue != null || relativeValueResolver.isInheritedProperty() && HiddenChildElementSupport.getParentElement(element) != null)) {
                cSSOMReadOnlyValue = relativeValueResolver.getDefaultValue();
            } else if (cSSOMReadOnlyValue != null && cSSOMReadOnlyValue.getImmutableValue() == ImmutableInherit.INSTANCE && HiddenChildElementSupport.getParentElement(element) != null) {
                cSSOMReadOnlyValue = null;
            }
            cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(string2, cSSOMReadOnlyValue, "", 2);
            if (cSSOMReadOnlyValue == null) continue;
            relativeValueResolver.resolveValue(element, string, this, cSSOMReadOnlyStyleDeclaration, cSSOMReadOnlyValue, string3, n);
        }
    }

    protected void addUserAgentProperties(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        CSSOMRuleList cSSOMRuleList = new CSSOMRuleList();
        if (this.userAgentStyleSheet != null) {
            this.addMatchingRules(this.userAgentStyleSheet.getCssRules(), element, string, cSSOMRuleList);
            cSSOMRuleList = this.sortRules(cSSOMRuleList, element, string);
            int n = 0;
            while (n < cSSOMRuleList.getLength()) {
                CSSStyleRule cSSStyleRule = (CSSStyleRule)cSSOMRuleList.item(n);
                CSSStyleDeclaration cSSStyleDeclaration = cSSStyleRule.getStyle();
                int n2 = cSSStyleDeclaration.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    this.setUserAgentProperty(cSSStyleDeclaration.item(n3), cSSStyleDeclaration, cSSOMReadOnlyStyleDeclaration);
                    ++n3;
                }
                ++n;
            }
        }
    }

    protected void setUserAgentProperty(String string, CSSStyleDeclaration cSSStyleDeclaration, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        CSSOMValue cSSOMValue = (CSSOMValue)cSSStyleDeclaration.getPropertyCSSValue(string);
        String string2 = cSSStyleDeclaration.getPropertyPriority(string);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMValue.createReadOnlyCopy();
        cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(string, cSSOMReadOnlyValue, string2, 0);
    }

    protected void addUserProperties(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        CSSOMRuleList cSSOMRuleList = new CSSOMRuleList();
        if (this.userStyleSheet != null) {
            this.addMatchingRules(this.userStyleSheet.getCssRules(), element, string, cSSOMRuleList);
            cSSOMRuleList = this.sortRules(cSSOMRuleList, element, string);
            int n = 0;
            while (n < cSSOMRuleList.getLength()) {
                CSSStyleRule cSSStyleRule = (CSSStyleRule)cSSOMRuleList.item(n);
                CSSStyleDeclaration cSSStyleDeclaration = cSSStyleRule.getStyle();
                int n2 = cSSStyleDeclaration.getLength();
                int n3 = 0;
                while (n3 < n2) {
                    this.setUserProperty(cSSStyleDeclaration.item(n3), cSSStyleDeclaration, cSSOMReadOnlyStyleDeclaration);
                    ++n3;
                }
                ++n;
            }
        }
    }

    protected void setUserProperty(String string, CSSStyleDeclaration cSSStyleDeclaration, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        CSSOMValue cSSOMValue = (CSSOMValue)cSSStyleDeclaration.getPropertyCSSValue(string);
        String string2 = cSSStyleDeclaration.getPropertyPriority(string);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMValue.createReadOnlyCopy();
        cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(string, cSSOMReadOnlyValue, string2, 1);
    }

    protected void addNonCSSPresentationalHints(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        ElementNonCSSPresentationalHints elementNonCSSPresentationalHints;
        CSSStyleDeclaration cSSStyleDeclaration;
        if ((string == null || string.equals("")) && element instanceof ElementNonCSSPresentationalHints && (cSSStyleDeclaration = (elementNonCSSPresentationalHints = (ElementNonCSSPresentationalHints)((Object)element)).getNonCSSPresentationalHints()) != null) {
            int n = cSSStyleDeclaration.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.setAuthorProperty(cSSStyleDeclaration.item(n2), cSSStyleDeclaration, cSSOMReadOnlyStyleDeclaration);
                ++n2;
            }
        }
    }

    protected void addAuthorStyleSheetProperties(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        try {
            CSSOMRuleList cSSOMRuleList = new CSSOMRuleList();
            StyleSheetList styleSheetList = ((DocumentStyle)((Object)this.document)).getStyleSheets();
            int n = 0;
            while (n < styleSheetList.getLength()) {
                this.addMatchingRules(((CSSStyleSheet)styleSheetList.item(n)).getCssRules(), element, string, cSSOMRuleList);
                ++n;
            }
            cSSOMRuleList = this.sortRules(cSSOMRuleList, element, string);
            int n2 = 0;
            while (n2 < cSSOMRuleList.getLength()) {
                CSSStyleRule cSSStyleRule = (CSSStyleRule)cSSOMRuleList.item(n2);
                CSSStyleDeclaration cSSStyleDeclaration = cSSStyleRule.getStyle();
                int n3 = cSSStyleDeclaration.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    this.setAuthorProperty(cSSStyleDeclaration.item(n4), cSSStyleDeclaration, cSSOMReadOnlyStyleDeclaration);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (DOMException dOMException) {
            throw CSSDOMExceptionFactory.createDOMException(dOMException.code, "style.sheet", new Object[]{dOMException.getMessage()});
        }
    }

    protected void addInlineStyleProperties(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        try {
            if (element instanceof ElementCSSInlineStyle) {
                boolean bl = true;
                if (string == null || string.equals("") || element instanceof ExtendedElementCSSInlineStyle) {
                    bl = ((ExtendedElementCSSInlineStyle)((Object)element)).hasStyle();
                }
                if (bl) {
                    CSSStyleDeclaration cSSStyleDeclaration = ((ElementCSSInlineStyle)((Object)element)).getStyle();
                    int n = cSSStyleDeclaration.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        this.setAuthorProperty(cSSStyleDeclaration.item(n2), cSSStyleDeclaration, cSSOMReadOnlyStyleDeclaration);
                        ++n2;
                    }
                }
            }
        }
        catch (DOMException dOMException) {
            throw CSSDOMExceptionFactory.createDOMException(dOMException.code, "inline.style", new Object[]{element.getTagName(), dOMException.getMessage()});
        }
    }

    protected void addOverrideStyleProperties(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        CSSStyleDeclaration cSSStyleDeclaration = ((DocumentCSS)((Object)this.document)).getOverrideStyle(element, string);
        if ((string == null || string.equals("")) && cSSStyleDeclaration != null) {
            int n = cSSStyleDeclaration.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.setAuthorProperty(cSSStyleDeclaration.item(n2), cSSStyleDeclaration, cSSOMReadOnlyStyleDeclaration);
                ++n2;
            }
        }
    }

    protected void setAuthorProperty(String string, CSSStyleDeclaration cSSStyleDeclaration, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
        CSSOMValue cSSOMValue = (CSSOMValue)cSSStyleDeclaration.getPropertyCSSValue(string);
        String string2 = cSSStyleDeclaration.getPropertyPriority(string);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMValue.createReadOnlyCopy();
        CSSValue cSSValue = cSSOMReadOnlyStyleDeclaration.getLocalPropertyCSSValue(string);
        int n = cSSOMReadOnlyStyleDeclaration.getLocalPropertyOrigin(string);
        String string3 = cSSOMReadOnlyStyleDeclaration.getLocalPropertyPriority(string);
        if (cSSValue == null || n != 1 || string3.length() == 0) {
            cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(string, cSSOMReadOnlyValue, string2, 2);
        }
    }

    protected void addMatchingRules(CSSRuleList cSSRuleList, Element element, String string, CSSOMRuleList cSSOMRuleList) {
        int n = cSSRuleList.getLength();
        int n2 = 0;
        while (n2 < n) {
            CSSRule cSSRule = cSSRuleList.item(n2);
            switch (cSSRule.getType()) {
                case 1: {
                    Object object;
                    CSSOMStyleRule cSSOMStyleRule = (CSSOMStyleRule)cSSRule;
                    SelectorList selectorList = cSSOMStyleRule.getSelectors();
                    int n3 = selectorList.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        object = (ExtendedSelector)selectorList.item(n4);
                        if (object.match(element, string)) {
                            cSSOMRuleList.append(cSSRule);
                        }
                        ++n4;
                    }
                    break;
                }
                case 3: {
                    Object object = (CSSImportRule)cSSRule;
                    CSSStyleSheet cSSStyleSheet = object.getStyleSheet();
                    if (cSSStyleSheet == null) break;
                    this.addMatchingRules(cSSStyleSheet.getCssRules(), element, string, cSSOMRuleList);
                    break;
                }
                case 4: {
                    CSSMediaRule cSSMediaRule = (CSSMediaRule)cSSRule;
                    if (!this.mediaMatch(cSSMediaRule.getMedia())) break;
                    this.addMatchingRules(cSSMediaRule.getCssRules(), element, string, cSSOMRuleList);
                }
            }
            ++n2;
        }
    }

    protected CSSOMRuleList sortRules(CSSOMRuleList cSSOMRuleList, Element element, String string) {
        int n;
        CSSOMRuleList cSSOMRuleList2 = new CSSOMRuleList();
        while ((n = cSSOMRuleList.getLength()) > 0) {
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                CSSOMStyleRule cSSOMStyleRule = (CSSOMStyleRule)cSSOMRuleList.item(n4);
                SelectorList selectorList = cSSOMStyleRule.getSelectors();
                int n5 = 0;
                int n6 = selectorList.getLength();
                if (n6 == 1) {
                    n5 = ((ExtendedSelector)selectorList.item(0)).getSpecificity();
                } else {
                    int n7 = 0;
                    while (n7 < n6) {
                        ExtendedSelector extendedSelector = (ExtendedSelector)selectorList.item(n7);
                        if (extendedSelector.match(element, string)) {
                            n5 = extendedSelector.getSpecificity();
                            break;
                        }
                        ++n7;
                    }
                }
                if (n5 < n2) {
                    n2 = n5;
                    n3 = n4;
                }
                ++n4;
            }
            cSSOMRuleList2.append(cSSOMRuleList.item(n3));
            cSSOMRuleList.delete(n3);
        }
        return cSSOMRuleList2;
    }

    protected boolean mediaMatch(MediaList mediaList) {
        if (this.media == null || this.media.getLength() == 0 || mediaList.getLength() == 0) {
            return true;
        }
        int n = 0;
        while (n < mediaList.getLength()) {
            int n2 = 0;
            while (n2 < this.media.getLength()) {
                if (mediaList.item(n).equalsIgnoreCase(this.media.item(n2))) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    protected static class ComputedStyleCache {
        protected Entry[] table = new Entry[11];
        protected int count;

        public void put(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
            Entry entry;
            int n = this.hashCode(element, string) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry2 = this.table[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.match(element, string)) {
                    entry2.computedStyleReference = new SoftReference<CSSOMReadOnlyStyleDeclaration>(cSSOMReadOnlyStyleDeclaration);
                    return;
                }
                entry2 = entry2.next;
            }
            int n3 = this.table.length;
            if (this.count++ >= n3 * 3 >>> 2) {
                this.rehash();
                n2 = n % this.table.length;
            }
            this.table[n2] = entry = new Entry(n, element, string, new SoftReference<CSSOMReadOnlyStyleDeclaration>(cSSOMReadOnlyStyleDeclaration), this.table[n2]);
        }

        public void putPermanent(Element element, String string, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration) {
            Entry entry;
            int n = this.hashCode(element, string) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry2 = this.table[n2];
            while (entry2 != null) {
                if (entry2.hash == n && entry2.match(element, string)) {
                    entry2.computedStyleReference = new StrongReference(cSSOMReadOnlyStyleDeclaration);
                    return;
                }
                entry2 = entry2.next;
            }
            int n3 = this.table.length;
            if (this.count++ >= n3 * 3 >>> 2) {
                this.rehash();
                n2 = n % this.table.length;
            }
            this.table[n2] = entry = new Entry(n, element, string, new StrongReference(cSSOMReadOnlyStyleDeclaration), this.table[n2]);
        }

        public CSSOMReadOnlyStyleDeclaration get(Element element, String string) {
            int n = this.hashCode(element, string) & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            Entry entry = this.table[n2];
            while (entry != null) {
                if (entry.hash == n && entry.match(element, string)) {
                    return (CSSOMReadOnlyStyleDeclaration)entry.computedStyleReference.get();
                }
                entry = entry.next;
            }
            return null;
        }

        protected void rehash() {
            Entry[] entryArray = this.table;
            this.table = new Entry[entryArray.length * 2 + 1];
            int n = entryArray.length - 1;
            while (n >= 0) {
                Entry entry = entryArray[n];
                while (entry != null) {
                    Entry entry2 = entry;
                    entry = entry.next;
                    int n2 = entry2.hash % this.table.length;
                    entry2.next = this.table[n2];
                    this.table[n2] = entry2;
                }
                --n;
            }
        }

        protected void update() {
            int n = this.table.length - 1;
            while (n >= 0) {
                Entry entry = this.table[n];
                Entry entry2 = null;
                if (entry != null) {
                    if (entry.computedStyleReference.get() == null) {
                        this.table[n] = entry.next;
                        --this.count;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                while (entry != null) {
                    if (entry.computedStyleReference.get() == null) {
                        entry2.next = entry.next;
                        --this.count;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                --n;
            }
        }

        public void dispose() {
            int n = this.table.length - 1;
            while (n >= 0) {
                Entry entry = this.table[n];
                Entry entry2 = null;
                if (entry != null) {
                    if (entry.computedStyleReference instanceof StrongReference) {
                        this.table[n] = entry.next;
                        --this.count;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                while (entry != null) {
                    if (entry.computedStyleReference instanceof StrongReference) {
                        entry2.next = entry.next;
                        --this.count;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                --n;
            }
        }

        protected int hashCode(Element element, String string) {
            return element.hashCode() ^ string.hashCode();
        }

        protected static class Entry {
            public int hash;
            public Element element;
            public String pseudoElement;
            public SoftReference computedStyleReference;
            public Entry next;

            public Entry(int n, Element element, String string, SoftReference softReference, Entry entry) {
                this.hash = n;
                this.element = element;
                this.pseudoElement = string;
                this.computedStyleReference = softReference;
                this.next = entry;
            }

            public boolean match(Element element, String string) {
                return element == this.element && string.equals(this.pseudoElement);
            }
        }

        protected static class StrongReference
        extends SoftReference {
            protected Object reference;

            public StrongReference(Object object) {
                super(object);
                this.reference = object;
            }
        }
    }
}

