/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css;

import org.apache.batik.css.AbstractViewCSS;
import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.HiddenChildElementSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMReadOnlyStyleDeclaration
implements CSSStyleDeclaration {
    public static final int USER_AGENT_ORIGIN = 0;
    public static final int USER_ORIGIN = 1;
    public static final int AUTHOR_ORIGIN = 2;
    protected PropertyMap properties = new PropertyMap();
    protected AbstractViewCSS viewCSS;
    protected Element parentElement;

    public CSSOMReadOnlyStyleDeclaration(AbstractViewCSS abstractViewCSS, Element element) {
        this.setContext(abstractViewCSS, element);
    }

    public void setContext(AbstractViewCSS abstractViewCSS, Element element) {
        this.viewCSS = abstractViewCSS;
        this.parentElement = HiddenChildElementSupport.getParentElement(element);
    }

    public String getCssText() {
        String string = "";
        int n = this.properties.size() - 1;
        while (n >= 0) {
            string = string + "    " + this.properties.key(n) + ": ";
            ValueEntry valueEntry = this.properties.item(n);
            if (valueEntry.value != null) {
                string = string + valueEntry.value.getCssText();
            }
            string = string + valueEntry.getPriority() + ";\n";
            --n;
        }
        return string;
    }

    public void setCssText(String string) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)7, "readonly.declaration", new Object[0]);
    }

    public String getPropertyValue(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = this.properties.get(string2);
        if (valueEntry == null) {
            return "";
        }
        if (valueEntry.value == null) {
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(this.parentElement, null);
            return cSSStyleDeclaration.getPropertyCSSValue(string2).getCssText();
        }
        return valueEntry.value.getCssText();
    }

    public CSSValue getPropertyCSSValue(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = this.properties.get(string2);
        if (valueEntry == null) {
            return null;
        }
        if (valueEntry.value == null) {
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(this.parentElement, null);
            CSSOMReadOnlyValue cSSOMReadOnlyValue = (CSSOMReadOnlyValue)cSSStyleDeclaration.getPropertyCSSValue(string2);
            valueEntry.value = new CSSOMReadOnlyValue(cSSOMReadOnlyValue.getImmutableValue());
            return valueEntry.value;
        }
        return valueEntry.value;
    }

    public CSSOMReadOnlyValue getPropertyCSSValueInternal(String string) {
        ValueEntry valueEntry = this.properties.get(string);
        if (valueEntry == null) {
            return null;
        }
        if (valueEntry.value == null) {
            CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = this.viewCSS.getComputedStyleInternal(this.parentElement, null);
            CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal(string);
            valueEntry.value = new CSSOMReadOnlyValue(cSSOMReadOnlyValue.getImmutableValue());
            return valueEntry.value;
        }
        return valueEntry.value;
    }

    public CSSValue getLocalPropertyCSSValue(String string) {
        ValueEntry valueEntry = this.properties.get(string);
        return valueEntry == null ? null : valueEntry.value;
    }

    public void setPropertyCSSValue(String string, CSSValue cSSValue, String string2, int n) {
        this.properties.put(string, (CSSOMReadOnlyValue)cSSValue, string2, n);
    }

    public int getPropertyOrigin(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = this.properties.get(string2);
        if (valueEntry == null) {
            return 2;
        }
        if (valueEntry.value == null) {
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(this.parentElement, null);
            return ((CSSOMReadOnlyStyleDeclaration)cSSStyleDeclaration).getPropertyOrigin(string2);
        }
        return valueEntry.getOrigin();
    }

    public int getLocalPropertyOrigin(String string) {
        ValueEntry valueEntry = this.properties.get(string);
        return valueEntry == null ? 2 : valueEntry.getOrigin();
    }

    public String removeProperty(String string) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)7, "readonly.declaration", new Object[0]);
    }

    public String getPropertyPriority(String string) {
        String string2 = string.toLowerCase().intern();
        ValueEntry valueEntry = this.properties.get(string2);
        if (valueEntry == null) {
            return "";
        }
        if (valueEntry.value == null) {
            CSSStyleDeclaration cSSStyleDeclaration = this.viewCSS.getComputedStyle(this.parentElement, null);
            return ((CSSOMReadOnlyStyleDeclaration)cSSStyleDeclaration).getPropertyPriority(string2);
        }
        return valueEntry.getPriority();
    }

    public String getLocalPropertyPriority(String string) {
        ValueEntry valueEntry = this.properties.get(string);
        return valueEntry == null ? "" : valueEntry.getPriority();
    }

    public void setProperty(String string, String string2, String string3) throws DOMException {
        throw CSSDOMExceptionFactory.createDOMException((short)7, "readonly.declaration", new Object[0]);
    }

    public int getLength() {
        return this.properties.size();
    }

    public String item(int n) {
        String string = this.properties.key(n);
        return string == null ? "" : string;
    }

    public CSSRule getParentRule() {
        return null;
    }

    protected static ValueEntry createValueEntry(CSSOMReadOnlyValue cSSOMReadOnlyValue, String string, int n) {
        switch (n) {
            case 0: {
                if (string.length() == 0) {
                    return new UserAgentValueEntry(cSSOMReadOnlyValue);
                }
                return new ImportantUserAgentValueEntry(cSSOMReadOnlyValue);
            }
            case 1: {
                if (string.length() == 0) {
                    return new UserValueEntry(cSSOMReadOnlyValue);
                }
                return new ImportantUserValueEntry(cSSOMReadOnlyValue);
            }
            case 2: {
                if (string.length() == 0) {
                    return new AuthorValueEntry(cSSOMReadOnlyValue);
                }
                return new ImportantAuthorValueEntry(cSSOMReadOnlyValue);
            }
        }
        throw new RuntimeException();
    }

    protected static class PropertyMap {
        protected static final int INITIAL_CAPACITY = 11;
        protected ValueEntry[] table = new ValueEntry[11];
        protected int count;

        public int size() {
            return this.count;
        }

        public ValueEntry get(String string) {
            int n = string.hashCode() & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            ValueEntry valueEntry = this.table[n2];
            while (valueEntry != null) {
                if (valueEntry.hash == n && valueEntry.key == string) {
                    return valueEntry;
                }
                valueEntry = valueEntry.next;
            }
            return null;
        }

        public void put(String string, CSSOMReadOnlyValue cSSOMReadOnlyValue, String string2, int n) {
            int n2 = string.hashCode() & Integer.MAX_VALUE;
            int n3 = n2 % this.table.length;
            ValueEntry valueEntry = null;
            ValueEntry valueEntry2 = this.table[n3];
            while (valueEntry2 != null) {
                if (valueEntry2.hash == n2 && valueEntry2.key == string) {
                    if (valueEntry2.getPriority().equals(string2) && valueEntry2.getOrigin() == n) {
                        valueEntry2.value = cSSOMReadOnlyValue;
                    } else {
                        ValueEntry valueEntry3 = CSSOMReadOnlyStyleDeclaration.createValueEntry(cSSOMReadOnlyValue, string2, n);
                        valueEntry3.initialize(n2, string, valueEntry2.next);
                        if (valueEntry == null) {
                            this.table[n3] = valueEntry3;
                        } else {
                            valueEntry.next = valueEntry3;
                        }
                    }
                    return;
                }
                valueEntry = valueEntry2;
                valueEntry2 = valueEntry2.next;
            }
            int n4 = this.table.length;
            if (this.count++ >= n4 * 3 >>> 2) {
                this.rehash();
                n3 = n2 % this.table.length;
            }
            ValueEntry valueEntry4 = CSSOMReadOnlyStyleDeclaration.createValueEntry(cSSOMReadOnlyValue, string2, n);
            valueEntry4.initialize(n2, string, this.table[n3]);
            this.table[n3] = valueEntry4;
        }

        public void put(String string, ValueEntry valueEntry) {
            int n = string.hashCode() & Integer.MAX_VALUE;
            int n2 = n % this.table.length;
            ValueEntry valueEntry2 = null;
            ValueEntry valueEntry3 = this.table[n2];
            while (valueEntry3 != null) {
                if (valueEntry3.hash == n && valueEntry3.key == string) {
                    if (valueEntry3.getPriority().equals(valueEntry.getPriority()) && valueEntry3.getOrigin() == valueEntry.getOrigin()) {
                        valueEntry3.value = valueEntry.value;
                    } else {
                        ValueEntry valueEntry4 = CSSOMReadOnlyStyleDeclaration.createValueEntry(valueEntry.value, valueEntry.getPriority(), valueEntry.getOrigin());
                        valueEntry.initialize(n, string, valueEntry3.next);
                        if (valueEntry2 == null) {
                            this.table[n2] = valueEntry4;
                        } else {
                            valueEntry2.next = valueEntry4;
                        }
                    }
                    return;
                }
                valueEntry2 = valueEntry3;
                valueEntry3 = valueEntry3.next;
            }
            int n3 = this.table.length;
            if (this.count++ >= n3 * 3 >>> 2) {
                this.rehash();
                n2 = n % this.table.length;
            }
            ValueEntry valueEntry5 = CSSOMReadOnlyStyleDeclaration.createValueEntry(valueEntry.value, valueEntry.getPriority(), valueEntry.getOrigin());
            valueEntry5.initialize(n, string, this.table[n2]);
            this.table[n2] = valueEntry5;
        }

        public String key(int n) {
            if (n < 0 || n >= this.count) {
                return null;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.table.length) {
                ValueEntry valueEntry = this.table[n3];
                if (valueEntry != null) {
                    do {
                        if (n2++ != n) continue;
                        return valueEntry.key;
                    } while ((valueEntry = valueEntry.next) != null);
                }
                ++n3;
            }
            return null;
        }

        public ValueEntry item(int n) {
            if (n < 0 || n >= this.count) {
                return null;
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.table.length) {
                ValueEntry valueEntry = this.table[n3];
                if (valueEntry != null) {
                    do {
                        if (n2++ != n) continue;
                        return valueEntry;
                    } while ((valueEntry = valueEntry.next) != null);
                }
                ++n3;
            }
            return null;
        }

        protected void rehash() {
            ValueEntry[] valueEntryArray = this.table;
            this.table = new ValueEntry[valueEntryArray.length * 2 + 1];
            int n = valueEntryArray.length - 1;
            while (n >= 0) {
                ValueEntry valueEntry = valueEntryArray[n];
                while (valueEntry != null) {
                    ValueEntry valueEntry2 = valueEntry;
                    valueEntry = valueEntry.next;
                    int n2 = valueEntry2.hash % this.table.length;
                    valueEntry2.next = this.table[n2];
                    this.table[n2] = valueEntry2;
                }
                --n;
            }
        }
    }

    protected static class AuthorValueEntry
    extends ValueEntry {
        public AuthorValueEntry(CSSOMReadOnlyValue cSSOMReadOnlyValue) {
            this.value = cSSOMReadOnlyValue;
        }

        public String getPriority() {
            return "";
        }

        public int getOrigin() {
            return 2;
        }
    }

    protected static class ImportantAuthorValueEntry
    extends ValueEntry {
        public ImportantAuthorValueEntry(CSSOMReadOnlyValue cSSOMReadOnlyValue) {
            this.value = cSSOMReadOnlyValue;
        }

        public String getPriority() {
            return "!important";
        }

        public int getOrigin() {
            return 2;
        }
    }

    protected static class UserValueEntry
    extends ValueEntry {
        public UserValueEntry(CSSOMReadOnlyValue cSSOMReadOnlyValue) {
            this.value = cSSOMReadOnlyValue;
        }

        public String getPriority() {
            return "";
        }

        public int getOrigin() {
            return 1;
        }
    }

    protected static class ImportantUserValueEntry
    extends ValueEntry {
        public ImportantUserValueEntry(CSSOMReadOnlyValue cSSOMReadOnlyValue) {
            this.value = cSSOMReadOnlyValue;
        }

        public String getPriority() {
            return "!important";
        }

        public int getOrigin() {
            return 1;
        }
    }

    protected static class UserAgentValueEntry
    extends ValueEntry {
        public UserAgentValueEntry(CSSOMReadOnlyValue cSSOMReadOnlyValue) {
            this.value = cSSOMReadOnlyValue;
        }

        public String getPriority() {
            return "";
        }

        public int getOrigin() {
            return 0;
        }
    }

    protected static class ImportantUserAgentValueEntry
    extends ValueEntry {
        public ImportantUserAgentValueEntry(CSSOMReadOnlyValue cSSOMReadOnlyValue) {
            this.value = cSSOMReadOnlyValue;
        }

        public String getPriority() {
            return "!important";
        }

        public int getOrigin() {
            return 0;
        }
    }

    protected static abstract class ValueEntry {
        public int hash;
        public String key;
        public CSSOMReadOnlyValue value;
        public ValueEntry next;

        protected ValueEntry() {
        }

        public abstract String getPriority();

        public abstract int getOrigin();

        public void initialize(int n, String string, ValueEntry valueEntry) {
            this.hash = n;
            this.key = string;
            this.next = valueEntry;
        }
    }
}

